package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;


import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;

import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GiveItem;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Pick;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PutDownItem;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GiveItemResult;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;


/**
 * Module helping us handle items in UnrealEngine2Runtime.
 * @author knight
 */
public class Inventory extends SensomotoricModule<UT2004Bot> {
    
    GiveItemResult lastGiveItemResult = null;

    /**
     * Listener for responses for giveItem command.
     */
    IWorldEventListener<GiveItemResult> giveItemResultListener = new IWorldEventListener<GiveItemResult>() {
        @Override
        public void notify(GiveItemResult event) {
            lastGiveItemResult = event;
        }    
    };

    /**
     * Returns last result of give item command.
     * @return
     */
    public GiveItemResult getLastGiveItemResult() {
        return lastGiveItemResult;
    }

    /**
     * Gives item to input bot. Bot has to within reach (200 ut units ~ 200 cm)!
     * @param pl
     * @param item
     */
    public void giveItem(Player pl, ItemType item) {
        act.act(new GiveItem().setId(pl.getId()).setType(item.getUE2Name()));
    }

    /**
     * Gives item to input bot. Bot has to within reach (200 ut units ~ 200 cm)!
     * @param id
     * @param item
     */
    public void giveItem(UnrealId id, ItemType item) {
        act.act(new GiveItem().setId(id).setType(item.getUE2Name()));
    }
    
    /**
     * Puts item down at the location of the bot.
     * @param item
     */
    public void putDownItem(ItemType item) {
        act.act(new PutDownItem().setType(item.getUE2Name()));
    }

    /**
     * Picks item at the location of the bot - bot has to be touching the item.
     * @param id
     */
    public void pickItem(UnrealId id) {
        act.act(new Pick().setId(id));
    }

    /**
     * Default constructor.
     * @param agent
     */
    public Inventory(UT2004Bot agent) {
        super(agent);
        agent.getWorldView().addEventListener(GiveItemResult.class, giveItemResultListener);
    }
}
