package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import SteeringProperties.LeaderFollowingProperties;
import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.PathFollowingProperties;
import SteeringProperties.PeopleAvoidanceProperties;
import SteeringProperties.StickToPathProperties;
import SteeringProperties.TargetApproachingProperties;
import SteeringProperties.WalkAlongProperties;
import SteeringProperties.WallFollowingProperties;
import SteeringStuff.SteeringManager;
import SteeringStuff.SteeringType;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import java.util.logging.Logger;

/**
 * Module wrapping steerings control - SteeringManager object. Depends on UT2004SteeringLibrary
 *(<groupId>cz.cuni.amis.pogamut.ut2004.steerings</groupId>,
  <artifactId>UT2004SteeringLibrary</artifactId>).
 * @author knight
 */
public class Steering extends SensomotoricModule<UT2004Bot> {

    /** our steering manager */
    SteeringManager steeringManager;

    public LeaderFollowingProperties getLeaderFollowingProperties() {
        return steeringManager.getLeaderFollowingProperties();
    }

    public ObstacleAvoidanceProperties getObstacleAvoidanceProperties() {
        return steeringManager.getObstacleAvoidanceProperties();
    }

    public PathFollowingProperties getPathFollowingProperties() {
        return steeringManager.getPathFollowingProperties();
    }

    public PeopleAvoidanceProperties getPeopleAvoidanceProperties() {
        return steeringManager.getPeopleAvoidanceProperties();
    }

    public TargetApproachingProperties getTargetApproachingProperties() {
        return steeringManager.getTargetApproachingProperties();
    }

    public WalkAlongProperties getWalkAlongProperties() {
        return steeringManager.getWalkAlongProperties();
    }

    public WallFollowingProperties getWallFollowingProperties() {
        return steeringManager.getWallFollowingProperties();
    }

    public SteeringManager getSteeringManager() {
        return steeringManager;
    }

    public void addLeaderFollowingSteering(LeaderFollowingProperties properties) {
        steeringManager.addLeaderFollowingSteering(properties);
    }

    public void removeLeaderFollowingSteering() {
        steeringManager.removeLeaderFollowingSteering();
    }

    public void setLeaderFollowingSteering(LeaderFollowingProperties properties) {
        steeringManager.setLeaderFollowingSteering(properties);
    }

    public boolean isLeaderFollowingActive() {
        return steeringManager.hasSteering(SteeringType.LEADER_FOLLOWING);
    }

    public void addObstacleAvoidanceSteering(ObstacleAvoidanceProperties properties) {
        steeringManager.addObstacleAvoidanceSteering( properties);
    }

    public void removeObstacleAvoidanceSteering() {
        steeringManager.removeObstacleAvoidanceSteering();
    }

    public void setObstacleAvoidanceSteering(ObstacleAvoidanceProperties properties) {
        steeringManager.setObstacleAvoidanceSteering(properties);
    }

    public boolean isObstacleAvoidanceActive() {
        return steeringManager.hasSteering(SteeringType.OBSTACLE_AVOIDANCE);
    }

    public void addPathFollowingSteering(PathFollowingProperties properties) {
        steeringManager.addPathFollowingSteering(properties);
    }

    public void removePathFollowingSteering() {
        steeringManager.removePathFollowingSteering();
    }

    public void setPathFollowingSteering(PathFollowingProperties properties) {
        steeringManager.setPathFollowingSteering(properties);
    }

    public boolean isPathFollowingActive() {
        return steeringManager.hasSteering(SteeringType.PATH_FOLLOWING);
    }

    public void addPeopleAvoidanceSteering(PeopleAvoidanceProperties properties) {
        steeringManager.addPeopleAvoidanceSteering( properties);
    }

    public void removePeopleAvoidanceSteering() {
        steeringManager.removePeopleAvoidanceSteering();
    }

    public void setPeopleAvoidanceSteering(PeopleAvoidanceProperties properties) {
        steeringManager.setPeopleAvoidanceSteering(properties);
    }

    public boolean isPeopleAvoidanceActive() {
        return steeringManager.hasSteering(SteeringType.PEOPLE_AVOIDANCE);
    }
    
    public void addTargetApproachingSteering(TargetApproachingProperties properties) {
        steeringManager.addTargetApproachingSteering(properties);
    }

    public void removeTargetApproachingSteering() {
        steeringManager.removeTargetApproachingSteering();
    }

    public void setTargetApproachingSteering(TargetApproachingProperties properties) {
        steeringManager.setTargetApproachingSteering(properties);
    }

    public boolean isTargetApproachingActive() {
        return steeringManager.hasSteering(SteeringType.TARGET_APPROACHING);
    }

    public void addWalkAlongSteering(WalkAlongProperties properties) {
        steeringManager.addWalkAlongSteering(properties);
    }

    public void removeWalkAlongSteering() {
        steeringManager.removeWalkAlongSteering();
    }
    
    public void setWalkAlongSteering(WalkAlongProperties properties) {
        steeringManager.setWalkAlongSteering(properties);
    }

    public boolean isWalkAlongActive() {
        return steeringManager.hasSteering(SteeringType.WALK_ALONG);
    }
    
    public void addWallFollowingSteering(WallFollowingProperties properties) {
        steeringManager.addWallFollowingSteering(properties);
    }

    public void removeWallFollowingSteering() {
        steeringManager.removeWallFollowingSteering();
    }
    
    public void setWallFollowingSteering(WallFollowingProperties properties) {
        steeringManager.setWallFollowingSteering(properties);
    }

    public boolean isWallFollowingActive() {
        return steeringManager.hasSteering(SteeringType.WALL_FOLLOWING);
    }
    
    public void addStickToPathSteering(StickToPathProperties stickToPathProperties) {
		steeringManager.addStickToPathSteering(stickToPathProperties);		
	}
    
    public void removeStickToPathSteering() {
        steeringManager.removeStickToPathSteering();
    }
    
    public void setStickToPathSteering(StickToPathProperties properties) {
        steeringManager.setStickToPathSteering(properties);
    }

    public boolean isStickToPathSteering() {
        return steeringManager.hasSteering(SteeringType.STICK_TO_PATH);
    }

    
    /**
     * Starts navigation using set steerings.
     */
    public void startNavigation() {
        steeringManager.start();
    }

    /**
     * Stops navigation (leaving the steerings settings as they are for further resuming).
     */
    public void stopNavigation() {
        steeringManager.stop();
    }

    /**
     * Returns whether we are we currently using steerings for navigation.
     * @return
     */
    public boolean isNavigating() {
        return steeringManager.isNavigating();
    }
    
    /**
     * Removes all set steerings.
     */
    public void clearAllSteerings() {
        steeringManager.clearSteerings();
    }

    public Steering(UT2004Bot agent, Logger log) {
        super(agent, log);
        steeringManager = new SteeringManager(agent, new Raycasting(agent),new AdvancedLocomotion(agent, log));
    }

    public Steering(UT2004Bot agent) {
        super(agent);
        steeringManager = new SteeringManager(agent,new Raycasting(agent), new AdvancedLocomotion(agent, log));
    }

}
