package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

/**
 * Enum holding all available animations for all characters. Not every character supports
 * every animation!
 * @author Knight
 */
public enum AnimType {
AMBI_CANCAN("ambi_cancan","a_kankán","a_cancan",4800),
AMBI_IMPATIENT("ambi_impatient","a_stání netrpělivé","a_stand impatient",12000),
AMBI_LOOKAROUND01("ambi_lookaround01","a_rozhlížení se 1","a_looking around 1",6666),
AMBI_LOOKAROUND02("ambi_lookaround02","a_rozhlížení se 2","a_looking around 2",8000),
AMBI_LOOKBACK("ambi_lookback","a_otočení se přes rameno","a_looking back",3266),
AMBI_LOOKLEFT("ambi_lookleft","a_pohled vlevo","a_looking left",1266),
AMBI_LOOKRIGHT("ambi_lookright","a_pohled vpravo","a_looking right",3200),
AMBI_SCRATCH("ambi_scratch","a_škrábu se na pozadí","a_scratch",2000),
AMBI_SMSREAD("ambi_smsread","a_čtení sms","a_reading sms",7833),
AMBI_STAND_ANGRY01("ambi_stand_angry01","a_stání naštvané 1","a_stand angry 1",9333),
AMBI_STAND_ANGRY02("ambi_stand_angry02","a_stání naštvané 2","a_stand angry 2",9933),
AMBI_STAND_ANGRY03("ambi_stand_angry03","a_stání naštvané 3","a_stand angry 3",9900),
AMBI_STAND_ANGRY03A("ambi_stand_angry03A","a_stání naštvané 3A","a_stand angry 3A",3333),
AMBI_STAND_ANGRY03B("ambi_stand_angry03B","a_stání naštvané 3B","a_stand angry 3B",6666),
AMBI_STAND_ANGRY04("ambi_stand_angry04","a_stání naštvané 4","a_stand angry 4",9966),
AMBI_STAND_ANGRY04A("ambi_stand_angry04A","a_stání naštvané 4A","a_stand angry 4A",4366),
AMBI_STAND_ANGRY04B("ambi_stand_angry04B","a_stání naštvané 4B","a_stand angry 4B",5633),
AMBI_STAND_CONFIDENT("ambi_stand_confident","a_stání sebevědomé","a_stand confident",12666),
AMBI_STAND_DEPRESSED("ambi_stand_depressed","a_stání depresivní","a_stand depressed",7500),
AMBI_STAND_HAPPY("ambi_stand_happy","a_stání veselé","a_stand happy",14000),
AMBI_STAND_NORMAL01("ambi_stand_normal01","a_stání normální 1","a_stand normal 1",12833),
AMBI_STAND_NORMAL02("ambi_stand_normal02","a_stání normální 2","a_stand normal 2",13333),
AMBI_STAND_SEXY("ambi_stand_sexy","a_stání sexy","a_stand sexy",13333),
AMBI_STAND_SICK01("ambi_stand_sick01","a_stání nevolnost 1","a_stand sick 1",9000),
AMBI_STAND_SICK02("ambi_stand_sick02","a_stání nevolnost 2","a_stand sick 2",9000),
AMBI_STAND_WALL01("ambi_stand_wall01","a_stání u stěny 1","a_stand wall 1",6666),
AMBI_STAND_WALL02("ambi_stand_wall02","a_stání u stěny 2","a_stand wall 2",6666),
AMBI_THOUGHTFUL("ambi_thoughtful","a_zamyšlení","a_thinking",5733),
AMBI_THOUGHTFULTURN("ambi_thoughtfulturn","a_zamyšlené otáčení","a_thoughtful turning",6700),
AMBI_YAWN("ambi_yawn","a_zívnutí","a_yawning",5666),
CAMERA_ACTIVE("active","aktivní","active",1000),
CAMERA_INACTIVE("inactive","neaktivní","inactive",1000),
EMOHAWK_DIE01("die01","a_smrt 1","a_die 1",2033),
EMOHAWK_DIE02("die02","a_smrt 2","a_die 2",2033),
EMOHAWK_DIZZY("dizzy","a_omámený","a_dizzy",6033),
EMOHAWK_EEK("eek","a_je mu špatně","a_eek",6367),
EMOHAWK_EEKFLY("eekfly","a_sražen dozadu","a_eek fly",2500),
EMOHAWK_EXPEL("expel","a_plive","a_expel",1533),
EMOHAWK_GROWL("growl","a_vrčí","a_growl",4000),
EMOHAWK_GROWLKICK("growlkick","a_vrčí a kope","a_growl kick",2700),
EMOHAWK_LIE("lie","s_leží","s_lie",13367),
EMOHAWK_LOOKAROUND("lookaround","s_rozhlíží se","s_look around",8033),
EMOHAWK_PREEN("preen","a_rovná se","a_preen",9700),
EMOHAWK_SHELTER("shelter","a_kryje se","a_shelter",5033),
EMOHAWK_SIPHON("siphon","a_saje","a_siphon",4000),
EMOHAWK_SIT01("sit01","s_sedí 1","s_sit 1",13033),
EMOHAWK_SIT02("sit02","s_sedí 2","s_sit 2",8367),
EMOHAWK_SITONGROUND("sitonground","s_sedí na zemi","s_sit on hround",6700),
EMOHAWK_STANDIDLE01("standidle01","s_stojí a čeká 1","s_stand idle 1",5367),
EMOHAWK_STANDIDLE02("standidle02","s_stojí a čeká 2","s_stand idle 2",13367),
EMOHAWK_STANDIDLE03("standidle03","s_stojí a čeká 3","s_stand idle 3",13367),
EXT_PROPANIMATIONS_BABY_BUGGYIDLE_01("propanimations_baby_buggyidle_01","stání u kočárku","standing next to baby buggy",31333),
EXT_PROPANIMATIONS_BABY_BUGGYLISTEN_01("propanimations_baby_buggylisten_01","poslouchání u kočárku","listening next to baby buggy",26067),
EXT_PROPANIMATIONS_BABY_BUGGYTALK_01("propanimations_baby_buggytalk_01","mluvení u kočárku","talking next to baby buggy",26067),
EXT_PROPANIMATIONS_CELLPHONE_LISTEN_01("propanimations_cellphone_listen_01","poslouchání mobilu ","listening to cell phone",37633),
EXT_PROPANIMATIONS_CELLPHONE_TALK_01("propanimations_cellphone_talk_01","mluvení do mobilu 1 ","talking via cell phone 1",31933),
EXT_PROPANIMATIONS_CELLPHONE_TALK_02("propanimations_cellphone_talk_02","mluvení do mobilu 2 ","talking via cell phone 2 ",28500),
EXT_PROPANIMATIONS_CELLPHONE_TEXTMESSAGE_01("propanimations_cellphone_textmessage_01","psaní SMS","texting",20567),
EXT_PROPANIMATIONS_CELLPHONE_WALK_01("propanimations_cellphone_walk_01","chůze - telefonování ","walking - cell phoning ",1167),
EXT_PROPANIMATIONS_DOCUMENTFILE_IDLE_01("propanimations_documentfile_idle_01","diplomatka v ruce ","document file in hand",26700),
EXT_PROPANIMATIONS_DRINK_DRINKING_01("propanimations_drink_drinking_01","pití ","drinking ",35033),
EXT_PROPANIMATIONS_DRINK_IDLE_01("propanimations_drink_idle_01","pití v ruce ","drink in hand ",31433),
EXT_PROPANIMATIONS_DRINK_WALK_01("propanimations_drink_walk_01","chůze - s pitím v ruce ","walking with drink in hand ",1333),
EXT_PROPANIMATIONS_HEADPHONES_IDLE_01("propanimations_headphones_idle_01","stání - dotyk mušle sluchátek","standing - touching headphones",33033),
EXT_PROPANIMATIONS_HEADPHONES_WALK_01("propanimations_headphones_walk_01","chůze - dotyk mušle sluchátek","walking - touching headphones",1133),
EXT_PROPANIMATIONS_HOLDBAG_IDLE_01("propanimations_holdbag_idle_01","taška v ruce ","bag in hand ",25500),
EXT_PROPANIMATIONS_HOLDPISTOL_BREATHE_01("propanimations_holdpistol_breathe_01","pistole v ruce, dýchání ","holding pistol, breathing ",2767),
EXT_PROPANIMATIONS_HOLDPISTOL_IDLE_01("propanimations_holdpistol_idle_01","pistole v ruce ","pistol in hand ",26900),
EXT_PROPANIMATIONS_HOLDPISTOL_IN_01("propanimations_holdpistol_in_01","vyndání pistole ","drawing pistol ",3867),
EXT_PROPANIMATIONS_HOLDPISTOL_OUT_01("propanimations_holdpistol_out_01","zandání pistole ","hiding drawn pistol ",3500),
EXT_PROPANIMATIONS_IDLE_DOCUMENTFILE_01("propanimations_idle_documentfile_01","diplomatka v ruce ","document file in hand ",34033),
EXT_PROPANIMATIONS_IDLE_HEADPHONES_01("propanimations_idle_headphones_01","dotyk mušle sluchátek ","touching headphones ",25733),
EXT_PROPANIMATIONS_IDLE_HOLDBAG_01("propanimations_idle_holdbag_01","taška v ruce ","bag in hand ",35467),
EXT_PROPANIMATIONS_MODERATE_01("propanimations_moderate_01","moderování 1 ","moderating 1 ",36533),
EXT_PROPANIMATIONS_MODERATE_02("propanimations_moderate_02","moderování 2 ","moderating 2 ",25767),
EXT_PROPANIMATIONS_NEWSPAPER_ARMIDLE_01("propanimations_newspaper_armidle_01","stání - noviny v ruce 1 ","standing - newspaper in hand 1",35300),
EXT_PROPANIMATIONS_NEWSPAPER_ARMWALK_01("propanimations_newspaper_armwalk_01","chůze - noviny v ruce","walking - newspaper in hand",1200),
EXT_PROPANIMATIONS_NEWSPAPER_HANDIDLE_01("propanimations_newspaper_handidle_01","stání - noviny v ruce 2 ","standing - newspaper in hand 2 ",31433),
EXT_PROPANIMATIONS_NEWSPAPER_IDLEARM_01("propanimations_newspaper_idlearm_01","stání - noviny v ruce 1 ","standing - newspaper in hand 1",26700),
EXT_PROPANIMATIONS_NEWSPAPER_IDLEHAND_01("propanimations_newspaper_idlehand_01","stání - noviny v ruce 2","standing - newspaper in hand 2",34600),
EXT_PROPANIMATIONS_PISTOL_HOLDBREATHE_01("propanimations_pistol_holdbreathe_01","pistole v ruce, dýchání ","holding pistol, breathing ",5567),
EXT_PROPANIMATIONS_PISTOL_HOLDIN_01("propanimations_pistol_holdin_01","vyndání pistole ","drawing pistol ",3067),
EXT_PROPANIMATIONS_PISTOL_HOLDOUT_01("propanimations_pistol_holdout_01","zandání pistole ","hiding drawn pistol ",2333),
EXT_PROPANIMATIONS_PISTOL_IDLE_01("propanimations_pistol_idle_01","pistole v ruce ","pistol in hand ",31900),
EXT_PROPANIMATIONS_RIDE_BICYCLE_01("propanimations_ride_bicycle_01","jízda na kole ","riding bicicle ",1100),
EXT_PROPANIMATIONS_RIDE_BYCICLE_01("propanimations_ride_bycicle_01","jízda na kole ","riding bicicle ",1100),
EXT_PROPANIMATIONS_TAKE_PICTURE_01("propanimations_take_picture_01","focení ","taking photograph ",8533),
EXT_PROPANIMATIONS_TROLLEY_IDLE_01("propanimations_trolley_idle_01","ruka na zábradlí ","hand on banister ",32300),
EXT_PROPANIMATIONS_TROLLEY_WALK_01("propanimations_trolley_walk_01","chůze s rukou na zábradlí ","walking with hand on banister ",1200),
EXT_PROPANIMATIONS_UMBRELLA_IDLE_01("propanimations_umbrella_idle_01","deštník v ruce 1 ","umbrella in hand 1",42167),
EXT_PROPANIMATIONS_UMBRELLA_IDLE_02("propanimations_umbrella_idle_02","deštník v ruce 2 ","umbrella in hand 2 ",31433),
EXT_PROPANIMATIONS_UMBRELLA_WALK_01("propanimations_umbrella_walk_01","chůze s deštníkem ","walking with umbrella ",1467),
EXT_SITTING_CHAIR_BREATHE_01("sitting_chair_breathe_01","sezení - nádech","sitting - breathing ",12733),
EXT_SITTING_CHAIR_COUGH_01("sitting_chair_cough_01","sezení - zakašlání ","sitting - coughing ",5233),
EXT_SITTING_CHAIR_DUST_01("sitting_chair_dust_01","sezení - oprášení se ","sitting - dusting ",8567),
EXT_SITTING_CHAIR_FINGERNAIL_01("sitting_chair_fingernail_01","sezení - zkoumání nehtů","sitting - checking fingernails",6867),
EXT_SITTING_CHAIR_LOOKAROUND_01("sitting_chair_lookaround_01","sezení - rozhlížení se ","sitting - looking around ",8700),
EXT_SITTING_CHAIR_NERVOUS_01("sitting_chair_nervous_01","sezení - nervózní ","sitting - nervous ",44500),
EXT_SITTING_CHAIR_NEUTRAL_01("sitting_chair_neutral_01","sezení - neutrální 1 ","sitting - neutral 1 ",36133),
EXT_SITTING_CHAIR_NEUTRAL_02("sitting_chair_neutral_02","sezení - neutrální 2 ","sitting - neutral 2 ",39267),
EXT_SITTING_CHAIR_RELAXED_01("sitting_chair_relaxed_01","sezení - v pohodě ","sitting - relaxed ",36433),
EXT_SITTING_CHAIR_ROLLHEAD_01("sitting_chair_rollhead_01","sezení - kroužení hlavou ","sitting - rolling head ",9667),
EXT_SITTING_CHAIR_SCRATCHHEAD_01("sitting_chair_scratchhead_01","sezení - podrbání na hlavě ","sitting - scratching head ",6467),
EXT_SITTING_CHAIR_SHRUG_01("sitting_chair_shrug_01","sezení - protažení 1 ","sitting - shrugging 1 ",3033),
EXT_SITTING_CHAIR_SHRUG_02("sitting_chair_shrug_02","sezení - protažení 2 ","sitting - shrugging 2 ",3367),
EXT_SITTING_CHAIR_SITDOWNLEFT_01("sitting_chair_sitdownleft_01","posazení se zleva ","sitting down from left side ",3933),
EXT_SITTING_CHAIR_SITDOWNRIGHT_01("sitting_chair_sitdownright_01","posazení se zprava ","sitting down from right side ",4133),
EXT_SITTING_CHAIR_SITDOWN_01("sitting_chair_sitdown_01","posazení se 1 ","sitting down 1 ",2933),
EXT_SITTING_CHAIR_SITDOWN_02("sitting_chair_sitdown_02","posazení se 2 ","sitting down 2 ",4367),
EXT_SITTING_CHAIR_STANDUPLEFT_01("sitting_chair_standupleft_01","vstávání ze sedu doleva ","rising up to left side ",3200),
EXT_SITTING_CHAIR_STANDUPRIGHT_01("sitting_chair_standupright_01","vstávání ze sedu doprava ","rising up to right side ",3200),
EXT_SITTING_CHAIR_STANDUP_01("sitting_chair_standup_01","vstávání ze sedu ","rising up ",2533),
EXT_SITTING_CHAIR_THOUGHTFUL_01("sitting_chair_thoughtful_01","sezení - zamyšlené ","sitting - thoughtful ",16367),
EXT_SITTING_CHAIR_TOUCHFACE_01("sitting_chair_touchface_01","sezení - dotyk obličeje ","sitting - touching face ",7233),
EXT_SITTING_CHAIR_TOUCHHAIR_01("sitting_chair_touchhair_01","sezení - dotyk vlasů ","sitting - touching hair ",7367),
EXT_SITTING_CHAIR_WAITING_01("sitting_chair_waiting_01","sezení - čekání 1","sitting - waiting 1 ",51067),
EXT_SITTING_CHAIR_WAITING_02("sitting_chair_waiting_02","sezení - čekání 2 ","sitting - waiting 2 ",48267),
EXT_SITTING_CHAIR_YAWN_01("sitting_chair_yawn_01","sezení - zívnutí ","sitting - yawning ",7700),
EXT_SITTING_TABLE_BREATHE_01("sitting_table_breathe_01","sezení u stolu - nádech ","sitting at table - breathing ",12733),
EXT_SITTING_TABLE_COUGH_01("sitting_table_cough_01","sezení u stolu - zakašlání ","sitting at table - coughing ",4067),
EXT_SITTING_TABLE_DUST_01("sitting_table_dust_01","sezení u stolu - oprášení se ","sitting at table - dusting ",9400),
EXT_SITTING_TABLE_LOOKAROUND_01("sitting_table_lookaround_01","sezení u stolu - rozhlížení ","sitting at table - looking around ",8700),
EXT_SITTING_TABLE_NERVOUS_01("sitting_table_nervous_01","sezení u stolu - nervózní ","sitting at table - nervous ",34000),
EXT_SITTING_TABLE_NEUTRAL_01("sitting_table_neutral_01","sezení u stolu - neutrální 1 ","sitting at table - neutral 1 ",45733),
EXT_SITTING_TABLE_NEUTRAL_02("sitting_table_neutral_02","sezení u stolu - neutrální 2  ","sitting at table - neutral 2 ",45733),
EXT_SITTING_TABLE_RELAXED_01("sitting_table_relaxed_01","sezení u stolu - v pohodě ","sitting at table - relaxed ",44367),
EXT_SITTING_TABLE_ROLLHEAD_01("sitting_table_rollhead_01","sezení u stolu - kroužení hlavou ","sitting at table - rolling head ",8233),
EXT_SITTING_TABLE_SCRATCHHEAD_01("sitting_table_scratchhead_01","sezení u stolu - podrbání se na hlavě ","sitting at table - scratching head ",9500),
EXT_SITTING_TABLE_SHRUG_01("sitting_table_shrug_01","sezení u stolu - protažení se 1 ","sitting at table - shrugging 1 ",3533),
EXT_SITTING_TABLE_SHRUG_02("sitting_table_shrug_02","sezení u stolu - protažení se 2 ","sitting at table - shrugging 2 ",4000),
EXT_SITTING_TABLE_SITDOWNLEFT_01("sitting_table_sitdownleft_01","posazení se ke stolu zleva ","sitting at table from left side ",4233),
EXT_SITTING_TABLE_SITDOWNRIGHT_01("sitting_table_sitdownright_01","posazení se ke stolu zprava ","sitting at table from right side ",3533),
EXT_SITTING_TABLE_STANDUPLEFT_01("sitting_table_standupleft_01","vstávání od stolu doleva ","rising up from table to left side",3433),
EXT_SITTING_TABLE_STANDUPRIGHT_01("sitting_table_standupright_01","vstávání od stolu doprava ","rising up from table to right side ",3200),
EXT_SITTING_TABLE_STRETCHARMS_01("sitting_table_stretcharms_01","sezení u stolu - protažení rukou","sitting at table - stretching arms",7767),
EXT_SITTING_TABLE_THOUGHTFUL_01("sitting_table_thoughtful_01","sezení u stolu - zamyšlené ","sitting at table - thoughtful 1 ",16700),
EXT_SITTING_TABLE_TOUCHFACE_01("sitting_table_touchface_01","sezení u stolu - dotyk obličeje ","sitting at table - touching face ",7533),
EXT_SITTING_TABLE_TOUCHHAIR_01("sitting_table_touchhair_01","sezení u stolu - dotyk vlasů ","sitting at table - touching hair ",8433),
EXT_SITTING_TABLE_WAITING_01("sitting_table_waiting_01","sezení u stolu - čekání ","sitting at table - waiting ",32633),
EXT_SITTING_TABLE_YAWN_01("sitting_table_yawn_01","sezení u stolu - zívnutí ","sitting at table - yawning ",6433),
EXT_SPECIALSTANDING_CHEER_01("specialstanding_cheer_01","stání - jásání 1 ","standing - cheering 1",15333),
EXT_SPECIALSTANDING_CHEER_02("specialstanding_cheer_02","stání - jásání 2 ","standing - cheering 2",18400),
EXT_SPECIALSTANDING_CHEER_03("specialstanding_cheer_03","stání - jásání 3 ","standing - cheering 3",3200),
EXT_SPECIALSTANDING_CHEER_04("specialstanding_cheer_04","stání - jásání 4 ","standing - cheering 4 ",6700),
EXT_SPECIALSTANDING_CHEER_05("specialstanding_cheer_05","stání - jásání 5 ","standing - cheering 5",6700),
EXT_SPECIALSTANDING_CLAPHANDS_01("specialstanding_claphands_01","stání - tleskání 1","standing - clapping 1 ",15967),
EXT_SPECIALSTANDING_CLAPHANDS_02("specialstanding_claphands_02","stání - tleskání 2 ","standing - clapping 2 ",20400),
EXT_SPECIALSTANDING_CROUCH_GESTIC_01("specialstanding_crouch_gestic_01","přikleknutí - gestické ","crouching - gestic ",23600),
EXT_SPECIALSTANDING_CROUCH_IDLE_01("specialstanding_crouch_idle_01","přikleknutí ","crouching ",9667),
EXT_SPECIALSTANDING_CROUCH_IN_01("specialstanding_crouch_in_01","přikleknutí ze stoje ","crouching down ",2533),
EXT_SPECIALSTANDING_CROUCH_OUT_01("specialstanding_crouch_out_01","postavení se z příkleku ","standing up from crouching ",2700),
EXT_SPECIALSTANDING_DANCING_AGGRESSIVE_01("specialstanding_dancing_aggressive_01","tanec - agresivní ","dancing - aggressive ",24367),
EXT_SPECIALSTANDING_DANCING_COOL_01("specialstanding_dancing_cool_01","tanec - frajerský ","dancing - cool ",23600),
EXT_SPECIALSTANDING_DANCING_NEUTRAL_01("specialstanding_dancing_neutral_01","tanec - neutrální ","dancing - neutral ",25000),
EXT_SPECIALSTANDING_DANCING_SEXY_01("specialstanding_dancing_sexy_01","tanec - sexy ","dancing - sexy ",30933),
EXT_SPECIALSTANDING_DANCING_SILLY_01("specialstanding_dancing_silly_01","tanec - přihlouplý ","dancing - silly ",34800),
EXT_SPECIALSTANDING_DOCUMENTS_CHECK_01("specialstanding_documents_check_01","stání - kontrola dokumentů ","standing - checking documents ",12167),
EXT_SPECIALSTANDING_DOCUMENTS_IN_01("specialstanding_documents_in_01","stání - sklonění se ke stolu ","standing - bending over table ",3367),
EXT_SPECIALSTANDING_DOCUMENTS_NOTE_01("specialstanding_documents_note_01","stání - psaní si poznámek ","standing - taking notes ",8700),
EXT_SPECIALSTANDING_DOCUMENTS_OUT_01("specialstanding_documents_out_01","stání - zvednutí se od stolu ","standing - rising up from table ",3367),
EXT_SPECIALSTANDING_DOCUMENTS_TAKE_01("specialstanding_documents_take_01","stání - sebrání dokumentů ","standing - taking documents ",7667),
EXT_SPECIALSTANDING_DOOR_KNOCK_01("specialstanding_door_knock_01","zabouchání na dveře ","knocking on door ",3200),
EXT_SPECIALSTANDING_DOOR_LISTEN_01("specialstanding_door_listen_01","naslouchání u dveří ","listening at door ",7367),
EXT_SPECIALSTANDING_DOOR_TRYINWARDS_01("specialstanding_door_tryinwards_01","zatlačení na zamčené dveře ","pushing locked door ",9033),
EXT_SPECIALSTANDING_DOOR_TRYOUTWARDS_01("specialstanding_door_tryoutwards_01","zatahání za zamčené dveře ","pulling locked door ",7567),
EXT_SPECIALSTANDING_IDLE_CIGARETTE_01("specialstanding_idle_cigarette_01","stání - potažení z cigarety ","standing - smoking cigarette ",33733),
EXT_SPECIALSTANDING_INVITE_SIT_01("specialstanding_invite_sit_01","stání - pozvání k sednutí ","standing - sit invitation ",4200),
EXT_SPECIALSTANDING_LAUGH_EXTREME_01("specialstanding_laugh_extreme_01","stání - extrémní smích ","standing - extreme laughter ",21533),
EXT_SPECIALSTANDING_LAUGH_LOUD_01("specialstanding_laugh_loud_01","stání - hlasitý smích ","standing - loud laughter ",10367),
EXT_SPECIALSTANDING_LAUGH_LOW_01("specialstanding_laugh_low_01","stání - decentní smích ","standing - low laugh ",12033),
EXT_SPECIALSTANDING_PRESENTATION_LEFT_01("specialstanding_presentation_left_01","stání - prezentace vlevo 1 ","standing - presentation left 1 ",16033),
EXT_SPECIALSTANDING_PRESENTATION_LEFT_02("specialstanding_presentation_left_02","stání - prezentace vlevo 2 ","standing - presentation left 2 ",36900),
EXT_SPECIALSTANDING_PRESENTATION_RIGHT_01("specialstanding_presentation_right_01","stání - prezentace vpravo 1 ","standing - presentation right 1 ",14200),
EXT_SPECIALSTANDING_PRESENTATION_RIGHT_02("specialstanding_presentation_right_02","stání - prezentace vpravo 2 ","standing - presentation right 2 ",27867),
EXT_SPECIALSTANDING_TURN_LEFT120_01("specialstanding_turn_left120_01","otočka vlevo, 120° ","left turn, 120° ",1700),
EXT_SPECIALSTANDING_TURN_LEFT180_01("specialstanding_turn_left180_01","otočka vlevo, 180° ","left turn, 180° ",1900),
EXT_SPECIALSTANDING_TURN_LEFT60_01("specialstanding_turn_left60_01","otočka vlevo, 60° ","left turn, 60° ",1167),
EXT_SPECIALSTANDING_TURN_LEFT90_01("specialstanding_turn_left90_01","otočka vlevo, 90° ","left turn, 90° ",2367),
EXT_SPECIALSTANDING_TURN_RIGHT120_01("specialstanding_turn_right120_01","otočka vpravo, 120° ","right turn, 120° ",1567),
EXT_SPECIALSTANDING_TURN_RIGHT180_01("specialstanding_turn_right180_01","otočka vpravo, 180° ","right turn, 180° ",1767),
EXT_SPECIALSTANDING_TURN_RIGHT60_01("specialstanding_turn_right60_01","otočka vpravo, 60° ","right turn, 60° ",1367),
EXT_SPECIALSTANDING_WALL_LEANONGESTIC_01("specialstanding_wall_leanongestic_01","opírání se - gestické","leaning - gestic",31467),
EXT_SPECIALSTANDING_WALL_LEANONIDLE_01("specialstanding_wall_leanonidle_01","opírání se","leaning",25500),
EXT_SPECIALSTANDING_WALL_LEANONIN_01("specialstanding_wall_leanonin_01","opření se","leaning back",4167),
EXT_SPECIALSTANDING_WALL_LEANONLISTEN_01("specialstanding_wall_leanonlisten_01","opírání se - poslouchání","leaning - listening",24633),
EXT_SPECIALSTANDING_WALL_LEANONOUT_01("specialstanding_wall_leanonout_01","zvednutí se z opření","standing from leaning",3467),
EXT_SPECIALSTANDING_WAVE_01("specialstanding_wave_01","stání - zamávání 1 ","standing - waving 1 ",5567),
EXT_SPECIALSTANDING_WAVE_02("specialstanding_wave_02","stání - zamávání 2 ","standing - waving 2 ",8433),
EXT_SPECIALSTANDING_WORK_MID_01("specialstanding_work_mid_01","stání - práce před obličejem ","standing - working in front of face ",22567),
EXT_SPECIALSTANDING_WORK_TABLE_01("specialstanding_work_table_01","stání - práce u stolu ","standing - working at table ",28333),
EXT_STANDINGSPECIAL_CHEER_01("standingspecial_cheer_01","stání - jásání 1 "," standing - cheering 1",24667),
EXT_STANDINGSPECIAL_CHEER_02("standingspecial_cheer_02","stání - jásání 2 "," standing - cheering 2",22867),
EXT_STANDINGSPECIAL_CHEER_03("standingspecial_cheer_03","stání - jásání 3 "," standing - cheering 3",4233),
EXT_STANDINGSPECIAL_CHEER_04("standingspecial_cheer_04","stání - jásání 4 "," standing - cheering 4 ",6767),
EXT_STANDINGSPECIAL_CHEER_05("standingspecial_cheer_05","stání - jásání 5 "," standing - cheering 5",6367),
EXT_STANDINGSPECIAL_CLAPHANDS_01("standingspecial_claphands_01","stání - tleskání 1","standing - clapping 1 ",7033),
EXT_STANDINGSPECIAL_CLAPHANDS_02("standingspecial_claphands_02","stání - tleskání 2 ","standing - clapping 2 ",14033),
EXT_STANDINGSPECIAL_CROUCH_GESTIC_01("standingspecial_crouch_gestic_01","přikleknutí - gestické ","crouching - gestic ",10900),
EXT_STANDINGSPECIAL_CROUCH_IDLE_01("standingspecial_crouch_idle_01","přikleknutí ","crouching ",6900),
EXT_STANDINGSPECIAL_CROUCH_IN_01("standingspecial_crouch_in_01","přikleknutí ze stoje ","crouching down ",4533),
EXT_STANDINGSPECIAL_CROUCH_OUT_01("standingspecial_crouch_out_01","postavení se z příkleku ","standing up from crouching ",4533),
EXT_STANDINGSPECIAL_DANCING_AGRESSIVE_01("standingspecial_dancing_agressive_01","tanec - agresivní ","dancing - aggressive ",25867),
EXT_STANDINGSPECIAL_DANCING_COOL_01("standingspecial_dancing_cool_01","tanec - frajerský ","dancing - cool ",29500),
EXT_STANDINGSPECIAL_DANCING_NEUTRAL_01("standingspecial_dancing_neutral_01","tanec - neutrální ","dancing - neutral ",21533),
EXT_STANDINGSPECIAL_DANCING_SEXY_01("standingspecial_dancing_sexy_01","tanec - sexy ","dancing - sexy ",27200),
EXT_STANDINGSPECIAL_DANCING_SILLY_01("standingspecial_dancing_silly_01","tanec - přihlouplý ","dancing - silly ",25967),
EXT_STANDINGSPECIAL_DOCUMENTS_CHECK_01("standingspecial_documents_check_01","stání - kontrola dokumentů ","standing - checking documents ",16133),
EXT_STANDINGSPECIAL_DOCUMENTS_IDLE_01("standingspecial_documents_idle_01","stání - zkoumání dokumentů na stole ","standing - checking documents on table ",26900),
EXT_STANDINGSPECIAL_DOCUMENTS_IN_01("standingspecial_documents_in_01","stání - sklonění se ke stolu ","standing - bending over table ",3667),
EXT_STANDINGSPECIAL_DOCUMENTS_NOTE_01("standingspecial_documents_note_01","stání - psaní si poznámek ","standing - taking notes ",10067),
EXT_STANDINGSPECIAL_DOCUMENTS_OUT_01("standingspecial_documents_out_01","stání - zvednutí se od stolu ","standing - rising up from table ",4033),
EXT_STANDINGSPECIAL_DOCUMENTS_TAKE_01("standingspecial_documents_take_01","stání - sebrání dokumentů ","standing - taking documents ",5033),
EXT_STANDINGSPECIAL_DOOR_KNOCK_01("standingspecial_door_knock_01","zabouchání na dveře ","knocking on door ",8033),
EXT_STANDINGSPECIAL_DOOR_LISTEN_01("standingspecial_door_listen_01","naslouchání u dveří ","listening at door ",8367),
EXT_STANDINGSPECIAL_DOOR_TRYINWARDS_01("standingspecial_door_tryinwards_01","zatlačení na zamčené dveře ","pushing locked door ",6233),
EXT_STANDINGSPECIAL_DOOR_TRYOUTWARDS_01("standingspecial_door_tryoutwards_01","zatahání za zamčené dveře ","pulling locked door ",6233),
EXT_STANDINGSPECIAL_IDLE_CIGARETTE_01("standingspecial_idle_cigarette_01","stání - potažení z cigarety ","standing - smoking cigarette ",32833),
EXT_STANDINGSPECIAL_INVITE_SIT_01("standingspecial_invite_sit_01","stání - pozvání k sednutí ","standing - sit invitation ",4367),
EXT_STANDINGSPECIAL_LAUGH_EXTREME_01("standingspecial_laugh_extreme_01","stání - extrémní smích ","standing - extreme laughter ",19367),
EXT_STANDINGSPECIAL_LAUGH_LOUD_01("standingspecial_laugh_loud_01","stání - hlasitý smích ","standing - loud laughter ",16600),
EXT_STANDINGSPECIAL_LAUGH_LOW_01("standingspecial_laugh_low_01","stání - decentní smích ","standing - low laugh ",11267),
EXT_STANDINGSPECIAL_PRESENTATION_LEFT_01("standingspecial_presentation_left_01","stání - prezentace vlevo 1 ","standing - presentation left 1 ",22400),
EXT_STANDINGSPECIAL_PRESENTATION_LEFT_02("standingspecial_presentation_left_02","stání - prezentace vlevo 2 ","standing - presentation left 2 ",27033),
EXT_STANDINGSPECIAL_PRESENTATION_RIGHT_01("standingspecial_presentation_right_01","stání - prezentace vpravo 1 ","standing - presentation right 1 ",25133),
EXT_STANDINGSPECIAL_PRESENTATION_RIGHT_02("standingspecial_presentation_right_02","stání - prezentace vpravo 2 ","standing - presentation right 2 ",33600),
EXT_STANDINGSPECIAL_TURN_LEFT120_01("standingspecial_turn_left120_01","otočka vlevo, 120° ","left turn, 120° ",2367),
EXT_STANDINGSPECIAL_TURN_LEFT180_01("standingspecial_turn_left180_01","otočka vlevo, 180° ","left turn, 180° ",2467),
EXT_STANDINGSPECIAL_TURN_LEFT60_01("standingspecial_turn_left60_01","otočka vlevo, 60° ","left turn, 60° ",1700),
EXT_STANDINGSPECIAL_TURN_LEFT90_01("standingspecial_turn_left90_01","otočka vlevo, 90° ","left turn, 90° ",2367),
EXT_STANDINGSPECIAL_TURN_RIGHT120_01("standingspecial_turn_right120_01","otočka vpravo, 120° ","right turn, 120° ",2200),
EXT_STANDINGSPECIAL_TURN_RIGHT180_01("standingspecial_turn_right180_01","otočka vpravo, 180° ","right turn, 180° ",2400),
EXT_STANDINGSPECIAL_TURN_RIGHT60_01("standingspecial_turn_right60_01","otočka vpravo, 60° ","right turn, 60° ",1367),
EXT_STANDINGSPECIAL_TURN_RIGHT90_01("standingspecial_turn_right90_01","otočka vpravo, 90° ","right turn, 90° ",2200),
EXT_STANDINGSPECIAL_WAVE_01("standingspecial_wave_01","stání - zamávání 1 ","standing - waving 1 ",2867),
EXT_STANDINGSPECIAL_WAVE_02("standingspecial_wave_02","stání - zamávání 2 ","standing - waving 2 ",6233),
EXT_STANDINGSPECIAL_WORK_MID("standingspecial_work_mid","stání - práce před obličejem ","standing - working in front of face ",11667),
EXT_STANDINGSPECIAL_WORK_TABLE("standingspecial_work_table","stání - práce u stolu ","standing - working at table ",11333),
EXT_STANDING_DRUNK_01("standing_drunk_01","stání - opilé 1","standing - drunk 1 ",72033),
EXT_STANDING_DRUNK_02("standing_drunk_02","stání - opilé 2 ","standing - drunk 2 ",31700),
EXT_STANDING_IDLE_ANGRY_01("standing_idle_angry_01","stání - naštvané 1","standing - angry 1 ",28367),
EXT_STANDING_IDLE_ANGRY_02("standing_idle_angry_02","stání - naštvané 2 ","standing - angry 2 ",16867),
EXT_STANDING_IDLE_BREATHE_01("standing_idle_breathe_01","stání - dýchání 1 ","standing - breathing 1 ",2767),
EXT_STANDING_IDLE_BREATHE_02("standing_idle_breathe_02","stání - dýchání 2 ","standing - breathing 2 ",10033),
EXT_STANDING_IDLE_BREATHE_03("standing_idle_breathe_03","stání - dýchání 3 ","standing - breathing 3 ",16733),
EXT_STANDING_IDLE_COUGH_01("standing_idle_cough_01","stání - zakašlání 1 ","standing - coughing 1 ",3700),
EXT_STANDING_IDLE_COUGH_02("standing_idle_cough_02","stání - zakašlání 2 ","standing - coughing 2 ",4667),
EXT_STANDING_IDLE_DRUNK_01("standing_idle_drunk_01","stání - opilé 3 ","standing - drunk 3 ",43667),
EXT_STANDING_IDLE_DRUNK_02("standing_idle_drunk_02","stání - opilé 4 ","standing - drunk 4 ",47800),
EXT_STANDING_IDLE_DUST_01("standing_idle_dust_01","stání - oprášení se 1","standing - dusting 1 ",5533),
EXT_STANDING_IDLE_DUST_02("standing_idle_dust_02","stání - oprášení se 2 ","standing - dusting 2 ",5200),
EXT_STANDING_IDLE_FINGERNAIL_01("standing_idle_fingernail_01","stání - zkoumání nehtů","standing - checking fingernails",5467),
EXT_STANDING_IDLE_LOOKAROUND_01("standing_idle_lookaround_01","stání - rozhlédnutí se 1 ","standing - looking around 1",4667),
EXT_STANDING_IDLE_LOOKAROUND_02("standing_idle_lookaround_02","stání - rozhlédnutí se 2 ","standing - looking around 2 ",4533),
EXT_STANDING_IDLE_LOOKAROUND_03("standing_idle_lookaround_03","stání - rozhlédnutí se 3 ","standing - looking around 3 ",11900),
EXT_STANDING_IDLE_MOVELEG_01("standing_idle_moveleg_01","stání - hýbání nohou","standing - moving leg",10767),
EXT_STANDING_IDLE_MOVE_01("standing_idle_move_01","stání - pohyb na místě","standing - moving in place",6700),
EXT_STANDING_IDLE_NERVOUS_01("standing_idle_nervous_01","stání - nervózní 1 ","standing - nervous 1 ",30933),
EXT_STANDING_IDLE_NERVOUS_02("standing_idle_nervous_02","stání - nervózní 2 ","standing - nervous 2 ",51100),
EXT_STANDING_IDLE_NERVOUS_03("standing_idle_nervous_03","stání - nervózní 3 ","standing - nervous 3 ",14300),
EXT_STANDING_IDLE_NEUTRAL_01("standing_idle_neutral_01","stání - neutrální 1 ","standing - neutral 1 ",11700),
EXT_STANDING_IDLE_NEUTRAL_02("standing_idle_neutral_02","stání - neutrální 2 ","standing - neutral 2 ",15533),
EXT_STANDING_IDLE_NEUTRAL_03("standing_idle_neutral_03","stání - neutrální 3 ","standing - neutral 3 ",33367),
EXT_STANDING_IDLE_NEUTRAL_04("standing_idle_neutral_04","stání - neutrální 4 ","standing - neutral 4 ",42167),
EXT_STANDING_IDLE_NEUTRAL_05("standing_idle_neutral_05","stání - neutrální 5 ","standing - neutral 5 ",34567),
EXT_STANDING_IDLE_NEUTRAL_06("standing_idle_neutral_06","stání - neutrální 6 ","standing - neutral 6 ",32267),
EXT_STANDING_IDLE_NEUTRAL_07("standing_idle_neutral_07","stání - neutrální 7 ","standing - neutral 7 ",30367),
EXT_STANDING_IDLE_NEUTRAL_08("standing_idle_neutral_08","stání - neutrální 8 ","standing - neutral 8 ",51233),
EXT_STANDING_IDLE_NEUTRAL_09("standing_idle_neutral_09","stání - neutrální 9 ","standing - neutral 9 ",21700),
EXT_STANDING_IDLE_ROLLHEAD_01("standing_idle_rollhead_01","stání - kroužení hlavou 1","standing - rolling head 1 ",7700),
EXT_STANDING_IDLE_ROLLHEAD_02("standing_idle_rollhead_02","stání - kroužení hlavou 2","standing - rolling head 2",4633),
EXT_STANDING_IDLE_SCRATCHHEAD_01("standing_idle_scratchhead_01","stání - podrbání se na hlavě 1","standing - scratching head 1 ",5000),
EXT_STANDING_IDLE_SCRATCHHEAD_02("standing_idle_scratchhead_02","stání - podrbání se na hlavě 2 ","standing - scratching head 2 ",4333),
EXT_STANDING_IDLE_SHAKEARMS_01("standing_idle_shakearms_01","stání - protřepání rukou ","standing - shaking arms ",3700),
EXT_STANDING_IDLE_SHAKELEG_01("standing_idle_shakeleg_01","stání - protřepání nohou ","standing - shaking legs ",4500),
EXT_STANDING_IDLE_STRETCHARMS_01("standing_idle_stretcharms_01","stání - protažení rukou ","standing - stretching arms ",6667),
EXT_STANDING_IDLE_TOUCHFACE_01("standing_idle_touchface_01","stání - dotyk obličeje 1 ","standing - touching face 1",6000),
EXT_STANDING_IDLE_TOUCHFACE_02("standing_idle_touchface_02","stání - dotyk obličeje 2 ","standing - touching face 2 ",9667),
EXT_STANDING_IDLE_TOUCHHAIR_01("standing_idle_touchhair_01","stání - dotyk vlasů ","standing - touching hair ",5033),
EXT_STANDING_IDLE_WAITING_01("standing_idle_waiting_01","stání - čekání 1 ","standing - waiting 1 ",47033),
EXT_STANDING_IDLE_WAITING_02("standing_idle_waiting_02","stání - čekání 2 ","standing - waiting 2 ",34167),
EXT_STANDING_IDLE_YAWN_01("standing_idle_yawn_01","stání - zívnutí ","standing - yawning ",9267),
EXT_STANDING_LISTEN_ACCEPT_01("standing_listen_accept_01","stání - souhlas 1 ","standing - agreeing 1 ",3700),
EXT_STANDING_LISTEN_ACCEPT_02("standing_listen_accept_02","stání - souhlas 2 ","standing - agreeing 2 ",2367),
EXT_STANDING_LISTEN_ACCEPT_03("standing_listen_accept_03","stání - souhlas 3 ","standing - agreeing 3 ",3300),
EXT_STANDING_LISTEN_ACCEPT_04("standing_listen_accept_04","stání - souhlas 4 ","standing - agreeing 4 ",3900),
EXT_STANDING_LISTEN_ACCEPT_05("standing_listen_accept_05","stání - souhlas 5 ","standing - agreeing 5 ",9700),
EXT_STANDING_LISTEN_ANGRY_01("standing_listen_angry_01","stání - naštvané naslouchání ","standing - angry listening ",30700),
EXT_STANDING_LISTEN_DENY_01("standing_listen_deny_01","stání - nesouhlas 1 ","standing - declining 1",3033),
EXT_STANDING_LISTEN_DENY_02("standing_listen_deny_02","stání - nesouhlas 2 ","standing - declining 2 ",3367),
EXT_STANDING_LISTEN_DENY_03("standing_listen_deny_03","stání - nesouhlas 3 ","standing - declining 3 ",4200),
EXT_STANDING_LISTEN_DENY_04("standing_listen_deny_04","stání - nesouhlas 4 ","standing - declining 4 ",2400),
EXT_STANDING_LISTEN_DENY_05("standing_listen_deny_05","stání - nesouhlas 5 ","standing - declining 5 ",3367),
EXT_STANDING_LISTEN_DENY_06("standing_listen_deny_06","stání - nesouhlas 6 ","standing - declining 6 ",14800),
EXT_STANDING_LISTEN_EXCITED_01("standing_listen_excited_01","stání - vzrušené poslouchání ","standing - excited listening ",27700),
EXT_STANDING_LISTEN_LEFT_01("standing_listen_left_01","stání - poslouchání zleva ","standing - listening left ",25033),
EXT_STANDING_LISTEN_NERVOUS_01("standing_listen_nervous_01","stání - nervózní poslouchání ","standing - nervous listening ",31667),
EXT_STANDING_LISTEN_NEUTRAL_01("standing_listen_neutral_01","stání - neutrální poslouchání 1","standing - neutral listening 1 ",32567),
EXT_STANDING_LISTEN_NEUTRAL_02("standing_listen_neutral_02","stání - neutrální poslouchání 2 ","standing - neutral listening 2 ",24567),
EXT_STANDING_LISTEN_NEUTRAL_03("standing_listen_neutral_03","stání - neutrální poslouchání 3 ","standing - neutral listening 3 ",30567),
EXT_STANDING_LISTEN_RELAXED_01("standing_listen_relaxed_01","stání - klidné poslouchání ","standing - relaxed listening ",35867),
EXT_STANDING_LISTEN_RIGHT_01("standing_listen_right_01","stání - poslouchání zprava ","standing - listening right ",31167),
EXT_STANDING_LISTEN_SAD_01("standing_listen_sad_01","stání - smutné poslouchání ","standing - sad listening ",35567),
EXT_STANDING_LISTEN_SELFASSURED_01("standing_listen_selfassured_01","stání - sebejisté poslouchání","standing - self-assured listening",27667),
EXT_STANDING_SHRUG_01("standing_shrug_01","stání - protažení se 1 ","standing - shrugging 1 ",1867),
EXT_STANDING_SHRUG_02("standing_shrug_02","stání - protažení se 2 ","standing - shrugging 2 ",3467),
EXT_STANDING_TALK_ANGRY_01("standing_talk_angry_01","stání - naštvané mluvení 1 ","standing - angry talking 1 ",39300),
EXT_STANDING_TALK_ANGRY_02("standing_talk_angry_02","stání - naštvané mluvení 2 ","standing - angry talking 2 ",33233),
EXT_STANDING_TALK_COOL_01("standing_talk_cool_01","stání - frajerské mluvení ","standing - cool talking ",45700),
EXT_STANDING_TALK_EXCITED_01("standing_talk_excited_01","stání - vzrušené mluvení 1","standing - excited talking 1",26567),
EXT_STANDING_TALK_EXCITED_02("standing_talk_excited_02","stání - vzrušené mluvení 2 ","standing - excited talking 2 ",46233),
EXT_STANDING_TALK_FEMALESTRESSED_01("standing_talk_femalestressed_01","stání - žensky vystresované mluvení","standing - female-stressed talking",42233),
EXT_STANDING_TALK_LEFT_01("standing_talk_left_01","stání - mluvení vlevo ","standing - talking left ",29700),
EXT_STANDING_TALK_NERVOUS_01("standing_talk_nervous_01","stání - nervózní mluvení 1 ","standing - nervous talking 1",25933),
EXT_STANDING_TALK_NERVOUS_02("standing_talk_nervous_02","stání - nervózní mluvení 2 ","standing - nervous talking 2",25500),
EXT_STANDING_TALK_NEUTRAL_01("standing_talk_neutral_01","stání - neutrální mluvení 1 ","standing - neutral talking 1 ",35600),
EXT_STANDING_TALK_NEUTRAL_02("standing_talk_neutral_02","stání - neutrální mluvení 2 ","standing - neutral talking 2 ",46100),
EXT_STANDING_TALK_NEUTRAL_03("standing_talk_neutral_03","stání - neutrální mluvení 3 ","standing - neutral talking 3 ",64800),
EXT_STANDING_TALK_NEUTRAL_04("standing_talk_neutral_04","stání - neutrální mluvení 4 ","standing - neutral talking 4 ",52467),
EXT_STANDING_TALK_NEUTRAL_05("standing_talk_neutral_05","stání - neutrální mluvení 5 ","standing - neutral talking 5 ",33900),
EXT_STANDING_TALK_RELAXED_01("standing_talk_relaxed_01","stání - klidné mluvení 1 ","standing - relaxed talking 1",32367),
EXT_STANDING_TALK_RELAXED_02("standing_talk_relaxed_02","stání - klidné mluvení 2 ","standing - relaxed talking 2 ",27433),
EXT_STANDING_TALK_RIGHT_01("standing_talk_right_01","stání - mluvení vpravo ","standing - talking right ",29167),
EXT_STANDING_TALK_SAD_01("standing_talk_sad_01","stání - smutné mluvení ","standing - sad talking ",32367),
EXT_STANDING_TALK_SELFASSURED_01("standing_talk_selfassured_01","stání - sebejisté mluvení 1","standing - self-assured talking 1",57533),
EXT_STANDING_TALK_SELFASSURED_02("standing_talk_selfassured_02","stání - sebejisté mluvení 2 ","standing - self-assured talking 2 ",45867),
EXT_STANDING_THOUGHTFUL_01("standing_thoughtful_01","stání - zamyšlené ","standing - thoughtful ",13533),
EXT_WALKING_RUN_EXTREMEFEMALE_01("walking_run_extremefemale_01","běh - ženský styl","running - female style",767),
EXT_WALKING_RUN_FAST_01("walking_run_fast_01","běh - rychlý 1 ","running - fast 1 ",633),
EXT_WALKING_RUN_FAST_02("walking_run_fast_02","běh - rychlý 2 ","running - fast 2 ",567),
EXT_WALKING_RUN_INJURED_01("walking_run_injured_01","běh - zraněný ","running - wounded ",700),
EXT_WALKING_RUN_NEUTRAL_01("walking_run_neutral_01","běh - neutrální 1 ","running - neutral 1 ",767),
EXT_WALKING_RUN_NEUTRAL_02("walking_run_neutral_02","běh - neutrální 2 ","running - neutral 2 ",800),
EXT_WALKING_RUN_OBESE_01("walking_run_obese_01","běh - obézní 1 ","running - obese 1 ",733),
EXT_WALKING_RUN_OBESE_02("walking_run_obese_02","běh - obézní 2 ","running - obese 2 ",733),
EXT_WALKING_RUN_SLOW_01("walking_run_slow_01","běh - pomalý 1 ","running - slow 1",800),
EXT_WALKING_RUN_SLOW_02("walking_run_slow_02","běh - pomalý 2 ","running - slow 2 ",833),
EXT_WALKING_WALK_BRUISED_01("walking_walk_bruised_01","chůze - odřená ","walking - bruised ",2567),
EXT_WALKING_WALK_COOL_01("walking_walk_cool_01","chůze - frajerská 1 ","walking - cool 1 ",1300),
EXT_WALKING_WALK_COOL_02("walking_walk_cool_02","chůze - frajerská 2 ","walking - cool 2 ",1167),
EXT_WALKING_WALK_DRUNK_01("walking_walk_drunk_01","chůze - opilá ","walking - drunk ",2533),
EXT_WALKING_WALK_EXTREMEFEMALE_01("walking_walk_extremefemale_01","chůze - ženský styl","walking - female style",1033),
EXT_WALKING_WALK_FAST_01("walking_walk_fast_01","chůze - rychlá 1 ","walking - fast 1 ",1100),
EXT_WALKING_WALK_FAST_02("walking_walk_fast_02","chůze - rychlá 2 ","walking - fast 2 ",933),
EXT_WALKING_WALK_FAST_03("walking_walk_fast_03","chůze - rychlá 3","walking - fast 3",1100),
EXT_WALKING_WALK_NEUTRAL_01("walking_walk_neutral_01","chůze - neutrální 1 ","walking - neutral 1 ",1233),
EXT_WALKING_WALK_NEUTRAL_02("walking_walk_neutral_02","chůze - neutrální 2 ","walking - neutral 2 ",1100),
EXT_WALKING_WALK_NEUTRAL_03("walking_walk_neutral_03","chůze - neutrální 3 ","walking - neutral 3 ",1100),
EXT_WALKING_WALK_OBESE_01("walking_walk_obese_01","chůze - obézní 1 ","walking - obese 1 ",1367),
EXT_WALKING_WALK_OBESE_02("walking_walk_obese_02","chůze - obézní 2 ","walking - obese 2 ",1067),
EXT_WALKING_WALK_SELFASSURED_01("walking_walk_selfassured_01","chůze - sebejistá","walking - self-assured",1233),
EXT_WALKING_WALK_SLOW_01("walking_walk_slow_01","chůze - pomalá 1 ","walking - slow 1 ",1500),
EXT_WALKING_WALK_SLOW_02("walking_walk_slow_02","chůze - pomalá 2 ","walking - slow 2 ",1300),
EXT_WALKING_WALK_STROLL_01("walking_walk_stroll_01","chůze - procházka 1 ","walking - strolling 1 ",1600),
EXT_WALKING_WALK_STROLL_02("walking_walk_stroll_02","chůze - procházka 2 ","walking - strolling 2 ",1867),
EXT_WALKINGRUNNINGSYSTEM_ASCEND_STAIRSSTART_01("walkingrunningsystem_ascend_stairsstart_01","poklus - start do schodů ","trot - starting ascending stairs ",1067),
EXT_WALKINGRUNNINGSYSTEM_ASCEND_STAIRS_01("walkingrunningsystem_ascend_stairs_01","poklus - do schodů ","trot - ascending stairs ",1233),
EXT_WALKINGRUNNINGSYSTEM_DESCEND_STAIRSSTART_01("walkingrunningsystem_descend_stairsstart_01","poklus - start ze schodů ","trot - starting descending stairs ",1000),
EXT_WALKINGRUNNINGSYSTEM_DESCEND_STAIRS_01("walkingrunningsystem_descend_stairs_01","poklus - ze schodů ","trot - descending stairs ",867),
EXT_WALKINGRUNNINGSYSTEM_RUN_NEUTRAL_01("walkingrunningsystem_run_neutral_01","poklus - neutrální ","trot - neutral ",800),
EXT_WALKINGRUNNINGSYSTEM_RUN_START_01("walkingrunningsystem_run_start_01","poklus - začátek ","trot - start ",667),
EXT_WALKINGRUNNINGSYSTEM_RUN_STOP_01("walkingrunningsystem_run_stop_01","poklus - konec ","trot - end ",1300),
EXT_WALKINGRUNNINGSYSTEM_RUN_TOWALK_01("walkingrunningsystem_run_towalk_01","poklus - zpomalení do chůze ","trot - slowing to walking ",833),
EXT_WALKINGRUNNINGSYSTEM_STAIRS_ASCENDSTART_01("walkingrunningsystem_stairs_ascendstart_01","poklus - start do schodů ","trot - starting ascending stairs ",1167),
EXT_WALKINGRUNNINGSYSTEM_STAIRS_ASCEND_01("walkingrunningsystem_stairs_ascend_01","poklus - do schodů ","trot - ascending stairs ",1100),
EXT_WALKINGRUNNINGSYSTEM_STAIRS_DESCENDSTART_01("walkingrunningsystem_stairs_descendstart_01","poklus - start ze schodů ","trot - starting descending stairs ",533),
EXT_WALKINGRUNNINGSYSTEM_STAIRS_DESCEND_01("walkingrunningsystem_stairs_descend_01","poklus - ze schodů ","trot - descending stairs ",1067),
EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT120TOWALK_01("walkingrunningsystem_turn_left120towalk_01","chůze - otočka o 120° vlevo ","walking - left turn, 120° ",1567),
EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT180TOWALK_01("walkingrunningsystem_turn_left180towalk_01","chůze - otočka o 180° vlevo ","walking - left turn, 180° ",1667),
EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT60TOWALK_01("walkingrunningsystem_turn_left60towalk_01","chůze - otočka o 60° vlevo ","walking - left turn, 60° ",1233),
EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT120TOWALK_01("walkingrunningsystem_turn_right120towalk_01","chůze - otočka o 120° vpravo ","walking - right turn, 120° ",1000),
EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT180TOWALK_01("walkingrunningsystem_turn_right180towalk_01","chůze - otočka o 180° vpravo ","walking - right turn, 180° ",2100),
EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT60TOWALK_01("walkingrunningsystem_turn_right60towalk_01","chůze - otočka o 60° vpravo ","walking - right turn, 60° ",1333),
EXT_WALKINGRUNNINGSYSTEM_WALK_NEUTRAL_01("walkingrunningsystem_walk_neutral_01","chůze - neutrální 4 ","walking - neutral 4 ",1100),
EXT_WALKINGRUNNINGSYSTEM_WALK_START_01("walkingrunningsystem_walk_start_01","chůze - začátek ","walking - start ",1000),
EXT_WALKINGRUNNINGSYSTEM_WALK_STOP_01("walkingrunningsystem_walk_stop_01","chůze - konec ","walking - end ",2033),
EXT_WALKINGRUNNINGSYSTEM_WALK_TORUN_01("walkingrunningsystem_walk_torun_01","chůze - zrychlení do běhu ","walking - speeding up to run ",967),
FIGHT_AIMDOWN01("fight_aimdown01","b_míření dolů 1","f_aim down 1",3333),
FIGHT_AIMDOWN02("fight_aimdown02","b_míření dolů 2","f_aim down 2",3333),
FIGHT_AIMFRONT01("fight_aimfront01","b_míření dopředu 1","f_aim front 1",3333),
FIGHT_AIMFRONT02("fight_aimfront02","b_míření dopředu 2","f_aim front 2",3333),
FIGHT_BEATING("fight_beating","b_mlácení","f_beating",1833),
FIGHT_GUNACTIONDOWN("fight_gunactiondown","b_střelba zbraní dolů","f_gun action down",10000),
FIGHT_GUNACTIONDOWNA("fight_gunactiondownA","b_střelba zbraní dolů A","f_gun action down A",2466),
FIGHT_GUNACTIONDOWNB("fight_gunactiondownB","b_střelba zbraní dolů B","f_gun action down B",3666),
FIGHT_GUNACTIONDOWNC("fight_gunactiondownC","b_střelba zbraní dolů C","f_gun action down C",3833),
FIGHT_GUNACTIONFRONT("fight_gunactionfront","b_střelba zbraní dopředu","f_gun action front",9000),
FIGHT_GUNACTIONFRONTA("fight_gunactionfrontA","b_střelba zbraní dopředu A","f_gun action front A",1666),
FIGHT_GUNACTIONFRONTB("fight_gunactionfrontB","b_střelba zbraní dopředu B","f_gun action front B",3300),
FIGHT_GUNACTIONFRONTC("fight_gunactionfrontC","b_střelba zbraní dopředu C","f_gun action front C",3966),
FIGHT_GUNREADYFRONT("fight_gunreadyfront","b_tasení zbraně dopředu","f_gun ready front",4000),
FIGHT_GUNWILDWEST01("fight_gunwildwest01","b_střelba zbraní divoký západ 1","f_gun action wild west 1",7666),
FIGHT_GUNWILDWEST02("fight_gunwildwest02","b_střelba zbraní divoký západ 2","f_gun action wild west 2",7666),
FIGHT_KICKDOWN("fight_kickdown","b_kopnutí dolů","f_kick up",1600),
FIGHT_KICKFRONT("fight_kickfront","b_kopnutí dopředu","f_kick front",1500),
FIGHT_RIFLESHOOT("fight_rifleshoot","b_střelba puškou","f_rifle shoot",1000),
FIGHT_RUNAIMDOWN01("fight_runaimdown01","b_běh míření dolů 1","f_run aim down 1",3233),
FIGHT_RUNAIMDOWN02("fight_runaimdown02","b_běh míření dolů 2","f_run aim down 2",3233),
FIGHT_RUNAIMDOWN03("fight_runaimdown03","b_běh míření dolů 3","f_run aim down 3",3233),
FIGHT_RUNAIMFRONT01("fight_runaimfront01","b_běh míření dopředu 1","f_run aim front 1",3233),
FIGHT_RUNAIMFRONT02("fight_runaimfront02","b_běh míření dopředu 2","f_run aim front 2",3233),
FIGHT_RUNAIMFRONT03("fight_runaimfront03","b_běh míření dopředu 3","f_run aim front 3",3233),
FIGHT_RUNSHOOTDOWN01("fight_runshootdown01","b_běh střelba dolů 1","f_run shoot down 1",4033),
FIGHT_RUNSHOOTDOWN02("fight_runshootdown02","b_běh střelba dolů 2","f_run shoot down 2",4033),
FIGHT_RUNSHOOTDOWN03("fight_runshootdown03","b_běh střelba dolů 3","f_run shoot down 3",4033),
FIGHT_RUNSHOOTDOWNSHORT01("fight_runshootdownshort01","b_běh střelba dolů 1 krátký","f_run shoot down 1 short",1633),
FIGHT_RUNSHOOTDOWNSHORT02("fight_runshootdownshort02","b_běh střelba dolů 2 krátký","f_run shoot down 2 short",1633),
FIGHT_RUNSHOOTDOWNSHORT03("fight_runshootdownshort03","b_běh střelba dolů 3 krátký","f_run shoot down 3 short",1633),
FIGHT_RUNSHOOTFRONT01("fight_runshootfront01","b_běh střelba dopředu 1","f_run shoot front 1",4033),
FIGHT_RUNSHOOTFRONT02("fight_runshootfront02","b_běh střelba dopředu 2","f_run shoot front 2",4033),
FIGHT_RUNSHOOTFRONT03("fight_runshootfront03","b_běh střelba dopředu 3","f_run shoot front 3",4033),
FIGHT_RUNSHOOTFRONTSHORT01("fight_runshootfrontshort01","b_běh střelba dopředu 1 krátký","f_run shoot front 1 short",1633),
FIGHT_RUNSHOOTFRONTSHORT02("fight_runshootfrontshort02","b_běh střelba dopředu 2 krátký","f_run shoot front 2 short",1633),
FIGHT_RUNSHOOTFRONTSHORT03("fight_runshootfrontshort03","b_běh střelba dopředu 3 krátký","f_run shoot front 3 short",1633),
FIGHT_SHOOTDOWN01("fight_shootdown01","b_střelba dolů 1","f_shoot down 1",1500),
FIGHT_SHOOTDOWN02("fight_shootdown02","b_střelba dolů 2","f_shoot down 2",1500),
FIGHT_SHOOTFRONT01("fight_shootfront01","b_střelba dopředu 1","f_shoot front 1",1500),
FIGHT_SHOOTFRONT02("fight_shootfront02","b_střelba dopředu 2","f_shoot front 2",1500),
FIGHT_SLAPS("fight_slaps","b_facky","f_slaps",2000),
FIGHT_WALKAIMDOWN01("fight_walkaimdown01","b_chůze míření dolů 1","f_walk aim down 1",4000),
FIGHT_WALKAIMDOWN02("fight_walkaimdown02","b_chůze míření dolů 2","f_walk aim down 2",4000),
FIGHT_WALKAIMFRONT01("fight_walkaimfront01","b_chůze míření dopředu 1","f_walk aim front 1",4000),
FIGHT_WALKAIMFRONT02("fight_walkaimfront02","b_chůze míření dopředu 2","f_walk aim front 2",4000),
FIGHT_WALKSHOOTDOWN01("fight_walkshootdown01","b_chůze střelba dolů 1","f_walk shoot down 1",4000),
FIGHT_WALKSHOOTDOWN02("fight_walkshootdown02","b_chůze střelba dolů 2","f_walk shoot down 2",4000),
FIGHT_WALKSHOOTDOWNSHORT01("fight_walkshootdownshort01","b_chůze střelba dolů 1 krátká","f_walk shoot down 1 short",1333),
FIGHT_WALKSHOOTDOWNSHORT02("fight_walkshootdownshort02","b_chůze střelba dolů 2 krátká","f_walk shoot down 2 short",1333),
FIGHT_WALKSHOOTFRONT01("fight_walkshootfront01","b_chůze střelba dopředu 1","f_walk shoot front 1",4000),
FIGHT_WALKSHOOTFRONT02("fight_walkshootfront02","b_chůze střelba dopředu 2","f_walk shoot front 2",4000),
FIGHT_WALKSHOOTFRONTSHORT01("fight_walkshootfrontshort01","b_chůze střelba dopředu 1 krátká","f_walk shoot front 1 short",1333),
FIGHT_WALKSHOOTFRONTSHORT02("fight_walkshootfrontshort02","b_chůze střelba dopředu 2 krátká","f_walk shoot front 2 short",1333),
FREEZE("freeze","_zamrzlá animace","_freeze animation",500),
IDLEANIM("idleanim","_prázdná animace","_idle animation",500),
INTERACT_AUTOMAT("interact_automat","i_automat","i_automat",7100),
INTERACT_CARESS("interact_caress","i_pohlazení","i_caress",3666),
INTERACT_CARESS_BOY("interact_caress_boy","i_pohlazení kluka po hlavě","i_caressing boy",5100),
INTERACT_CARESS_GIRL("interact_caress_girl","i_pohlazení holky po hlavě","i_caressing girl",5100),
INTERACT_FRONTHUG01("interact_fronthug01","i_obejmutí zepředu 1","i_frontal hug 1",7300),
INTERACT_FRONTHUG01_END("interact_fronthug01_end","i_obejmutí zepředu 1 - konec","i_frontal hug 1 - end",1566),
INTERACT_FRONTHUG01_LOOP("interact_fronthug01_loop","i_obejmutí zepředu 1 - smyčka","i_frontal hug 1 - loop",3333),
INTERACT_FRONTHUG01_START("interact_fronthug01_start","i_obejmutí zepředu 1 - začátek","i_frontal hug 1 - start",2333),
INTERACT_FRONTHUG02("interact_fronthug02","i_obejmutí zepředu 2","i_frontal hug 2",5666),
INTERACT_FRONTHUG02_END("interact_fronthug02_end","i_obejmutí zepředu 2 - konec ","i_frontal hug 2 - end",2266),
INTERACT_FRONTHUG02_LOOP("interact_fronthug02_loop","i_obejmutí zepředu 2 - smyčka","i_frontal hug 2 - loop",3333),
INTERACT_FRONTHUG02_START("interact_fronthug02_start","i_obejmutí zepředu 2 - začátek","i_frontal hug 2 - start",2333),
INTERACT_GOAWAY("interact_goaway","i_odchod","i_going away",2733),
INTERACT_HANDONSHOULDER("interact_handonshoulder","i_položení ruky na rameno","i_laying hand on shoulder",3333),
INTERACT_HANDOVER01("interact_handover01","i_převzetí 1","i_takeover 1",3333),
INTERACT_HANDOVER02("interact_handover02","i_převzetí 2","i_takeover 2",3833),
INTERACT_HANDOVER03("interact_handover03","i_převzetí 3","i_takeover 3",3700),
INTERACT_HANDOVER04("interact_handover04","i_převzetí 4","i_takeover 4",6000),
INTERACT_KISSWITHHANDS01_BOY("interact_kisswithhands01_boy","i_mužský polibek s obejmutím 1","i_boy kissing with hug 1",6133),
INTERACT_KISSWITHHANDS02_BOY("interact_kisswithhands02_boy","i_mužský polibek s obejmutím 2","i_boy kissing with hug 2",6800),
INTERACT_KISSWITHHANDS_GIRL("interact_kisswithhands_girl","i_ženský polibek s obejmutím","i_girl kissing with hug",6966),
INTERACT_KISS_BOY("interact_kiss_boy","i_mužský polibek","i_boy kissing",3633),
INTERACT_KISS_GIRL("interact_kiss_girl","i_ženská polibek","i_girl kissing",4466),
INTERACT_LISTENWALL("interact_listenwall","s_poslouchání za dveřmi 1","s_listen behind doors 1",11333),
INTERACT_LISTENWALLHAND01("interact_listenwallhand01","s_poslouchání za dveřmi 2","s_listen behind doors 2",13533),
INTERACT_LISTENWALLHAND02("interact_listenwallhand02","s_poslouchání za dveřmi 3","s_listen behind doors 3",13533),
INTERACT_MANIPULATE01("interact_manipulate01","i_manipulace 1","i_manipulation 1",5000),
INTERACT_MANIPULATE02("interact_manipulate02","i_manipulace 2","i_manipulation 2",5000),
INTERACT_PICKUP01("interact_pickup01","i_zvednutí 1","i_pick up 1",5000),
INTERACT_PICKUP02("interact_pickup02","i_zvednutí 2","i_pick up 2",5000),
INTERACT_PUSHBACK("interact_pushback","i_odstrčení osoby","i_pushing back",2166),
INTERACT_PUTDOWN01("interact_putdown01","i_položení 1","i_put down 1",5000),
INTERACT_PUTDOWN02("interact_putdown02","i_položení 2","i_put down 2",5000),
INTERACT_PUTFRONT01("interact_putfront01","i_položení před sebe 1","i_put front 1",5000),
INTERACT_PUTFRONT02("interact_putfront02","i_položení před sebe 2","i_put front 2",5000),
INTERACT_SHAKEHANDS("interact_shakehands","i_potřesení rukou","i_shaking hands",6700),
INTERACT_SHOULDERKNOCK("interact_shoulderknock","i_poklepání na rameno","i_knocking on shoulder",2633),
INTERACT_SIDEHUGLEFT("interact_sidehugleft","i_obejmutí zleva","i_hugging from left side",8500),
INTERACT_SIDEHUGLEFT_END("interact_sidehugleft_end","i_obejmutí zleva - konec","i_hugging from left side - end",2400),
INTERACT_SIDEHUGLEFT_LOOP("interact_sidehugleft_loop","i_obejmutí zleva - smyčka","i_hugging from left side - loop",4400),
INTERACT_SIDEHUGLEFT_START("interact_sidehugleft_start","i_obejmutí zleva - začátek","i_hugging from left side - start",1666),
INTERACT_SIDEHUGRIGHT("interact_sidehugright","i_obejmutí zprava","i_hugging from right side",8500),
INTERACT_SIDEHUGRIGHT_END("interact_sidehugright_end","i_obejmutí zprava - konec","i_hugging from right side - end",2400),
INTERACT_SIDEHUGRIGHT_LOOP("interact_sidehugright_loop","i_obejmutí zprava - smyčka","i_hugging from right side - loop",4400),
INTERACT_SIDEHUGRIGHT_START("interact_sidehugright_start","i_obejmutí zprava - začátek","i_hugging from right side - start",1666),
INTERACT_THROW01("interact_throw01","i_hození 1","i_throwing 1",2600),
INTERACT_THROW02("interact_throw02","i_hození 2","i_throwing 2",1500),
INTERACT_THROWFROMPOCKET01("interact_throwfrompocket01","i_hození z kapsy 1","i_throwing from pocket 1",4333),
INTERACT_THROWFROMPOCKET02("interact_throwfrompocket02","i_hození z kapsy 2","i_throwing from pocket 2",3333),
INTERACT_TOUCHHORRIFIED("interact_touchhorrified","i_dotyk vystrašený","i_touch horrified",10000),
INTERACT_WHATISTHIS("interact_whatisthis","i_co to je?","i_what is this?",8000),
NAVI_BIGJUMP("navi_bigjump","n_skok velký","n_jump big",6733),
NAVI_BLOWNBACK("navi_blownback","n_sražení k zemi","n_blowback",2466),
NAVI_CRAWL("navi_crawl","n_plazení","n_crawling",5466),
NAVI_IAMCHASED("navi_iamchased","p_běh někdo mě honí","m_run i am chased",3833),
NAVI_LIEONBACK01("navi_lieonback01","n_ležení na zádech 1","n_lying on back 1",13333),
NAVI_LIEONBACK02("navi_lieonback02","n_ležení na zádech 2","n_lying on back 2",13333),
NAVI_LIEONSTOMACH01("navi_lieonstomach01","n_ležení na břichu 1","n_lying on stomach 1",13333),
NAVI_LIEONSTOMACH02("navi_lieonstomach02","n_ležení na břichu 2","n_lying on stomach 2",13333),
NAVI_OPENDOOR_ANGRY("navi_opendoor_angry","n_otevírám dveře naštvaně","n_open door angry",2600),
NAVI_OPENDOOR_CONFIDENT("navi_opendoor_confident","n_otevírám dveře sebevědomě","n_open door confident",2466),
NAVI_OPENDOOR_CONFIDENT02("navi_opendoor_confident02","navi_opendoor_confident02","navi_opendoor_confident02",2200),
NAVI_OPENDOOR_DEPRESSED("navi_opendoor_depressed","n_otevírám dveře depresivně","n_open door depressed",4666),
NAVI_OPENDOOR_HAPPY("navi_opendoor_happy","n_otevírám dveře vesele","n_open door happy",3666),
NAVI_OPENDOOR_NORMAL("navi_opendoor_normal","n_otevírám dveře normálně","n_open door normal",5333),
NAVI_PUSH("navi_push","n_odtlačení","n_pushing",4133),
NAVI_RUNAWAY("navi_runaway","n_útěk","n_run away",3000),
NAVI_SIT01("navi_sit01","n_sedím 1","n_sitting 1",13333),
NAVI_SIT02("navi_sit02","n_sedím 2","n_sitting 2",13000),
NAVI_SITONGROUND01("navi_sitonground01","n_sedím na zemi 1","n_sitting on ground 1",6666),
NAVI_SITONGROUND02("navi_sitonground02","n_sedím na zemi 2","n_sitting on ground 2",6666),
NAVI_SLIP("navi_slip","n_uklouznutí","n_slip",3333),
NAVI_STAIRSDOWN01("navi_stairsdown01","p_chůze po schodech dolů 1","m_walk downstairs 1",1033),
NAVI_STAIRSDOWN02("navi_stairsdown02","p_chůze po schodech dolů 2","m_walk downstairs 2",1033),
NAVI_STAIRSUP01("navi_stairsup01","p_chůze po schodech nahoru 1","m_walk upstairs 1",1333),
NAVI_STAIRSUP02("navi_stairsup02","p_chůze po schodech nahoru 2","m_walk upstairs 2",1200),
NAVI_STANDUP("navi_standup","n_vstávání ze země","n_standing up",7333),
NAVI_STRAFELEFT01("navi_strafeleft01","n_úkrok vlevo 1","n_strafe left 1",1533),
NAVI_STRAFELEFT02("navi_strafeleft02","n_úkrok vlevo 2 dvojitý","n_strafe left 2 double",3000),
NAVI_STRAFELEFT03("navi_strafeleft03","n_úkrok vlevo 3","n_strafe left 3",1533),
NAVI_STRAFELEFT04("navi_strafeleft04","n_úkrok vlevo 4 dvojitý","n_strafe left 4 double",3000),
NAVI_STRAFERIGHT01("navi_straferight01","n_úkrok vpravo 1","n_strafe right 1",1533),
NAVI_STRAFERIGHT02("navi_straferight02","n_úkrok vpravo 2 dvojitý","n_strafe right 2 double",3000),
NAVI_STRAFERIGHT03("navi_straferight03","n_úkrok vpravo 3","n_strafe right 3",1533),
NAVI_STRAFERIGHT04("navi_straferight04","n_úkrok vpravo 4 dvojitý","n_strafe right 4 double",3000),
NAVI_STRAFESHORTLEFT("navi_strafeshortleft","n_úkrok vlevo krátký","n_strafe left short",3000),
NAVI_STRAFESHORTRIGHT("navi_strafeshortright","n_úkrok vpravo krátký","n_strafe right short",3000),
NAVI_TURNPLACE01("navi_turnplace01","n_otáčení na místě 1","n_turning in place 1",1366),
NAVI_TURNPLACE02("navi_turnplace02","n_otáčení na místě 2","n_turning in place 2",5000),
NONE("None","null","null",0),
RUN_DUCKING("run_ducking","p_běh se skláněním","m_ducking running",3200),
RUN_NORMAL("run_normal","p_běh","m_run",833),
RUN_NORMAL01("run_normal01","p_běh 1","m_running 1",800),
RUN_NORMAL02("run_normal02","p_běh 2","m_running 2",866),
RUN_SILLY("run_silly","p_směšný běh","m_run silly",900),
RUN_SPRINT_LOOP("run_sprint_loop","p_sprint","m_sprint",600),
RUN_SPRINT_LOOPSTART("run_sprint_loopstart","p_sprint začátek","m_sprint start",1066),
RUN_SPRINT_LOOPSTOP("run_sprint_loopstop","p_sprint konec","m_sprint stop",2066),
SOCIAL_AGREE01("social_agree01","s_souhlas 1","s_agree 1",5666),
SOCIAL_AGREE02("social_agree02","s_souhlas 2","s_agree 2",2000),
SOCIAL_ANGRYAGREE("social_angryagree","s_souhlas naštvaný","s_agree angry",5000),
SOCIAL_ANGRYEXPLAIN("social_angryexplain","s_vysvětlování naštvané","s_explain angry",12933),
SOCIAL_ANGRYLISTEN("social_angrylisten","s_poslouchání naštvané","s_listen angry",7900),
SOCIAL_ANGRYTALK01("social_angrytalk01","s_konverzace naštvaná 1","s_talk angry 1",6666),
SOCIAL_ANGRYTALK02("social_angrytalk02","s_konverzace naštvaná 2","s_talk angry 2",6666),
SOCIAL_APPLAUSE01("social_applause01","s_potlesk 1","s_applause 1",4000),
SOCIAL_APPLAUSE02("social_applause02","s_potlesk 2","s_applause 2",3866),
SOCIAL_BACK_HANDSCHEST("social_back_handschest","s_ucouvnutí se zdvihnutím rukou","s_backing with raised hands",3133),
SOCIAL_BIGLAUGH("social_biglaugh","s_výtlem","s_big laugh",8666),
SOCIAL_BRAVISSA("social_bravissA","s_bravo A","s_braviss A",3333),
SOCIAL_BRAVISSB("social_bravissB","s_bravo B","s_braviss B",6000),
SOCIAL_CALMDOWN("social_calmdown","s_uklidni se","s_calm down",9333),
SOCIAL_CALMDOWN_LEFT("social_calmdown_left","s_uklidňování zleva","s_calming from left side",4433),
SOCIAL_CALMDOWN_RIGHT("social_calmdown_right","s_uklidňování zprava","s_calming from right side",4433),
SOCIAL_CANTBELIEVE("social_cantbelieve","s_nemůže uvěřit","s_can't believe",3666),
SOCIAL_CHAMPIONS("social_champions","s_šampióni","s_champions",3000),
SOCIAL_CHEER("social_cheer","s_povzbuzování","s_cheering",6000),
SOCIAL_COMEHERE("social_comehere","s_pojď sem","s_come here",2966),
SOCIAL_COMETOME("social_cometome","s_pojď ke mně","s_come to me",2500),
SOCIAL_COMETOME02("social_cometome02","s_pojď ke mně","s_come to me",3500),
SOCIAL_COMPLIMENT01("social_compliment01","s_kompliment 1","s_compliment 1",6000),
SOCIAL_COMPLIMENT02("social_compliment02","s_kompliment 2","s_compliment 2",8033),
SOCIAL_CONVERSE01("social_converse01","s_konverzace 1","s_talk 1",30000),
SOCIAL_CONVERSE02("social_converse02","s_konverzace 2","s_talk 2",30000),
SOCIAL_CONVERSE02A("social_converse02A","s_konverzace 2A","s_talk 2A",4000),
SOCIAL_CONVERSE02B("social_converse02B","s_konverzace 2B","s_talk 2B",5466),
SOCIAL_CONVERSE02C("social_converse02C","s_konverzace 2C","s_talk 2C",4833),
SOCIAL_CONVERSE02D("social_converse02D","s_konverzace 2D","s_talk 2D",10666),
SOCIAL_COOING01("social_cooing01","s_rozplývám se 1","s_cooing 1",15000),
SOCIAL_COOING02("social_cooing02","s_rozplývám se 2","s_cooing 2",3800),
SOCIAL_COOING03("social_cooing03","s_rozplývám se 3","s_cooing 3",5300),
SOCIAL_COOING04("social_cooing04","s_rozplývám se 4","s_cooing 4",6633),
SOCIAL_DESPAIR01("social_despair01","s_zoufalství 1","s_despair 1",10000),
SOCIAL_DESPAIR02("social_despair02","s_zoufalství 2","s_despair 2",10000),
SOCIAL_DISAGREE("social_disagree","s_nesouhlas","s_disagree",17666),
SOCIAL_ENTHUSE("social_enthuse","s_nadšení","s_enthuse",3000),
SOCIAL_EXPLAIN("social_explain","s_vysvětlování","s_explaining",7333),
SOCIAL_FINALWORD("social_finalword","s_konverzace naštvaná poslední slovo","s_talk angry final word",17666),
SOCIAL_FUCKYOU("social_fuckyou","s_fakáč","s_insult",2200),
SOCIAL_GESTUREFRONT01("social_gesturefront01","s_gesta vpředu 1","s_gestures front 1",7033),
SOCIAL_GESTUREFRONT02("social_gesturefront02","s_gesta vpředu 2","s_gestures front 2",7033),
SOCIAL_GESTURELEFT01("social_gestureleft01","s_gesta vlevo 1","s_gestures left 1",2933),
SOCIAL_GESTURELEFT02("social_gestureleft02","s_gesta vlevo 2","s_gestures left 2",3966),
SOCIAL_GESTURELEFT03("social_gestureleft03","s_gesta vlevo 3","s_gestures left 3",4533),
SOCIAL_GESTURELEFT04("social_gestureleft04","s_gesta vlevo 4","s_gestures left 4",3566),
SOCIAL_GESTURERIGHT01("social_gestureright01","s_gesta vpravo 1","s_gestures right 1",3333),
SOCIAL_GESTURERIGHT02("social_gestureright02","s_gesta vpravo 2","s_gestures right 2",3900),
SOCIAL_GESTURERIGHT03("social_gestureright03","s_gesta vpravo 3","s_gestures right 3",3600),
SOCIAL_GESTURERIGHT04("social_gestureright04","s_gesta vpravo 4","s_gestures right 4",3566),
SOCIAL_GOTHIM("social_gothim","s_jo, mám to","s_got him",3000),
SOCIAL_HANDSFRONT("social_handsfront","s_ruce vpředu","s_hands in front",3300),
SOCIAL_HANDSNEXTHEAD("social_handsnexthead","s_ruce vedle hlavy","s_hands next to head",2066),
SOCIAL_HANDSONHIPS("social_handsonhips","s_ruce v bok","s_hands on hips",6766),
SOCIAL_HAPPYDANCE01("social_happydance01","s_tanec veselý 1","s_dance happy 1",5000),
SOCIAL_HAPPYDANCE02("social_happydance02","s_tanec veselý 2","s_dance happy 2",5000),
SOCIAL_HAPPYJUMP01("social_happyjump01","s_skok veselý 1","s_jump happy 1",1133),
SOCIAL_HAPPYJUMP02("social_happyjump02","s_skok veselý 2","s_jump happy 2",2333),
SOCIAL_HEADINPALMS("social_headinpalms","s_hlava v dlaních","s_head in hands",3366),
SOCIAL_HEADKNOCK("social_headknock","s_ťukání si na čelo","s_knocking on head",2466),
SOCIAL_HEYWATCHIT("social_heywatchit","s_zklidni to","s_hey watch it",6100),
SOCIAL_HISSYFIT("social_hissyfit","s_hysterák","s_hissyfit",4233),
SOCIAL_IDIDNOTHING("social_ididnothing","s_já nic, já muzikant","s_I did nothing",3500),
SOCIAL_IDONTTHINKSO("social_idontthinkso","s_to si nemyslím","s_I don't think so",3200),
SOCIAL_LISTEN("social_listen","s_poslouchání","s_listening",8333),
SOCIAL_LOVEACCEPT("social_loveaccept","s_vyznání přijmuté","s_confess accepted",5266),
SOCIAL_LOVECONFESS01("social_loveconfess01","s_vyznání 1","s_confess 1",10333),
SOCIAL_LOVECONFESS02("social_loveconfess02","s_vyznání 2","s_confess 2",8000),
SOCIAL_LOVEPROPOSAL("social_loveproposal","s_neslušný návrh","s_nasty proposal",11800),
SOCIAL_LOVEREFUSE("social_loverefuse","s_vyznání odmítnuté","s_confess rejected",3500),
SOCIAL_MEMEME("social_mememe","s_já já já","s_me me me",3000),
SOCIAL_NOWAY("social_noway","s_to v žádném případě","s_no way",3866),
SOCIAL_PERSUASION("social_persuasion","s_přesvědčování","s_persuasion",16600),
SOCIAL_PLEADING01("social_pleading01","s_prošení 1","s_pleading 1",9766),
SOCIAL_PLEADING02("social_pleading02","s_prošení 2","s_pleading 2",4000),
SOCIAL_POINTANGRY("social_pointangry","s_ukázání naštvané","s_point angry",1460),
SOCIAL_POINTDOWN("social_pointdown","s_ukázání dolů","s_point down",2500),
SOCIAL_POINTFRONT02("social_pointfront02","s_ukázování dopředu","s_pointing in front",2666),
SOCIAL_POINTHYSTERIC("social_pointhysteric","s_ukázání hysterické","s_point hysteric",1580),
SOCIAL_POINTSIDEHEAD_LEFT("social_pointsidehead_left","s_Ukazování doleva s otočením hlavy","s_pointing left, turning head",2266),
SOCIAL_POINTSIDEHEAD_RIGHT("social_pointsidehead_right","s_Ukazování doprava s otočením hlavy","s_pointing right, turning head",2266),
SOCIAL_POINTSIDE_LEFT("social_pointside_left","s_Ukazovaní doleva","s_pointing left",3133),
SOCIAL_POINTSIDE_RIGHT("social_pointside_right","s_Ukazovaní doprava","s_pointing right",3133),
SOCIAL_PROTECT("social_protect","s_ochranné gesto","s_protective gesture",19500),
SOCIAL_PROTECT_SHORT("social_protect_short","s_ochranné gesto krátké","s_protective gesture short",4633),
SOCIAL_SHOCKED("social_shocked","s_šokovaný","s_shocked",4000),
SOCIAL_SHOUTWAVE("social_shoutwave","s_hulákání","s_shouting",5333),
SOCIAL_SHOUTWAVEBIG("social_shoutwavebig","s_hulákání velké","s_shouting big",5333),
SOCIAL_SHRUG("social_shrug","s_krčení rameny","s_shrugging",2333),
SOCIAL_SIGH("social_sigh","s_pozvdech","s_sigh",3166),
SOCIAL_SLAP("social_slap","b_facka","f_slap",1066),
SOCIAL_SPEAKLEFT01("social_speakleft01","s_konverzace vlevo 1","s_talk left 1",8833),
SOCIAL_SPEAKLEFT02("social_speakleft02","s_konverzace vlevo 2","s_talk left 2",4366),
SOCIAL_SPEAKRIGHT01("social_speakright01","s_konverzace vpravo 1","s_talk right 1",10000),
SOCIAL_SPEAKRIGHT02("social_speakright02","s_konverzace vpravo 2","s_talk right 2",4333),
SOCIAL_TALKIMPORTANT("social_talkimportant","s_konverzace důležitá","s_talk important",13333),
SOCIAL_THATSIT("social_thatsit","s_to je ono","s_that's it",2766),
SOCIAL_THREATEN("social_threaten","s_vyhrožování","s_threatening",6333),
SOCIAL_TURNLEAVE("social_turnleave","s_otočení se naštvané","s_turn away angry",2500),
SOCIAL_WAITHERE("social_waithere","s_počkej tady","s_wait here",5666),
SOCIAL_WAVEFAR("social_wavefar","s_zamávání nadaleko","s_wave far",3000),
SOCIAL_WAVENEAR("social_wavenear","s_zamávání nablízko","s_wave near",2933),
SOCIAL_WHATEVER("social_whatever","s_cokoli chceš","s_whatever",3966),
SOCIAL_YOUKNOW("social_youknow","s_víš","s_you know",2666),
SOCIAL_YOUSEE("social_yousee","s_vidíš","s_you see",2100),
SPRINT_LOOP("sprint_loop","p_sprint","m_sprint",600),
SPRINT_LOOPSTART("sprint_loopstart","p_počátek sprintu","m_sprint start",1067),
SPRINT_LOOPSTOP("sprint_loopstop","p_konec sprintu","m_sprint stop",2067),
UDN_BCROUCH("BCrouch","p_přikrčená chůze zpět","m_crouched walking back",1000),
UDN_BRUN("bRun","p_běh pozpátku","m_running back",1066),
UDN_BWALK("bWalk","p_chůze pozpátku","m_walking back",1000),
UDN_CROUCHIDLE("CrouchIdle","st_přikrčený","st_crouched",533),
UDN_FCROUCH("FCrouch","p_přikrčená chůze","m_crouched walking",1000),
UDN_FRUN("FRun","p_běh","m_running",1066),
UDN_FSPRINT("FSprint","p_sprint","m_sprint",666),
UDN_FWALK("FWalk","p_chůze","m_walking",1000),
UDN_HOLDGUN("HoldGun","b_držení zbraně","f_holding gun",533),
UDN_IDLEBREATHE("IdleBreathe","a_dýchání","a_breathing",2033),
UDN_IDLEEARRING("IdleEarring","a_navlékání náušnice","a_breathing",1033),
UDN_IDLEGLOVES("IdleGloves","a_navlékání rukavic","a_taking gloves",3367),
UDN_IDLEHIP("IdleHip","a_založení rukou v bok","a_hip",1033),
UDN_IDLEISCRATCH("IdleIScratch","a_poškrábání se","a_scratching",2033),
UDN_IDLEKNUCKLES("IdleKnuckles","a_prokřupnutí kloubů","_knuckles",2167),
UDN_IDLENECK("IdleNeck","a_prokřupnutí krku","a_neck",3033),
UDN_IDLENOSE("IdleNose","a_poškrábání na nose","a_scratching nose",1533),
UDN_IDLESTRETCH("IdleStretch","a_protažení se","a_stretching",2366),
UDN_IDLETWIST("IdleTwist","a_twist","a_twist",1033),
UDN_JUMP("Jump","p_výskok","m_jump",1367),
UDN_LCROUCH("LCrouch","p_přikrčená chůze vlevo","m_crouched walking left",1000),
UDN_LRUN("LRun","p_běh doleva","m_running left",1066),
UDN_LWALK("LWalk","p_chůze vlevo","m_walking left",1033),
UDN_PICKUP("PickUp","i_zvednutí","i_pick up",1700),
UDN_PUSH("Push","i_tlačení","i_pushing",3700),
UDN_RCROUCH("RCrouch","p_přikrčená chůze vpravo","m_crouched walking right",1000),
UDN_RIFLE("Rifle","b_střelba z pušky","f_rifle shooting",1033),
UDN_RRUN("RRun","p_běh vpravo","m_running right",1066),
UDN_RWALK("RWalk","p_chůze vpravo","m_walking right",1000),
UDN_SHOVE("Shove","i_postrčení","i_shoving",1000),
UDN_SNOWBALL("SnowBall","i_uplácání koule","i_snow ball",3033),
UDN_SWIM("Swim","p_plavání","m_swimming",1667),
UDN_THROW("Throw","i_hození","i_throwing",2300),
WALK_ANGRY01("walk_angry01","p_chůze naštvaná 1","m_walk angry 1",2200),
WALK_ANGRY02("walk_angry02","p_chůze naštvaná 2","m_walk angry 2",2200),
WALK_BACK("walk_back","p_couvání","m_backing",2800),
WALK_BACKWALK("walk_backwalk","p_chůze zpět","m_walking back",2600),
WALK_BACK_LOOP("walk_back_loop","p_couvání - smyčka","m_backing - loop",1366),
WALK_BACK_REACTIONTOPUSH("walk_back_reactiontopush","p_reakce na odstrčení","m_reaction to being pushed",1566),
WALK_CARRY01("walk_carry01","p_chůze něco nesu 1","m_walk carry 1",1333),
WALK_CARRY02("walk_carry02","p_chůze něco nesu 2","m_walk carry 2",1333),
WALK_CONFIDENT("walk_confident","p_chůze sebejistá","m_walk confident",12000),
WALK_CONFIDENTSHORT("walk_confidentshort","p_chůze sebejistá krátká","m_walk confident short",3666),
WALK_COOING01("walk_cooing01","p_chůze rozplývám se 1","m_walk cooing 1",14666),
WALK_COOING01START("walk_cooing01start","p_chůze rozplývám se 1 začátek","m_walk cooing 1 start",1433),
WALK_COOING02("walk_cooing02","p_chůze rozplývám se 2","m_walk cooing 2",14666),
WALK_COOING02START("walk_cooing02start","p_chůze rozplývám se 2 začátek","m_walk cooing 2 start",1433),
WALK_COOING03("walk_cooing03","p_chůze rozplývám se 3","m_walk cooing 3",4000),
WALK_COOING04("walk_cooing04","p_chůze rozplývám se 4","m_walk cooing 4",4000),
WALK_COOING05("walk_cooing05","p_chůze rozplývám se 5","m_walk cooing 5",5333),
WALK_COOING06("walk_cooing06","p_chůze rozplývám se 6","m_walk cooing 6",5333),
WALK_COOING07("walk_cooing07","p_chůze rozplývám se 7","m_walk cooing 7",6666),
WALK_COOING08("walk_cooing08","p_chůze rozplývám se 8","m_walk cooing 8",6666),
WALK_DEPRESSED("walk_depressed","p_chůze depresivní","m_walk depressed",5200),
WALK_DEPRESSEDSHORT("walk_depressedshort","p_chůze depresivní krátká","m_walk depressed short",1666),
WALK_DIZZY("walk_dizzy","p_omámená chůze","m_walk dizzy",4367),
WALK_DRUNK("walk_drunk","p_chůze opilá","m_walk drunk",4333),
WALK_ENTHUSE01("walk_enthuse01","p_chůze nadšená 1","m_walk enthuse 1",2666),
WALK_ENTHUSE02("walk_enthuse02","p_chůze nadšená 2","m_walk enthuse 2",3433),
WALK_HAPPY("walk_happy","p_chůze veselá","m_walk happy",14666),
WALK_HAPPYSHORT("walk_happyshort","p_chůze veselá krátká","m_walk happy short",1833),
WALK_HEADTURNING("walk_headturning","p_kroucení hlavou","m_shaking head",3000),
WALK_INJURED("walk_injured","p_chůze zraněná","m_walk injured",1166),
WALK_LOOP("walk_loop","p_chůze","m_walk",1000),
WALK_LOOPSTART("walk_loopstart","p_chůze začátek","m_walk start",1600),
WALK_LOOPSTOP("walk_loopstop","p_chůze konec","m_walk stop",1933),
WALK_MONSTER01("walk_monster01","p_chůze frankenstein 1","m_walk frankenstein 1",4666),
WALK_MONSTER02("walk_monster02","p_chůze frankenstein 2","m_walk frankenstein 2",4666),
WALK_NORMAL("walk_normal","p_normální chůze","m_walk normal",1367),
WALK_NORMAL01("walk_normal01","p_chůze normální 1","m_walk normal 1",1333),
WALK_NORMAL02("walk_normal02","p_chůze normální 2","m_walk normal 2",1333),
WALK_SEXY("walk_sexy","p_chůze sexy","m_walk sexy",15833),
WALK_SEXYSHORT("walk_sexyshort","p_chůze krátká","m_walk sexy short",2500),
WALK_SPEAKLEFT_FEMALE01("walk_speakleft_female01","p_chůze žena mluvím vlevo 1","m_walk female speakleft 1",3500),
WALK_SPEAKLEFT_FEMALE02("walk_speakleft_female02","p_chůze žena mluvím vlevo 2","m_walk female speakleft 2",3900),
WALK_SPEAKLEFT_MALE01("walk_speakleft_male01","p_chůze muž mluvím vlevo 1","m_walk male speakleft 1",3466),
WALK_SPEAKLEFT_MALE02("walk_speakleft_male02","p_chůze muž mluvím vlevo 2","m_walk male speakleft 2",3900),
WALK_SPEAKRIGHT_FEMALE01("walk_speakright_female01","p_chůze žena mluvím vpravo 1","m_walk female speakright 1",4000),
WALK_SPEAKRIGHT_FEMALE02("walk_speakright_female02","p_chůze žena mluvím vpravo 2","m_walk female speakright 2",3966),
WALK_SPEAKRIGHT_MALE01("walk_speakright_male01","p_chůze muž mluvím vpravo 1","m_walk male speakright 1",3566),
WALK_SPEAKRIGHT_MALE02("walk_speakright_male02","p_chůze muž mluvím vpravo 2","m_walk male speakright 2",4000),
WALK_TIRED("walk_tired","p_chůze unavená","m_walk tired",5000),
WALK_ZOMBIE01("walk_zombie01","p_chůze zombie 1","m_walk zombie 1",4000),
WALK_ZOMBIE02("walk_zombie02","p_chůze zombie 2","m_walk zombie 2",4000);

    /** ID of the animation in unreal*/
    String unrealID;
    /** czech description of the animation */
    String nameCZ;
    /** english description of the animation */
    String nameEN;
    /** duration in ms */
    int duration; //in ms

    /**
     * How long is this animation played in ms.
     * @return
     */
    public int getDuration() {
        return duration;
    }

    public String getNameCZ() {
        return nameCZ;
    }

    public String getNameEN() {
        return nameEN;
    }

    /**
     * Returns Id of the animation in Unreal.
     * @return
     */
    public String getUnrealID() {
        return unrealID;
    }

    /**
     * Default constructor. 
     * @param unrealID
     * @param nameCZ
     * @param nameEN
     * @param duration
     */
    AnimType(String unrealID, String nameCZ, String nameEN, int duration) {
        this.unrealID = unrealID;
        this.nameCZ = nameCZ;
        this.nameEN = nameEN;
        this.duration = duration;
    }
}
