/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.bot.impl;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Animations;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Emoticons;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Inventory;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Places;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Steering;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.Communication;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import java.util.Random;
import java.util.logging.Logger;

public class EmohawkBotController<BOT extends UT2004Bot>
extends UT2004BotLogicController<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected Senses senses;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected AdvancedLocomotion move;
    protected Communication comm;
    protected UT2004PathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected UT2004Navigation navigation;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected IVisionWorldView world;
    protected IAct act;
    protected AgentStats stats;
    protected FloydWarshallMap fwMap;
    protected Animations animations;
    protected Emoticons emoticons;
    protected Places places;
    protected Steering steering;
    protected Inventory inventory;

    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.initializeModules(bot);
        this.initializePathFinding(bot);
        this.initializeListeners(bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.getWorldView(), (Logger)bot.getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.pathPlanner = new UT2004AStarPathPlanner(bot);
        this.fwMap = new FloydWarshallMap(bot);
        this.pathExecutor = new UT2004PathExecutor(bot, (IUT2004PathNavigator)new LoqueNavigator(bot, (IUT2004PathRunner)new KefikRunner(bot, this.info, this.move, (Logger)bot.getLog()), (Logger)bot.getLog()));
        this.navigation = new UT2004Navigation(bot, this.pathExecutor, this.fwMap);
    }

    protected void initializeModules(BOT bot) {
        this.game = new Game(bot);
        this.info = new AgentInfo(bot, this.game);
        this.players = new Players(bot);
        this.senses = new Senses(bot, this.info, this.players);
        this.config = new AgentConfig(bot);
        this.raycasting = new Raycasting(bot);
        this.move = new AdvancedLocomotion(this.getBot(), (Logger)this.getBot().getLogger().getCategory("Move"));
        this.comm = new Communication(this.getBot(), (Logger)this.getBot().getLogger().getCategory("Communicaton"));
        this.stats = new AgentStats(bot);
        this.animations = new Animations((UT2004Bot)bot);
        this.emoticons = new Emoticons((UT2004Bot)bot);
        this.places = new Places((UT2004Bot)bot);
        this.steering = new Steering((UT2004Bot)bot);
        this.inventory = new Inventory((UT2004Bot)bot);
    }

    public void finishControllerInitialization() {
    }

    public Random getRandom() {
        return this.random;
    }

    public Game getGame() {
        return this.game;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public Players getPlayers() {
        return this.players;
    }

    public Senses getSenses() {
        return this.senses;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public AdvancedLocomotion getMove() {
        return this.move;
    }

    public IUnrealPathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    public IPathPlanner<ILocated> getPathPlanner() {
        return this.pathPlanner;
    }

    public IVisionWorldView getWorld() {
        return this.world;
    }

    public IAct getAct() {
        return this.bot.getAct();
    }

    public AgentStats getStats() {
        return this.stats;
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public UT2004Navigation getNavigation() {
        return this.navigation;
    }

    public UT2004Bot getBot() {
        return this.bot;
    }
}

