package cz.cuni.amis.pogamut.emohawkVille.agent.module.sensor;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;

public class Game extends cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game {
	
	/** Constructor
	 * 
	 * Setups the memory module based on bot's world view.
	 * @param bot owner of the module that is using it
	 */
	public Game(UT2004Bot<?,?,?> bot, Logger log) {
		super(bot, log);
	}

	/** Constructor
	 * 
	 * Setups the memory module based on bot's world view.
	 * @param bot owner of the module that is using it
	 * @param log Logger to be used for logging runtime/debug info. If <i>null</i>, the module creates its own logger.
	 */
	public Game(UT2004Bot<?,?,?> bot) {
		super(bot);
	}

	/** Get the ambient temperature
	 *  
	 * @return ambient temperature in degrees of celsius
	 */
	public float getAmbientTemperature() {
		return 20.0f;
	}

	/** Get the water boiling point
	 *  
	 * @return the water boiling point in degrees of celsius
	 */
	public float getWaterBoilingPoint() {
		return 100.0f;
	}
	
	/** Get the water enthalpy of vaporization
	 * 
	 * @return heat in joules required to vaporize 1.0 kilogram of water
	 */
	public float getWaterEnthalpyOfVaporization() {
		return 2260000.0f;
	}
}
