package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;


/** Potato slices
 */
public class PotatoSliceReplica extends AbstractVegetableSliceReplica implements IPotatoSlice {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0030f; 
	
	@Override
	public String getDisplayName() {
		return "Potato slice";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			PotatoReplica.COOKING_BASE_TEMPERATURE,
			PotatoReplica.COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			PotatoReplica.COOKING_BASE_TEMPERATURE,
			PotatoReplica.COOKING_STANDARD_TEMPERATURE,
			PotatoReplica.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			PotatoReplica.CHARREDNESS_RESISTANCE,
			PotatoReplica.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			PotatoReplica.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = PotatoReplica.BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = PotatoReplica.VOLUME_PER_WHOLE/PotatoReplica.SLICES_PER_WHOLE;
	}
}