package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.AbstractEssenceReplica;

/** Stove essence
 * 
 * Parent of stove plates.
 */
public class StoveReplica extends AbstractEssenceReplica implements IStove {

	public static final int PLATE_COUNT = 4;
	public static final int MAX_POWER = 6;

	public static final float HEAT_PER_POWER_PER_TICK = 18000.0f; // in joules
	public static final float HEATING_TICK_PERIOD = 1.0f; // seconds
	
	protected static final String PLATES_ATTR = "plates";
	protected static final String POWERS_ATTR = "powers";
	
	@Override
	public StovePlateReplica getPlate( int index ) {
		assert( 0 <= index && index < 4 );
		int i=0;
		for ( FoggyRefReplica ref : attributes.refLists().read( PLATES_ATTR ) ) {
			if ( i == index ) {
				if ( ref.isHidden() ) {
					return null;
				} else {
					return (StovePlateReplica) ref.get();
				}
			}
			++i;
		}
		throw new AssertionError( "Invalid index." );
	}
	
	@Override
	public int getPower( int index ) {
		assert( 0 <= index && index < PLATE_COUNT );
		int i=0;
		for ( Integer value : attributes.intLists().read( POWERS_ATTR ) ) {
			if ( i == index ) {
				return  value;
			}
			++i;
		}
		throw new AssertionError( "Invalid index." );
	}
}