package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.AbstractEssenceReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.PossessorComponent;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;

/** Stove plate essence
 * 
 * Container holding up to one cooking pot or one frying pan.
 */
public class StovePlateReplica extends AbstractEssenceReplica implements IStovePlate, IContainerReplica {

	public static final float HEAT_RADIATION_FACTOR_PER_TICK = 0.1f; // how big part of excess heat is radiated per tick
	public static final float HEAT_CAPACITY = 4500.0f; // heat capacity in joules per kelvin
	public static final float THERMAL_TICK_PERIOD = 1.0f; // seconds
	
	protected static final String STOVE_ATTR = "stove";
	protected static final String TEMPERATURE_ATTR = "temperature";
	
	protected PossessorComponent possessorComponent;
	
	@Override
	public float getTemperature() {
		return attributes.floats().get( TEMPERATURE_ATTR );
	}
	
	@Override
	public boolean canStore( IItem item ) {
		return item instanceof ICookware && readInventory().isEmpty();
	}
	
	@Override
	public boolean canRelease( IItem item ) {
		return true;
	}
	
	@Override
	public Collection<? extends IItemReplica> readInventory() {
		return possessorComponent.readInventory();
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId) {
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		possessorComponent =  new PossessorComponent( this, this );
	}
		
	@Override
	public StoveReplica getStove() {
		if ( attributes.refs().isHidden( STOVE_ATTR ) ) {
			return null;
		}
		return (StoveReplica) attributes.refs().get( STOVE_ATTR );
	}
}