package cz.cuni.amis.pogamut.emohawkVille.agent.module.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action.ActionRegistryReplica;


/** Map of associations of replicable objects for emohawk ville
 * 
 * This map is aware of ville specialized classes.
 * @author Paletz
 */
public class EssenceMap extends cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.essence.EssenceMap implements IEssenceMap {
	
	public EssenceMap(IVisionWorldView worldView) {
		super(worldView);
	}

	/** Associate action registry
	 * 
	 * @param actionRegistry action registry, must be emohawk ville action registry
	 */
	public void associateActionRegistry( 
		cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.ActionRegistryReplica actionRegistry 
	) {
		assert( actionRegistry instanceof ActionRegistryReplica );
		this.actionRegistry = actionRegistry;
	}
	
	/** Associate PawnReplica object with a bot ID
	 * 
	 * @param botId bot ID
	 * @param pawn PawnReplica object, must be Emohawk Ville pawn
	 */
	@Override
	public void associatePawn(String botId, cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplica pawn) {
		assert( pawn instanceof PawnReplica );
		super.associatePawn(botId, pawn);
	}
	
	@Override
	public PawnReplica retrievePawn( String botId ) {
		return (PawnReplica) super.retrievePawn(botId);
	}
	
	@Override
	public PawnReplica retrievePawn( IWorldObject worldObject ) {
		return (PawnReplica) super.retrievePawn(worldObject);
	}
	
	@Override
	public ActionRegistryReplica retrieveActionRegistry() {
		return (ActionRegistryReplica) actionRegistry;
	}
}
