package cz.cuni.amis.pogamut.emohawkVille.agent.navigation;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;

/** Calm runner
 *
 * This runner avoids acrobatics that would seem unnatural in calm settings.
 *  
 * @author Paletz
 */
public class CalmRunner implements IUT2004PathRunner {
    
    protected AdvancedLocomotion movement;
    
    public CalmRunner( AdvancedLocomotion movement ) {  
        this.movement = movement;
        
        reset();
    }
    
    @Override
    public void reset()
    {
    }
    
    /**
     * Handles running directly to the specified location.
     *
     * @param firstLocation Location to which to run.
     * @param secondLocation Location where to continue (may be null).
     * @param focus Location to which to look.
     * @param reachable Whether the location is reachable.
     * @return True, if no problem occured.
     */
    @Override
    public boolean runToLocation(Location runningFrom, Location firstLocation, Location secondLocation, ILocated focus, NavPointNeighbourLink navPointLink, boolean reachable)
    {
        movement.moveTo( firstLocation ); 
        
        return true;
    }
 }
