package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware;

import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplica;

/** Cooking pot item
 * 
 * Can hold cooking ingredients.
 */
public class CookingPotReplica extends AbstractCookwareReplica implements ICookingPot {

	public static final CookwareStats STATS = new CookwareStats( 0.2f, 0.1f, 4500.0f, 4.0f );
	public static final String DISPLAY_NAME = "Cooking pot";
	
	protected static final String STIRRER_ATTR = "stirrer";
		
	@Override
	public String getDisplayName()	{
		return DISPLAY_NAME;
	}
	
	@Override
	public boolean isStirrerHidden() {
		return attributes.refs().isHidden( STIRRER_ATTR );
	}
	
	@Override
	public PawnReplica getStirrer() {
		return (PawnReplica) attributes.refs().get( STIRRER_ATTR );
	}
	
	/** See EvAbstractCookware
	 */
	protected void initializeParameters() {
		stats = STATS;
	}
}