package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.meat;


/** Pork slices
 * 
 * Cooking behavior is same as pork's.
 */
public class PorkBitReplica extends AbstractMeatBitReplica implements IPorkBit {
	
	@Override
	public String getDisplayName() {
		return "Pork slice";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			PorkReplica.BOILING_BASE_TEMPERATURE,
			PorkReplica.BOILING_STANDARD_TEMPERATURE,
			PorkReplica.BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeFryingBehavior(
			PorkReplica.FRYING_BASE_TEMPERATURE,
			PorkReplica.FRYING_STANDARD_TEMPERATURE,
			PorkReplica.FRIEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			PorkReplica.CHARRING_BASE_TEMPERATURE,
			PorkReplica.CHARRING_STANDARD_TEMPERATURE,
			PorkReplica.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			PorkReplica.CHARREDNESS_RESISTANCE,
			PorkReplica.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			PorkReplica.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = PorkReplica.BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = PorkReplica.VOLUME_PER_WHOLE/PorkReplica.SLICES_PER_WHOLE;
	}
}