package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.meat;

/** Beef bits
 * 
 * Cooking behavior is same as Beef's.
 */
public class BeefBitReplica extends AbstractMeatBitReplica implements IBeefBit {
		
	@Override
	public String getDisplayName() {
		return "Beef slice";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			BeefReplica.BOILING_BASE_TEMPERATURE,
			BeefReplica.BOILING_STANDARD_TEMPERATURE,
			BeefReplica.BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeFryingBehavior(
			BeefReplica.FRYING_BASE_TEMPERATURE,
			BeefReplica.FRYING_STANDARD_TEMPERATURE,
			BeefReplica.FRIEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			BeefReplica.CHARRING_BASE_TEMPERATURE,
			BeefReplica.CHARRING_STANDARD_TEMPERATURE,
			BeefReplica.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			BeefReplica.CHARREDNESS_RESISTANCE,
			BeefReplica.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			BeefReplica.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BeefReplica.BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = BeefReplica.VOLUME_PER_WHOLE/BeefReplica.SLICES_PER_WHOLE;
	}
}