package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.AbstractCountableItemMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.AbstractSolidIngredientSliceReplica;

/** Abstract solid ingredient slice memorization
 */
public class AbstractSolidIngredientSliceMemorization
	<MemorizedClass extends AbstractSolidIngredientSliceReplica>
	extends AbstractCountableItemMemorization<MemorizedClass> 
	implements IBrothableIngredientMemorization<MemorizedClass>, ICharrableIngredientMemorization<MemorizedClass>, IBoilableIngredientMemorization<MemorizedClass> {
	
	protected float boiledness, charredness, brothStrengthPotential, volume;
	
	public AbstractSolidIngredientSliceMemorization(
		MemorizedClass object, 
		ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, deferredConstructorChainer );
		boiledness = object.getBoiledness();
		charredness = object.getCharredness();
		brothStrengthPotential = object.getBrothStrengthPotential();
		volume = object.getVolume();
	}

	@Override
	public float getBoiledness() {
		return boiledness;
	}
	
	@Override
	public float getCharredness() {
		return charredness;
	}

	@Override
	public float getBrothStrengthPotential() {
		return brothStrengthPotential;
	}

	@Override
	public float getVolume() {
		return volume;
	}
}