package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.IChoppableItemReplication;

/** Abstract solid ingredient
 * 
 * Can be sliced.
 */
public abstract class AbstractSolidIngredientReplication extends AbstractItem implements IChoppableItemReplication, IBrothableIngredientReplication, ICharrableIngredientReplication, IBoilableIngredientReplication {
	
	protected static final String FRACTION_ATTR = "fraction";
	
	protected IngredientComponent ingredientComponent;
	protected float brothStrengthPotential;
	protected float volumePerWhole;
	protected float slicesPerSecond;
	protected int slicesPerWhole;
	
	@Override
	public float getBrothStrengthPotential() {
		return brothStrengthPotential*getVolume();
	}
	
	@Override
	public float getVolume() {
		return volumePerWhole*getFraction();
	}
	
	@Override
	public float getCharredness() {
		return ingredientComponent.getCharredness();
	}
	
	@Override
	public float getBoiledness() {
		return ingredientComponent.getBoiledness();
	}
	
	@Override
	public float getFraction() {
		return attributes.floats().get( FRACTION_ATTR );
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId ) {
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		ingredientComponent = new IngredientComponent( this );
		initializeParameters();
	}
	
	/** Initilialize parameters
	 * 
	 * ingredientComponent ingredient behavior
	 * brothStrengthPotential broth strentgh boiled per vegetable volume*magnitude*time/broth volume
	 * volumePerWhole volume of whole vegetable
	 * slicesPerSecond slices per second chopped by the chop action
	 * slicesPerWhole slices composing whole vegetable
	 */
	protected abstract void initializeParameters();
}