package cz.cuni.amis.pogamut.emohawk.communication.action;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;


/** Command to perform action
 * 
 * NOTE: Action parameters can be transmitted by the primitive data stream prior to this message. 
 * Check documentation of the particular action in question.
 * 
 * @author Paletz
 */
public class PerformAction extends CommandMessage {
	
	protected ReplicationId performerId;
	protected ReplicationId actionId;
	protected int userRequestId;
	
    public PerformAction( 
    	ReplicationId performerId,
    	ReplicationId actionId,
    	int userRequestId
    ) {
        this.performerId = performerId;
        this.actionId = actionId;
        this.userRequestId = userRequestId;
    }
    
	/** Convert to string
	 * 
	 * @return string representation that can be sent to gamebots
	 */
	@Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append( "SACRQ " );
        builder.append( performerId.toGbMessageParameter( "Performer" ) );
        builder.append( " " );
        builder.append( actionId.toGbMessageParameter( "Action" ) );
        builder.append( " " );
        builder.append( "{UserRequestId "+userRequestId+"}" );
        return builder.toString();
    }
 }
