package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicatedObjectTracker;
import cz.cuni.amis.pogamut.emohawk.communication.stream.BoolPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.BoolPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.DataPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.FloatPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.FloatPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IntPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IntPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.ObjectRefPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StringPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StringPacketInfoMessage;

/** Manager of streams between pogamut and Unreal
 * 
 * @author Paletz
 */
public class StreamManager {
	
	protected IWorldView world;
	protected IAct act;
	protected IReplicatedObjectTracker objectTracker;
	protected ObjectStreamBuffer inputBuffer;
	 
	/** Constructor
	 * 
	 * @param world world view
	 * @param act act 
	 * @param objectTracker Replicated object tracker, so that input stream can decode object references
	 */
	public StreamManager( IWorldView world, IAct act, IReplicatedObjectTracker objectTracker ) {
		this.act = act;
		this.world = world;
		this.objectTracker = objectTracker;
		this.inputBuffer = new ObjectStreamBuffer();
		
		world.addEventListener( DataPacketInfoMessage.class, dataListener );
	}
	
	public IInputObjectStream getInputStream() {
		return inputBuffer;
	}
	
	public void clearInput() {
		inputBuffer.clear();
	}
	
	public IOutputStream getOutputStream() {
		return upstream;
	}
	
	protected IWorldEventListener<DataPacketInfoMessage<?>> dataListener = new IWorldEventListener<DataPacketInfoMessage<?>>() {
		@Override
		public void notify( DataPacketInfoMessage<?> event ) {
			if ( event instanceof IntPacketInfoMessage ) {
				inputBuffer.writeInt( ((IntPacketInfoMessage) event).getValue() );
			} else if ( event instanceof FloatPacketInfoMessage ) {
				inputBuffer.writeFloat( ((FloatPacketInfoMessage) event).getValue() );
			} else if ( event instanceof BoolPacketInfoMessage ) {
				inputBuffer.writeBool( ((BoolPacketInfoMessage) event).getValue() );
			} else if ( event instanceof StringPacketInfoMessage ) {
				inputBuffer.writeString( ((StringPacketInfoMessage) event).getValue() );
			} else if ( event instanceof ObjectRefPacketInfoMessage ) {
				ObjectRefPacketInfoMessage refPacket = (ObjectRefPacketInfoMessage) event;
				if ( refPacket.getValue() != -1 ) {
					inputBuffer.writeObjectRef( objectTracker.getObject( refPacket.getValue() ) );					
				} else {
					inputBuffer.writeObjectRef( null );
				}
			} else {
				throw new RuntimeException( "Unexpected DataPacket class "+event.getClass() );
			}
		}
	};
	
	protected IOutputStream upstream = new IOutputStream() {
		
		@Override
		public void writeString(String value) {
			StringPacketCommand packet = new StringPacketCommand();
			packet.setValue( value );
			act.act( packet );
		}
				
		@Override
		public void writeInt(int value) {
			IntPacketCommand packet = new IntPacketCommand();
			packet.setValue( value );
			act.act( packet );
		}
		
		@Override
		public void writeFloat(float value) {
			FloatPacketCommand packet = new FloatPacketCommand();
			packet.setValue( value );
			act.act( packet );
		}
		
		@Override
		public void writeBool(boolean value) {
			BoolPacketCommand packet = new BoolPacketCommand();
			packet.setValue( value );
			act.act( packet );
		}
	};
}
