package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist;

import java.util.Collection;
import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;

/** List attribute view
 *  
 * Filters attribute not matching given list type.
 */
public interface IListAttributeView<Element> {

	/** Get read-only value list of an existing attribute
	 * 
	 * Not available for write attributes on client-side.
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value list
	 */
	Collection<Element> read( String attributeName );
	
	/** Set value list of an existing remote attribute
	 *
	 * Available only for write attributes on client-side.
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value list that shall be copied to the attribute
	 */
	void send( String attributeName, Iterable<Element> value );

	/** Tell if attribute exists and has the right type
	 * 
	 * @param attributeName attribute name
	 * @param access required access
	 * @return true if attribute exists and has the right type and access
	 */
	boolean exists( String attributeName, AttributeAccess access );
	
	/** Iterate over attributes in view
	 * 
	 * @return view iterator
	 */
	Iterator<ListMapEntryReplica<ListAttributeReplica<Element>>> iterator();
}