package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref.IFoggyRefAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist.IFoggyRefListAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.IPrimitiveAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist.IListAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;

public interface IAttributeManagerReplica {
	/** Access integer attributes
	 *  
	 * @return integer attribute view
	 */
	IPrimitiveAttributeView<Integer> ints();
	
	/** Access float attributes
	 *  
	 * @return float attribute view
	 */
	IPrimitiveAttributeView<Float> floats();
	
	/** Access boolean attributes
	 *  
	 * @return boolean attribute view
	 */
	IPrimitiveAttributeView<Boolean> bools();
	
	/** Access string attributes
	 *  
	 * @return string attribute view
	 */
	IPrimitiveAttributeView<String> strings();
	
	/** Access reference attributes
	 *  
	 * @return reference attribute view
	 */
	IFoggyRefAttributeView refs();
	
	/** Access integer list attributes
	 *  
	 * @return integer list attribute view
	 */
	IListAttributeView<Integer> intLists();
	
	/** Access float list attributes
	 *  
	 * @return float list attribute view
	 */
	IListAttributeView<Float> floatLists();
	
	/** Access boolean list attributes
	 *  
	 * @return boolean list attribute view
	 */
	IListAttributeView<Boolean> boolLists();
	
	/** Access string list attributes
	 *  
	 * @return string list attribute view
	 */
	IListAttributeView<String> stringLists();
	
	/** Access reference list attributes
	 *  
	 * @return reference list attribute view
	 */
	IFoggyRefListAttributeView refLists();
	
	/** Iterate over all accessible attributes
	 * 
	 * @return view iterator
	 */
	Iterator<ListMapEntryReplica<IAttributeReplica>> iterator();
}
