package cz.cuni.amis.pogamut.emohawk.agent.module.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IPerformerReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.MajorActionResult;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.action.ActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.action.PerformAction;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;

public class ActionUpstream {

	protected IAct act;
	protected IWorldView view;
	protected Game game;
	protected IOutputStream outputStream;
	protected LogCategory log;
	protected Map<Integer,HandlerRecord> resultHandlers;
	protected int nextUserRequestId;
	protected double timeoutPeriod; // seconds 
		
	public ActionUpstream( IAct act, IWorldView view, Game game, IOutputStream outputStream, LogCategory log ) {
		this.act = act;
		this.view = view;
		this.game = game;
		this.outputStream = outputStream;
		this.log = log;
		this.resultHandlers = new HashMap<Integer,HandlerRecord>();
		this.nextUserRequestId = 1;
		this.timeoutPeriod = 30.0;
		view.addEventListener( ActionResult.class, onInteractionError );
	}
	
	void setTimeoutPeriod( float value ) {
		this.timeoutPeriod = value;
	}
	
	/** Request action
	 * 
	 * @param performer action performer
	 * @param action action to perform
	 * @param resultHandler result handler, can be null
	 * @param serializedCustomArguments serialized custom arguments, can be null
	 */
	public void requestAction( IPerformerReplica performer, IActionReplica action, IActionResultHandler resultHandler, IInputStream serializedCustomArguments ) {
		cleanHandlers();
		
		int requestId = generateRequestId();
		
		if ( resultHandler!=null ) {
			resultHandlers.put( requestId, new HandlerRecord( game.getTime()+timeoutPeriod, resultHandler ) );
		}
		
		if ( serializedCustomArguments != null ) {
			while ( serializedCustomArguments.tellNext() != PayloadType.PAYLOAD_TYPE_EOF ) {
				switch ( serializedCustomArguments.tellNext() ) {
				case PAYLOAD_TYPE_BOOL:
					outputStream.writeBool( serializedCustomArguments.readBool() );
					break;
				case PAYLOAD_TYPE_INT:
					outputStream.writeInt( serializedCustomArguments.readInt() );
					break;
				case PAYLOAD_TYPE_FLOAT:
					outputStream.writeFloat( serializedCustomArguments.readFloat() );
					break;
				case PAYLOAD_TYPE_STRING:
					outputStream.writeString( serializedCustomArguments.readString() );
					break;
				default:
					throw new AssertionError( "Unexpected payload type." );
				}
			}
		}
		
		act.act(
			new PerformAction(
				performer.getReplicationId(),
				action.getReplicationId(), 
				requestId
			)
		);
	}
	
	protected void cleanHandlers() {
		Iterator<HandlerRecord> iterator = resultHandlers.values().iterator();
		while ( iterator.hasNext() ) {
			HandlerRecord record = iterator.next();
			if ( record.timeoutTime < game.getTime() )
			{
				if ( log != null ) {
					log.warning( "Action result handler timed out." );
				}
				iterator.remove();
			}
		}
	}
	
	protected IWorldEventListener<ActionResult> onInteractionError = new IWorldEventListener<ActionResult>() {
		@Override
		public void notify(ActionResult event) {
			cleanHandlers();
			
			HandlerRecord handlerRecord = resultHandlers.get( event.getUserRequestId() );
			if ( handlerRecord != null ) {
				handlerRecord.handler.handle( event.getMajor(), event.getMinor(), event.getMessage() );
				
				if ( 
					event.getMajor() == MajorActionResult.IR_SUCCESS 
					||
					event.getMajor() == MajorActionResult.IR_FAILURE
				) {
					resultHandlers.remove( event.getUserRequestId() );
				} else {
					handlerRecord.timeoutTime = game.getTime()+timeoutPeriod;
				}
			}
		}
	};
	
	protected int generateRequestId() {
		return nextUserRequestId++;
	}
	
	static class HandlerRecord
	{
		public double timeoutTime;
		public IActionResultHandler handler;
		
		public HandlerRecord( double timeoutTime, IActionResultHandler handler ) {
			this.timeoutTime = timeoutTime;
			this.handler = handler;
		}
	}
}
