package cz.cuni.amis.pogamut.emohawk.communication.replication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;

/** Object has been updated
 * 
 * Value is transmited by primitive data stream prior to this event.
 * @author Paletz
 */
public class ObjectUpdate extends InfoMessage implements IWorldEvent, IWorldChangeEvent {

	protected long simTime;
	protected int replicationIndex;
	
	public ObjectUpdate() {
		simTime = 0;
	}	
	
	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime()
	{
		return simTime;
	}

	/** Get the replication index
	 * 
	 * @return the replication index	 
	 */
	public int getReplicationIndex() {
		return replicationIndex;
	}
	
	/** Initialization from yylex
	 */
	protected void setSimTime( long value ) {
		simTime = value;
	}
	
	/** Initialization from yylex
	 */
	public void setReplicationIndex(int replicationIndex) {
		this.replicationIndex = replicationIndex;
	}
}
