package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import java.util.LinkedList;

import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;

/** Stream buffer
 * 
 * Implements input and output stream. Data sent to input is buffered and available on output FIFO.
 * 
 * @author Paletz
 */
public class StreamBuffer implements IInputStream, IOutputStream {

	protected LinkedList<Object> data;
	
	public StreamBuffer() {
		data = new LinkedList<Object>();
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream#writeInt(int)
	 */
	@Override
	public void writeInt(int value) {
		data.add( new Integer(value) );
	}

	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream#writeFloat(float)
	 */
	@Override
	public void writeFloat(float value) {
		data.add( new Float(value) );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream#writeBool(boolean)
	 */
	@Override
	public void writeBool(boolean value) {
		data.add( new Boolean(value) );
	}

	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream#writeString(java.lang.String)
	 */
	@Override
	public void writeString(String value) {
		data.add( value );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream#tellNext()
	 */
	@Override
	public PayloadType tellNext() {
		if ( data.isEmpty() ) {
			return PayloadType.PAYLOAD_TYPE_EOF;
		} else {
			return tellType( data.iterator().next() );
		}
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream#readInt()
	 */
	@Override
	public int readInt() {
		return (Integer) data.pop();
	}

	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream#readFloat()
	 */
	@Override
	public float readFloat() {
		return (Float) data.pop();
	}

	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream#readBool()
	 */
	@Override
	public boolean readBool() {
		return (Boolean) data.pop();
	}

	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream#readString()
	 */
	@Override
	public String readString() {
		return (String) data.pop();
	}
	
	/** Clear any buffered data
	 */
	public void clear() {
		data.clear();
	}
	
	protected PayloadType tellType( Object payload ) {
		if ( payload instanceof Integer ) {
			return PayloadType.PAYLOAD_TYPE_INT;
		} else if ( payload instanceof Float ) {
			return PayloadType.PAYLOAD_TYPE_FLOAT;
		} else if ( payload instanceof Boolean ) {
			return PayloadType.PAYLOAD_TYPE_BOOL;
		} else if ( payload instanceof String ) {
			return PayloadType.PAYLOAD_TYPE_STRING;
		} else {
			throw new AssertionError( "Unexpected value." );
		}
	}
}
