/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.agentmanager;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.params.impl.AgentParameters;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agentmanager.exception.CantInstantiateAgentException;
import cz.cuni.amis.pogamut.defcon.agentmanager.exception.ModuleForAgentClassNotFoundException;
import cz.cuni.amis.pogamut.defcon.factory.DefConAgentModule;

public class DefConAgentManager {
    private static final DefConAgentManager instance = new DefConAgentManager();

    public static DefConAgentManager getInstance() {
        return instance;
    }

    private DefConAgentManager() {
    }

    public <T extends DefConAgent<?>> T getAgentInstance(Class<? extends DefConAgentModule> cls) throws CantInstantiateAgentException, ModuleForAgentClassNotFoundException {
        DefConAgentModule module;
        try {
            module = cls.newInstance();
        }
        catch (InstantiationException e1) {
            throw new CantInstantiateAgentException(e1.getMessage(), this);
        }
        catch (IllegalAccessException e1) {
            throw new ModuleForAgentClassNotFoundException(e1.getMessage(), this);
        }
        try {
            AgentParameters params = new AgentParameters();
            IAgentId id = params.setAgentId((IAgentId)new AgentId("DefConBot")).getAgentId();
            module.newBindings(id);
            GuiceAgentFactory factory = new GuiceAgentFactory((GuiceAgentModule)module);
            return (T)((DefConAgent)factory.newAgent((IAgentParameters)params));
        }
        catch (Exception e) {
            throw new CantInstantiateAgentException("Instantiation of " + cls.getName() + " agent failed.", e, this);
        }
    }

    public DefConAgent getAgentInstance(String className) throws CantInstantiateAgentException, ModuleForAgentClassNotFoundException {
        Class<?> cls;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + className + " not found.");
        }
        if (!DefConAgent.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(className + " is not subclass od AbstractDefConAgent");
        }
        return this.getAgentInstance(cls);
    }
}

