/*
 * Decompiled with CFR 0.152.
 */
package javabot;

import java.util.LinkedList;
import java.util.List;
import javabot.PogamutJBotSupport;

public class JBot {
    private static String[][] commandLineOptions;
    public static final int STATE_AIRBASEFIGHTERLAUNCH = 0;
    public static final int STATE_AIRBASEBOMBERLAUNCH = 1;
    public static final int STATE_BATTLESHIPATTACK = 0;
    public static final int STATE_BOMBERATTACK = 0;
    public static final int STATE_BOMBERNUKE = 1;
    public static final int STATE_BOMBERINQUEUE = 2;
    public static final int STATE_CARRIERFIGHTERLAUNCH = 0;
    public static final int STATE_CARRIERBOMBERLAUNCH = 1;
    public static final int STATE_CARRIERANTISUB = 2;
    public static final int STATE_FIGHTERATTACK = 0;
    public static final int STATE_FIGHTERINQUEUE = 2;
    public static final int STATE_NUKEONTARGET = 0;
    public static final int STATE_NUKEDISARM = 1;
    public static final int STATE_RADARACTIVE = 0;
    public static final int STATE_SILONUKE = 0;
    public static final int STATE_SILOAIRDEFENSE = 1;
    public static final int STATE_SUBPASSIVESONAR = 0;
    public static final int STATE_SUBACTIVESONAR = 1;
    public static final int STATE_SUBNUKE = 2;
    public static final int CHATCHANNEL_PUBLIC = 100;
    public static final int CHATCHANNEL_ALLIANCE = 101;
    public static final int CHATCHANNEL_SPECTATORS = 102;
    public static final int TerritoryNorthAmerica = 0;
    public static final int TerritorySouthAmerica = 1;
    public static final int TerritoryEurope = 2;
    public static final int TerritoryRussia = 3;
    public static final int TerritorySouthAsia = 4;
    public static final int TerritoryAfrica = 5;
    public static final int NumTerritories = 6;
    public static final int EventPingSub = 0;
    public static final int EventPingCarrier = 1;
    public static final int EventNukeLaunchSilo = 2;
    public static final int EventNukeLaunchSub = 3;
    public static final int EventHit = 4;
    public static final int EventDestroyed = 5;
    public static final int EventPingDetection = 6;
    public static final int EventCeasedFire = 7;
    public static final int EventUnceasedFire = 8;
    public static final int EventSharedRadar = 9;
    public static final int EventUnsharedRadar = 10;
    public static final int EventNewVote = 11;
    public static final int EventTeamVoted = 12;
    public static final int EventTeamRetractedVote = 13;
    public static final int EventVoteFinishedYes = 14;
    public static final int EventVoteFinishedNo = 15;
    public static final int TypeInvalid = 0;
    public static final int TypeCity = 1;
    public static final int TypeSilo = 2;
    public static final int TypeRadarStation = 3;
    public static final int TypeNuke = 4;
    public static final int TypeExplosion = 5;
    public static final int TypeSub = 6;
    public static final int TypeBattleShip = 7;
    public static final int TypeAirBase = 8;
    public static final int TypeFighter = 9;
    public static final int TypeBomber = 10;
    public static final int TypeCarrier = 11;
    public static final int TypeTornado = 12;
    public static final int TypeSaucer = 13;
    public static final int TypeFleet = 14;
    public static final int TypeGunshot = 15;
    public static final int TypeQueueItem = 16;
    public static final int NumObjectTypes = 17;
    public static final int VoteTypeInvalid = 0;
    public static final int VoteTypeJoinAlliance = 1;
    public static final int VoteTypeKickPlayer = 2;
    public static final int VoteTypeLeaveAlliance = 3;
    public static final int VoteUnknown = 0;
    public static final int VoteYes = 1;
    public static final int VoteNo = 2;
    public static final int VoteAbstain = 3;

    public static native int GetDefcon();

    public static native float GetGameTime();

    public static native int GetGameTick();

    public static native int GetGameSpeed();

    public static native float GetVictoryTimer();

    public static native boolean IsVictoryTimerActive();

    public static native int GetOptionValue(String var0);

    public static native int[] GetCityIds();

    public static native int GetCityPopulation(int var0);

    public static native int GetRemainingPopulation(int var0);

    public static native boolean IsValidTerritory(int var0, float var1, float var2, boolean var3);

    public static native boolean IsBorder(float var0, float var1);

    public static native int GetTerritoryId(float var0, float var1);

    public static native int GetOwnTeamId();

    public static native int[] GetTeamIds();

    public static native int GetTeamTerritoriesCount(int var0);

    public static native int[] GetTeamTerritories(int var0);

    public static native int GetAllianceId(int var0);

    public static native int GetDesiredGameSpeed(int var0);

    public static native int GetEnemyKills(int var0);

    public static native int GetFriendlyDeaths(int var0);

    public static native int GetCollateralDamage(int var0);

    public static native String GetTeamName(int var0);

    public static native boolean IsSharingRadar(int var0, int var1);

    public static native boolean IsCeaseFire(int var0, int var1);

    public static native void RequestAlliance(int var0);

    public static native void RequestCeaseFire(int var0);

    public static native void RequestShareRadar(int var0);

    public static native void RequestGameSpeed(int var0);

    public static native int[] GetAllUnits();

    public static native int[] GetOwnUnits();

    public static native int[] GetTeamUnits(int var0);

    private static native float[] _GetAllUnitData();

    public static native int GetType(int var0);

    public static native int GetTeamId(int var0);

    public static native int[] GetOwnFleets();

    public static native int[] GetFleets(int var0);

    public static native int[] GetFleetMembers(int var0);

    public static native int GetFleetId(int var0);

    public static native int GetCurrentState(int var0);

    public static native int GetStateCount(int var0, int var1);

    public static native float GetStateTimer(int var0);

    public static native int[] GetActionQueue(int var0);

    public static native int GetCurrentTargetId(int var0);

    public static native float[] GetMovementTargetLocation(int var0);

    public static native int GetNukeSupply(int var0);

    public static native float[] GetBomberNukeTarget(int var0);

    public static native boolean IsRetaliating(int var0);

    public static native boolean IsVisible(int var0, int var1);

    public static native void SetState(int var0, int var1);

    public static native void SetMovementTarget(int var0, float var1, float var2);

    public static native void SetActionTarget(int var0, int var1, float var2, float var3);

    public static native void SetLandingTarget(int var0, int var1);

    public static native float GetLongitude(int var0);

    public static native float GetLatitude(int var0);

    public static native float[] GetVelocity(int var0);

    public static native float GetRange(int var0);

    public static native int GetRemainingUnits(int var0);

    public static native boolean IsValidPlacementLocation(float var0, float var1, int var2);

    public static native float[] GetFleetMemberOffset(int var0, int var1);

    public static native void PlaceStructure(int var0, float var1, float var2);

    public static native void PlaceFleet(float var0, float var1, int[] var2);

    public static native int GetUnitCredits();

    public static native int GetUnitValue(int var0);

    public static native void SendVote(int var0, int var1);

    public static native void SendChatMessage(String var0, int var1);

    public static native float GetDistance(float var0, float var1, float var2, float var3);

    public static native float GetSailDistance(float var0, float var1, float var2, float var3);

    public static native void DebugLog(String var0);

    public static native void DebugLog(String var0, int var1);

    public static native void DebugLog(String var0, int var1, String var2);

    public static native void DebugLog(String var0, int var1, String var2, int var3, int var4, int var5);

    public static native void DebugLog(String var0, int var1, String var2, int var3, int var4, int var5, int var6);

    public static native boolean DebugIsReplayingGame();

    public static native void WhiteboardDraw(float var0, float var1, float var2, float var3);

    public static native void WhiteboardClear();

    public static native int[] GetSuccessfulCommands();

    public static native void WriteToConsole(String var0);

    public static List<UnitData> GetAllUnitData() {
        float[] data = JBot._GetAllUnitData();
        LinkedList<UnitData> javaData = new LinkedList<UnitData>();
        int counter = 0;
        int limit = (int)Math.floor(data.length / 7);
        for (int i = 0; i < limit; ++i) {
            UnitData unit_data = new UnitData();
            unit_data.m_objectId = (int)data[counter++];
            unit_data.m_type = (int)data[counter++];
            unit_data.m_teamId = (int)data[counter++];
            unit_data.m_currentState = (int)data[counter++];
            unit_data.m_visible = Math.round(data[counter++]) != 0;
            unit_data.m_longitude = data[counter++];
            unit_data.m_latitude = data[counter++];
            javaData.add(unit_data);
        }
        return javaData;
    }

    public static List<FleetData> GetAllFleetData() {
        LinkedList<FleetData> javaData = new LinkedList<FleetData>();
        for (int teamId : JBot.GetTeamIds()) {
            int[] fleets;
            for (int fleetId : fleets = JBot.GetFleets(teamId)) {
                int[] fleetMembers = JBot.GetFleetMembers(fleetId);
                float[] fleetOffset = JBot.GetFleetMemberOffset(fleetMembers.length, 0);
                float fleetLongitude = JBot.GetLongitude(fleetMembers[0]) - fleetOffset[0];
                float fleetLatitude = JBot.GetLatitude(fleetMembers[0]) - fleetOffset[1];
                FleetData fleet_data = new FleetData(fleetId, teamId, true, fleetLongitude, fleetLatitude, fleetMembers);
                javaData.add(fleet_data);
            }
        }
        return javaData;
    }

    public static boolean update() {
        try {
            return PogamutJBotSupport.update();
        }
        catch (Exception e) {
            PogamutJBotSupport.logInitException(e);
            return false;
        }
    }

    public static boolean initialise(String[][] _commandLineOptions) {
        commandLineOptions = _commandLineOptions;
        Boolean returnvalue = false;
        try {
            returnvalue = PogamutJBotSupport.initialise(commandLineOptions);
        }
        catch (Exception e) {
            PogamutJBotSupport.writeToConsole("FAIL!!!");
            PogamutJBotSupport.writeToConsole(e.getMessage());
            PogamutJBotSupport.logInitException(e);
            return false;
        }
        JBot.WriteToConsole("Initialise finished");
        return returnvalue;
    }

    public static void addEvent(int _eventType, int _causeObjectId, int _targetObjectId, int _unitType, float _longitude, float _latitude) {
        try {
            EventData data = new EventData();
            data.m_eventType = _eventType;
            data.m_causeObjectId = _causeObjectId;
            data.m_targetObjectId = _targetObjectId;
            data.m_unitType = _unitType;
            data.m_longitude = _longitude;
            data.m_latitude = _latitude;
            PogamutJBotSupport.addEvent(data);
        }
        catch (Exception e) {
            PogamutJBotSupport.logInitException(e);
            return;
        }
    }

    public static class EventData {
        public int m_eventType;
        public int m_causeObjectId;
        public int m_targetObjectId;
        public int m_unitType;
        public float m_longitude;
        public float m_latitude;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("eventType: ");
            builder.append(this.m_eventType);
            builder.append("; causeObjectId: ");
            builder.append(this.m_causeObjectId);
            builder.append("; targetObjectId: ");
            builder.append(this.m_targetObjectId);
            builder.append("; unitType: ");
            builder.append(this.m_unitType);
            builder.append("; longitude: ");
            builder.append(this.m_longitude);
            builder.append("; latitude: ");
            builder.append(this.m_latitude);
            return builder.toString();
        }
    }

    public static class FleetData {
        public int m_fleetId;
        public int m_teamId;
        public boolean m_visible;
        public float m_longitude;
        public float m_latitude;
        public int[] m_fleetMembers;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("objectId: ");
            builder.append(this.m_fleetId);
            builder.append("; teamId: ");
            builder.append(this.m_teamId);
            builder.append("; visible: ");
            builder.append(this.m_visible);
            builder.append("; longitude: ");
            builder.append(this.m_longitude);
            builder.append("; latitude: ");
            builder.append(this.m_latitude);
            builder.append("; fleetMembers: ");
            builder.append(this.m_fleetMembers);
            return builder.toString();
        }

        public FleetData(int m_fleetId, int m_teamId, boolean m_visible, float m_longitude, float m_latitude, int[] m_fleetMembers) {
            this.m_fleetId = m_fleetId;
            this.m_teamId = m_teamId;
            this.m_visible = m_visible;
            this.m_longitude = m_longitude;
            this.m_latitude = m_latitude;
            this.m_fleetMembers = m_fleetMembers;
        }
    }

    public static class UnitData {
        public int m_objectId;
        public int m_type;
        public int m_teamId;
        public int m_currentState;
        public boolean m_visible;
        public float m_longitude;
        public float m_latitude;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("objectId: ");
            builder.append(this.m_objectId);
            builder.append("; type: ");
            builder.append(this.m_type);
            builder.append("; teamId: ");
            builder.append(this.m_teamId);
            builder.append("; currentState: ");
            builder.append(this.m_currentState);
            builder.append("; visible: ");
            builder.append(this.m_visible);
            builder.append("; longitude: ");
            builder.append(this.m_longitude);
            builder.append("; latitude: ");
            builder.append(this.m_latitude);
            return builder.toString();
        }
    }
}

