/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class QuadTreePostorderIterator
implements Iterator<QuadTreeNode> {
    private QuadTree tree;
    private QuadTreeNode node = null;
    private boolean finished = false;
    private QuadTreeNode root = null;
    private final LinkedList<Integer> branching = new LinkedList();

    public QuadTreePostorderIterator(QuadTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Tree cannot be null");
        }
        this.tree = tree;
        this.setRoot(tree.getRoot());
    }

    @Override
    public boolean hasNext() {
        if (this.isFinished()) {
            return false;
        }
        if (this.getNode() == null) {
            return this.getRoot() != null;
        }
        return true;
    }

    @Override
    public QuadTreeNode next() {
        if (this.getNode() == null) {
            if (this.isFinished() || this.getRoot() == null) {
                throw new NoSuchElementException("No more elements in iterated QuadTree");
            }
            this.setNode(this.getRoot());
            while (this.getNode().getNodes() != null) {
                this.setNode(this.getNode().getFirst());
                this.getBranching().add(0);
            }
            if (this.getNode() == this.getRoot()) {
                this.setFinished(true);
            }
            return this.getNode();
        }
        if (this.getNode() == this.getRoot()) {
            this.setFinished(true);
            return this.getRoot();
        }
        this.setNode(this.getNode().getParent());
        int next = this.getBranching().pollLast();
        if (next == 3) {
            if (this.getNode() == this.getRoot()) {
                this.setFinished(true);
            }
            return this.getNode();
        }
        this.getBranching().add(++next);
        this.setNode(this.getNode().getNodes()[next]);
        while (this.getNode().getNodes() != null) {
            this.setNode(this.getNode().getFirst());
            this.getBranching().add(0);
        }
        return this.getNode();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("QuadTreeIterator does not support remove() method.");
    }

    protected LinkedList<Integer> getBranching() {
        return this.branching;
    }

    protected void setNode(QuadTreeNode node) {
        this.node = node;
    }

    protected QuadTreeNode getNode() {
        return this.node;
    }

    protected void setRoot(QuadTreeNode root) {
        this.root = root;
    }

    protected QuadTreeNode getRoot() {
        return this.root;
    }

    protected void setFinished(boolean finished) {
        this.finished = finished;
    }

    protected boolean isFinished() {
        return this.finished;
    }
}

