/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreePostorderIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class QuadTree
implements Iterable<QuadTreeNode> {
    private QuadTreeNode root;

    public QuadTree(List<? extends Location> vertices) {
        double min_x = Double.MAX_VALUE;
        double max_x = -min_x;
        double min_y = Double.MAX_VALUE;
        double max_y = -min_y;
        for (Location location : vertices) {
            if (location.getX() < min_x) {
                min_x = location.getX();
            }
            if (location.getX() > max_x) {
                max_x = location.getX();
            }
            if (location.getY() < min_y) {
                min_y = location.getY();
            }
            if (!(location.getY() > max_y)) continue;
            max_y = location.getY();
        }
        double diffx = (max_x += 1.0) - (min_x -= 1.0);
        double diffy = (max_y += 1.0) - (min_y -= 1.0);
        if (diffx > diffy) {
            max_y = min_y + diffx;
        } else {
            max_x = min_x + diffy;
        }
        LinkedList<List<Location>> vrts = new LinkedList<List<Location>>();
        vrts.add(vertices);
        this.root = new QuadTreeNode(this, min_x, min_y, max_x, max_y, null, vrts);
    }

    public final QuadTreeNode getRoot() {
        return this.root;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("QuadTree: [\n%s\n]", this.root.toString()));
        return builder.toString();
    }

    @Override
    public Iterator<QuadTreeNode> iterator() {
        return new QuadTreePostorderIterator(this);
    }
}

