/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.Tuple2;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PolygonUtils {
    private static double EPSILON = 0.001;

    public static LinkedList<Location> resizePoly(List<Location> poly, double offset) {
        if (poly.size() < 3) {
            return null;
        }
        LinkedList<Location> resized = new LinkedList<Location>();
        Iterator<Location> iterator = poly.iterator();
        Location old = iterator.next();
        double length = 0.0;
        Location current = iterator.next();
        length = old.getDistance2D(current);
        Location tmp = current.sub(old);
        tmp = new Location(tmp.getX() + tmp.getY(), tmp.getY() - tmp.getX()).scale(offset / length);
        Location shifted_old1 = new Location(old.getX() + tmp.getY(), old.getX() - tmp.getX());
        Location shifted_current1 = new Location(current.getX() + tmp.getY(), current.getX() - tmp.getX());
        while (iterator.hasNext()) {
            current = iterator.next();
            length = old.getDistance2D(current);
            tmp = current.sub(old);
            Location dir2 = tmp.invert();
            tmp = new Location(tmp.getX() + tmp.getY(), tmp.getY() - tmp.getX()).scale(offset / length);
            Location shifted_old2 = new Location(old.getX() + tmp.getY(), old.getX() - tmp.getX());
            Location shifted_current2 = new Location(current.getX() + tmp.getY(), current.getX() - tmp.getX());
            Location diff = new Location(shifted_old1.getX() - shifted_current2.getX(), shifted_old1.getY() - shifted_current2.getY());
            Location dir1 = shifted_current1.sub(shifted_old1);
            Tuple2<Double, Location[]> result = PolygonUtils.partiallySolve2DGauss(dir1, dir2, diff);
            double param2 = (Double)result.getFirst();
            dir1 = ((Location[])result.getSecond())[0];
            dir2 = ((Location[])result.getSecond())[1];
            diff = ((Location[])result.getSecond())[2];
            resized.add(dir2.scale(param2));
            shifted_old1 = shifted_old2;
            shifted_current1 = shifted_current2;
        }
        System.gc();
        return resized;
    }

    private static Tuple2<Double, Location[]> partiallySolve2DGauss(Location a1, Location a2, Location b) {
        a2 = a2.setX(a2.x / a1.x);
        b = b.setX(b.x / a1.x);
        a1 = a1.setX(1.0);
        a2.setY(a2.y / a1.y - a2.x);
        b.setY(b.y / a1.y - b.x);
        a1.setY(0.0);
        double result = b.x / a2.y;
        return new Tuple2((Object)result, (Object)new Location[]{a1, a2, b});
    }

    public static LinkedList<Location> resizePoly2(LinkedList<Location> poly, double offset) {
        if (poly == null) {
            return null;
        }
        if (poly.size() == 0) {
            return new LinkedList<Location>();
        }
        if (poly.size() < 3) {
            LinkedList<Location> out = new LinkedList<Location>();
            for (Location loc : poly) {
                out.add(new Location(loc));
            }
            return out;
        }
        LinkedList polygons = new LinkedList();
        LinkedList<LinkedList<Location>> convexity_breaking = new LinkedList<LinkedList<Location>>();
        Iterator iter = poly.iterator();
        Location last = (Location)iter.next();
        Location middle = (Location)iter.next();
        Location current = null;
        LinkedList<Location> breakers = null;
        ReturnValueOfCheckDirection ret = null;
        while (iter.hasNext()) {
            current = (Location)iter.next();
            ret = PolygonUtils.checkDirection(last, middle, current, breakers, convexity_breaking);
            breakers = ret.breakers;
            last = middle;
            middle = current;
        }
        iter = poly.iterator();
        current = (Location)iter.next();
        ret = PolygonUtils.checkDirection(last, middle, current, breakers, convexity_breaking);
        if (ret.ret) {
            breakers = ret.breakers;
            while (iter.hasNext()) {
                current = (Location)iter.next();
                ret = PolygonUtils.checkDirection(last, middle, current, breakers, convexity_breaking);
                if (!ret.ret) {
                    breakers = ret.breakers;
                    break;
                }
                breakers = ret.breakers;
                last = middle;
                middle = current;
            }
        }
        return null;
    }

    private static ReturnValueOfCheckDirection checkDirection(Location last, Location middle, Location current, LinkedList<Location> breakers, LinkedList<LinkedList<Location>> convexity_breaking) {
        Location ax;
        Location diff_middle = middle.sub(last);
        Location diff_last = current.sub(last);
        if (diff_last.dot(ax = new Location(diff_middle.getY(), -diff_middle.getX())) < 0.0) {
            if (breakers == null) {
                breakers = new LinkedList();
                breakers.add(last);
            }
            breakers.add(middle);
            return new ReturnValueOfCheckDirection(breakers, true);
        }
        if (breakers != null) {
            breakers.add(middle);
            convexity_breaking.add(breakers);
            breakers = null;
        }
        return new ReturnValueOfCheckDirection(breakers, false);
    }

    public static LinkedList<Location> resizePoly3(LinkedList<Location> poly, double offset) {
        LinkedList<Location> out = new LinkedList<Location>();
        Location[] ret = PolygonUtils.resizePoly3((Location[])poly.toArray(), offset);
        for (int i = 0; i < ret.length; ++i) {
            out.add(ret[i]);
        }
        return out;
    }

    public static Location[] resizePoly3(Location[] poly, double offset) {
        int size = poly.length;
        if (size < 3) {
            return PolygonUtils.deepCopy(poly);
        }
        int[] indices = PolygonUtils.triangulate(poly);
        for (int i = 0; i < indices.length; ++i) {
        }
        Location[] out = new Location[size];
        for (int i = 0; i < size; ++i) {
            out[i] = poly[indices[i]];
        }
        return out;
    }

    private static int[] triangulate(Location[] vertices) {
        int v;
        int size = vertices.length;
        int[] V = new int[size];
        int[] indices = new int[size];
        int current_index = 0;
        if (0.0f < PolygonUtils.area(vertices)) {
            for (v = 0; v < size; ++v) {
                V[v] = v;
            }
        } else {
            for (v = 0; v < size; ++v) {
                V[v] = size - 1 - v;
            }
        }
        int nv = size;
        int count = 2 * nv;
        int m = 0;
        int v2 = nv - 1;
        while (nv > 2) {
            int w;
            if (0 >= count--) {
                return V;
            }
            int u = v2;
            if (nv <= u) {
                u = 0;
            }
            if (nv <= (v2 = u + 1)) {
                v2 = 0;
            }
            if (nv <= (w = v2 + 1)) {
                w = 0;
            }
            if (!PolygonUtils.snip(vertices, u, v2, w, nv, V)) continue;
            int a = V[u];
            int b = V[v2];
            int c = V[w];
            indices[current_index++] = a;
            indices[current_index++] = b;
            indices[current_index++] = c;
            ++m;
            int s = v2;
            for (int t = v2 + 1; t < nv; ++t) {
                V[s] = V[t];
                ++s;
            }
            count = 2 * --nv;
        }
        return indices;
    }

    private static boolean checkDirection2(Location last, Location middle, Location current) {
        Location ax;
        Location diff_middle = middle.sub(last);
        Location diff_last = current.sub(last);
        return diff_last.dot(ax = new Location(diff_middle.getY(), -diff_middle.getX())) < 0.0;
    }

    private static float area(Location[] poly) {
        if (poly.length < 3) {
            return 0.0f;
        }
        float A = 0.0f;
        int i = poly.length - 1;
        int j = 0;
        while (j < poly.length) {
            A = (float)((double)A + (poly[i].x * poly[j].y - poly[j].x * poly[i].y));
            i = j++;
        }
        return A * 0.5f;
    }

    private static Location[] deepCopy(Location[] toCopy) {
        Location[] out = new Location[toCopy.length];
        for (int i = 0; i < toCopy.length; ++i) {
            out[i] = new Location(toCopy[i]);
        }
        return out;
    }

    private static boolean snip(Location[] vertices, int u, int v, int w, int n, int[] V) {
        Location A = vertices[V[u]];
        Location B = vertices[V[v]];
        Location C = vertices[V[w]];
        if (EPSILON > (B.x - A.x) * (C.y - A.y) - (B.y - A.y) * (C.x - A.x)) {
            return false;
        }
        for (int p = 0; p < n; ++p) {
            Location P;
            if (p == u || p == v || p == w || !PolygonUtils.insideTriangle(A, B, C, P = vertices[V[p]])) continue;
            return false;
        }
        return true;
    }

    private static boolean insideTriangle(Location A, Location B, Location C, Location P) {
        double ax = C.x - B.x;
        double ay = C.y - B.y;
        double bx = A.x - C.x;
        double by = A.y - C.y;
        double cx = B.x - A.x;
        double cy = B.y - A.y;
        double apx = P.x - A.x;
        double apy = P.y - A.y;
        double bpx = P.x - B.x;
        double bpy = P.y - B.y;
        double cpx = P.x - C.x;
        double cpy = P.y - C.y;
        double aCROSSbp = ax * bpy - ay * bpx;
        double cCROSSap = cx * apy - cy * apx;
        double bCROSScp = bx * cpy - by * cpx;
        return aCROSSbp >= 0.0 && bCROSScp >= 0.0 && cCROSSap >= 0.0;
    }

    private class Triangle {
        Location a;
        Location b;
        Location c;

        public Triangle(Location a, Location b, Location c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    private static class ReturnValueOfCheckDirection {
        LinkedList<Location> breakers;
        boolean ret;

        public ReturnValueOfCheckDirection(LinkedList<Location> breakers, boolean ret) {
            this.breakers = breakers;
            this.ret = ret;
        }
    }

    private class Candidates {
        Location a;
        Location b;
        Location c;

        private Candidates() {
        }
    }

    private class PolygonWithBarycenter {
        LinkedList<Location> polygon = new LinkedList();
        Location barycenter;

        private PolygonWithBarycenter() {
        }
    }
}

