/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.consts;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.AirBase;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Battleship;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Bomber;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Carrier;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.City;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Explosion;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Fighter;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Fleet;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Gunshot;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.InvalidObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Nuke;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.QueueItem;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Radar;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Saucer;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Silo;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Sub;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Tornado;
import cz.cuni.amis.pogamut.defcon.consts.state.AirBaseState;
import cz.cuni.amis.pogamut.defcon.consts.state.BattleshipState;
import cz.cuni.amis.pogamut.defcon.consts.state.BomberState;
import cz.cuni.amis.pogamut.defcon.consts.state.CarrierState;
import cz.cuni.amis.pogamut.defcon.consts.state.FighterState;
import cz.cuni.amis.pogamut.defcon.consts.state.NukeState;
import cz.cuni.amis.pogamut.defcon.consts.state.RadarState;
import cz.cuni.amis.pogamut.defcon.consts.state.SiloState;
import cz.cuni.amis.pogamut.defcon.consts.state.SubState;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javabot.JBot;

public enum UnitType {
    INVALID(0),
    CITY(1),
    SILO(2),
    RADAR(3),
    NUKE(4),
    EXPLOSION(5),
    SUB(6),
    BATTLE_SHIP(7),
    AIR_BASE(8),
    FIGHTER(9),
    BOMBER(10),
    CARRIER(11),
    TORNADO(12),
    SAUCER(13),
    FLEET(14),
    GUNSHOT(15),
    QUEUE_ITEM(16),
    NUM_OBJECTS(18);

    private static Map<Integer, UnitType> enums;
    public final int id;
    public static final EnumSet<UnitType> units;
    public static final EnumSet<UnitType> air;
    public static final EnumSet<UnitType> naval;
    public static final EnumSet<UnitType> ground;
    public static final EnumSet<UnitType> misc;

    public static UnitType getEnum(int id) {
        return enums.get(id);
    }

    private UnitType(int id) {
        this.id = id;
    }

    public boolean isUnit() {
        return units.contains((Object)this);
    }

    public boolean isAir() {
        return air.contains((Object)this);
    }

    public boolean isGround() {
        return ground.contains((Object)this);
    }

    public boolean isNaval() {
        return naval.contains((Object)this);
    }

    public boolean isMisc() {
        return misc.contains((Object)this);
    }

    public static DefConObject getInstanceOfUnitTypeFromUnitData(JBot.UnitData data, double time) {
        try {
            switch (UnitType.getEnum(data.m_type)) {
                case CARRIER: {
                    return new Carrier(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, CarrierState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId), JBot.GetStateCount(data.m_objectId, CarrierState.FIGHTER_LAUNCH.getStateId()), JBot.GetStateCount(data.m_objectId, CarrierState.BOMBER_LAUNCH.getStateId()), time);
                }
                case NUKE: {
                    return new Nuke(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, NukeState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), time);
                }
                case BOMBER: {
                    return new Bomber(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, BomberState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), new DefConLocation(JBot.GetBomberNukeTarget(data.m_objectId)), time);
                }
                case EXPLOSION: {
                    return new Explosion(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);
                }
                case QUEUE_ITEM: {
                    return new QueueItem(data.m_objectId, time);
                }
                case FIGHTER: {
                    return new Fighter(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, FighterState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), time);
                }
                case SAUCER: {
                    return new Saucer(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);
                }
                case FLEET: {
                    return new Fleet(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, JBot.GetFleetMembers(data.m_objectId), time);
                }
                case BATTLE_SHIP: {
                    return new Battleship(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, BattleshipState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), time);
                }
                case CITY: {
                    return new City(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, JBot.GetCityPopulation(data.m_objectId), time);
                }
                case AIR_BASE: {
                    return new AirBase(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, AirBaseState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId), JBot.GetStateCount(data.m_objectId, AirBaseState.FIGHTER_LAUNCH.getStateId()), JBot.GetStateCount(data.m_objectId, AirBaseState.BOMBER_LAUNCH.getStateId()), time);
                }
                case TORNADO: {
                    return new Tornado(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);
                }
                case RADAR: {
                    return new Radar(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, RadarState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), time);
                }
                case SUB: {
                    return new Sub(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, SubState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId), time);
                }
                case GUNSHOT: {
                    return new Gunshot(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);
                }
                case SILO: {
                    return new Silo(data.m_objectId, data.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, SiloState.getState(data.m_currentState), JBot.GetStateCount(data.m_objectId, data.m_currentState), JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId), time);
                }
                case INVALID: {
                    return new InvalidObject(data.m_objectId, time);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Class<? extends DefConObject> getClassOfUnitType() {
        return UnitType.getClassOfUnitType(this);
    }

    public static Class<? extends DefConObject> getClassOfUnitType(UnitType data) {
        switch (data) {
            case CARRIER: {
                return Carrier.class;
            }
            case NUKE: {
                return Nuke.class;
            }
            case BOMBER: {
                return Bomber.class;
            }
            case EXPLOSION: {
                return Explosion.class;
            }
            case QUEUE_ITEM: {
                return QueueItem.class;
            }
            case FIGHTER: {
                return Fighter.class;
            }
            case SAUCER: {
                return Saucer.class;
            }
            case FLEET: {
                return Fleet.class;
            }
            case BATTLE_SHIP: {
                return Battleship.class;
            }
            case CITY: {
                return City.class;
            }
            case AIR_BASE: {
                return AirBase.class;
            }
            case TORNADO: {
                return Tornado.class;
            }
            case RADAR: {
                return Radar.class;
            }
            case SUB: {
                return Sub.class;
            }
            case GUNSHOT: {
                return Gunshot.class;
            }
            case SILO: {
                return Silo.class;
            }
            case INVALID: {
                return InvalidObject.class;
            }
        }
        return null;
    }

    static {
        enums = new HashMap<Integer, UnitType>();
        for (UnitType item : UnitType.values()) {
            enums.put(item.id, item);
        }
        units = EnumSet.of(SILO, new UnitType[]{RADAR, NUKE, SUB, BATTLE_SHIP, AIR_BASE, FIGHTER, BOMBER, CARRIER, FLEET});
        air = EnumSet.of(NUKE, FIGHTER, BOMBER);
        naval = EnumSet.of(SUB, BATTLE_SHIP, CARRIER, FLEET);
        ground = EnumSet.of(SILO, RADAR, AIR_BASE);
        misc = EnumSet.of(INVALID, new UnitType[]{CITY, EXPLOSION, TORNADO, SAUCER, GUNSHOT, QUEUE_ITEM, NUM_OBJECTS});
    }
}

