/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

public enum GameOption {
    SERVER_NAME("ServerName", 0, 24, 0),
    ADVERTISE_ON_INTERNET("AdvertiseOnInternet", 0, 1, 1),
    ADVERTISE_ON_LAN("AdvertiseOnLAN", 0, 1, 1),
    GAME_MODE("GameMode", 0, 6, 0),
    MAX_TEAMS("MaxTeams", 1, 6, 3),
    TERRITORIES_PER_TEAM("TerritoriesPerTeam", 1, 6, 1),
    CITIES_PER_TERRITORY("CitiesPerTerritory", 1, 50, 25),
    POPULATION_PER_TERRITORY("PopulationPerTerritory", 10, 200, 100),
    CITY_POPULATIONS("CityPopulations", 0, 3, 0),
    RANDOM_TERRITORIES("RandomTerritories", 0, 1, 0),
    PERMIT_DEFECTION("PermitDefection", 0, 1, 1),
    RADAR_SHARING("RadarSharing", 0, 3, 1),
    GAME_SPEED("GameSpeed", 0, 4, 0),
    SLOWEST_SPEED("SlowestSpeed", 0, 4, 1),
    SCORE_MODE("ScoreMode", 0, 2, 0),
    VICTORY_TRIGGER("VictoryTrigger", 0, 100, 20),
    VICTORY_TIMER("VictoryTimer", 0, 600, 45),
    VARIABLE_UNIT_COUNT("VariableUnitCount", 0, 1, 0),
    WORLD_SCALE("WorldScale", 50, 200, 100),
    MAX_SPECTATORS("MaxSpectators", 0, 100, 3),
    SPECTATOR_CHAT_CHANNEL("SpectatorChatChannel", 0, 1, 1),
    TEAM_SWITCHING("TeamSwitching", 0, 1, 0),
    SERVER_PASSWORD("ServerPasswords", 0, 16, 0);

    private static Map<String, GameOption> enums;
    public final String name;
    public final int min;
    public final int max;
    public final int def;

    public static GameOption getEnum(String option) {
        return enums.get(option);
    }

    private GameOption(String name, int min, int max, int def) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.def = def;
    }

    public String getName() {
        return this.name;
    }

    static {
        enums = new HashMap<String, GameOption>();
        for (GameOption item : GameOption.values()) {
            enums.put(item.name, item);
        }
    }
}

