/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders.IPrecomputedBordersLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilePrecomputedBordersLoader
implements IPrecomputedBordersLoader {
    private String pathString;
    private File path;
    private Pattern pattern = Pattern.compile("[-0-9\\.]+");
    private Logger log;

    public FilePrecomputedBordersLoader(String pathString) {
        this(pathString, null);
    }

    public FilePrecomputedBordersLoader(String pathString, Logger log) {
        this.pathString = pathString;
        this.path = new File(pathString);
        this.log = log;
        if (!this.path.isDirectory()) {
            throw new IllegalArgumentException("FilePrecomputedBordersSaver: pathString has to point to a directory");
        }
    }

    @Override
    public List<List<DefConLocation>> loadBordersForTerritory(String fileName) throws NumberFormatException, IOException {
        String line;
        if (this.log != null) {
            this.log.info("path: " + this.path.getAbsolutePath() + "\\" + fileName);
        }
        BufferedReader input = new BufferedReader(new FileReader(new File(this.path, fileName)));
        ArrayList<List<DefConLocation>> territory = new ArrayList<List<DefConLocation>>();
        double[] singleLocation = new double[3];
        while ((line = input.readLine()) != null) {
            Matcher match = this.pattern.matcher(line);
            LinkedList<DefConLocation> border = new LinkedList<DefConLocation>();
            int i = 0;
            while (match.find()) {
                String member = match.group();
                singleLocation[i] = Double.parseDouble(member);
                if ((i = (i + 1) % 3) != 0) continue;
                border.add(new DefConLocation(singleLocation));
                singleLocation = new double[3];
            }
            territory.add(border);
        }
        return territory;
    }

    public String getPathString() {
        return this.pathString;
    }
}

