/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.agent.impl.ILogicUpdateListener;
import cz.cuni.amis.pogamut.defcon.ai.buildingai.IBuildingAI;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.PlaceStructure;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.AirBase;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Radar;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Silo;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class BuildingsManager {
    protected final ArrayList<BuildingWithAI<?>> ownBuildings = new ArrayList();
    protected final SortedMap<Integer, List<DefConUnitObject<?>>> enemyBuildings = new TreeMap();
    protected final LinkedList<PlaceStructure> placementQueue = new LinkedList();
    protected int placementsCounter = 0;
    protected static final int PLACEMENT_PER_TICK = 2;
    protected static final long PLACEMENT_TIMEOUT = 1000L;
    protected long lastPlacement;
    protected final ILogicUpdateListener logicListener = new ILogicUpdateListener(){

        @Override
        public void update() {
            if (!BuildingsManager.this.placementQueue.isEmpty()) {
                for (int counter = 0; counter <= 2; ++counter) {
                    PlaceStructure placement = BuildingsManager.this.placementQueue.pollFirst();
                    BuildingsManager.this.act(placement);
                    if (!BuildingsManager.this.placementQueue.isEmpty()) continue;
                }
            }
            if (BuildingsManager.this.placementsCounter != BuildingsManager.this.ownBuildings.size() && System.currentTimeMillis() - BuildingsManager.this.lastPlacement > 1000L) {
                BuildingsManager.this.placementsCounter = BuildingsManager.this.ownBuildings.size();
            }
            for (BuildingWithAI<?> building : BuildingsManager.this.ownBuildings) {
                IBuildingAI ai = building.getAI();
                if (ai == null || ((DefConObject)building.getBuilding()).getDestroyed()) continue;
                ai.update();
            }
        }
    };
    protected DefConAgentLogicController<?> logic;
    protected IWorldObjectListener<DefConUnitObject<?>> buildingListener = new IWorldObjectListener<DefConUnitObject<?>>(){

        public void notify(IWorldObjectEvent<DefConUnitObject<?>> event) {
            if (event instanceof WorldObjectFirstEncounteredEvent) {
                BuildingsManager.this.addBuilding((DefConUnitObject)event.getObject());
            }
            if (event instanceof WorldObjectDestroyedEvent) {
                BuildingsManager.this.removeBuilding((DefConUnitObject)event.getObject());
            }
        }
    };

    public BuildingsManager(DefConAgentLogicController<?> logic) {
        this.logic = logic;
        for (int teamId : logic.getGameInfo().getEnemyTeamIds()) {
            this.enemyBuildings.put(teamId, new ArrayList());
        }
        logic.getWorldView().addObjectListener(AirBase.class, (IWorldObjectEventListener)this.buildingListener);
        logic.getWorldView().addObjectListener(Silo.class, (IWorldObjectEventListener)this.buildingListener);
        logic.getWorldView().addObjectListener(Radar.class, (IWorldObjectEventListener)this.buildingListener);
        logic.addGameLogicListener(this.logicListener);
    }

    protected void addBuilding(DefConUnitObject<?> building) {
        if (building.getTeamId() == this.logic.getGameInfo().getOwnTeamId()) {
            this.addOwnBuilding(building);
        } else {
            this.addEnemyBuilding(building);
        }
    }

    protected void removeBuilding(DefConUnitObject<?> building) {
        if (building.getTeamId() == this.logic.getGameInfo().getOwnTeamId()) {
            this.removeOwnBuilding(building);
        } else {
            this.removeEnemyBuilding(building);
        }
    }

    protected void addOwnBuilding(DefConUnitObject<?> building) {
        if (!this.ownBuildings.contains(building)) {
            this.ownBuildings.add(new BuildingWithAI(this, building, null));
            this.lastPlacement = System.currentTimeMillis();
        }
    }

    protected void removeOwnBuilding(DefConUnitObject<?> building) {
        Iterator<BuildingWithAI<?>> ownBuildingsIterator = this.ownBuildings.iterator();
        while (ownBuildingsIterator.hasNext()) {
            BuildingWithAI<?> ownBuilding = ownBuildingsIterator.next();
            if (ownBuilding.building != building) continue;
            ownBuildingsIterator.remove();
            if (ownBuilding.getAI() == null) continue;
            ownBuilding.getAI().dispose();
            ownBuilding.setAI(null);
            return;
        }
    }

    protected void addEnemyBuilding(DefConUnitObject<?> building) {
        int enemyId = building.getTeamId();
        List singleEnemyBuildings = (List)this.enemyBuildings.get(enemyId);
        if (!singleEnemyBuildings.contains(building)) {
            singleEnemyBuildings.add(building);
        }
    }

    protected void removeEnemyBuilding(DefConUnitObject<?> building) {
        int enemyId = building.getTeamId();
        List singleEnemyBuildings = (List)this.enemyBuildings.get(enemyId);
        if (singleEnemyBuildings.contains(building)) {
            singleEnemyBuildings.remove(building);
        }
    }

    public List<BuildingWithAI<?>> getOwnBuildings() {
        return Collections.unmodifiableList(this.ownBuildings);
    }

    public SortedMap<Integer, List<DefConUnitObject<?>>> getEnemyBuildings() {
        return Collections.unmodifiableSortedMap(this.enemyBuildings);
    }

    public List<DefConUnitObject<?>> getSingleEnemyBuildings(int enemyId) {
        return Collections.unmodifiableList((List)this.enemyBuildings.get(enemyId));
    }

    public static boolean isBuilding(DefConUnitObject<?> unitObject) {
        return unitObject instanceof AirBase || unitObject instanceof Radar || unitObject instanceof Silo;
    }

    public static boolean isBuilding(UnitType type) {
        return type == UnitType.AIR_BASE || type == UnitType.RADAR || type == UnitType.SILO;
    }

    public void placeBuildings(List<DefConLocation> locations, UnitType type) {
        if (!BuildingsManager.isBuilding(type)) {
            return;
        }
        for (DefConLocation location : locations) {
            this.placementQueue.add(new PlaceStructure(type.id, location));
        }
    }

    public boolean assignAI(DefConUnitObject<?> building, IBuildingAI ai) {
        for (BuildingWithAI<?> buildingWithAI : this.ownBuildings) {
            if (!buildingWithAI.equals(building)) continue;
            buildingWithAI.setAI(ai);
            return true;
        }
        return false;
    }

    protected void act(DefConCommand command) {
        ++this.placementsCounter;
        this.lastPlacement = System.currentTimeMillis();
        this.logic.act(command);
    }

    public boolean isFinished() {
        return this.placementQueue.isEmpty() && this.placementsCounter == this.ownBuildings.size();
    }

    public static class BuildingWithAI<T extends DefConUnitObject<?>> {
        T building;
        IBuildingAI ai;
        final /* synthetic */ BuildingsManager this$0;

        public BuildingWithAI(T building, IBuildingAI ai) {
            this.this$0 = var1_1;
            this.building = building;
            this.ai = ai;
        }

        public final IBuildingAI getAI() {
            return this.ai;
        }

        public final void setAI(IBuildingAI ai) {
            this.ai = ai;
        }

        public final T getBuilding() {
            return this.building;
        }
    }
}

