/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGridIterator;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.BasicGrid;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.SymmetricGridCell;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.SymmetricGridCellId;
import java.util.LinkedList;
import java.util.List;

public class BasicGridIterator
implements IGridIterator<SymmetricGridCell, SymmetricGridCellId> {
    private Location cellLocation;
    private BasicGrid.CellIndices indices;
    private BasicGrid grid;
    private SymmetricGridCell cell;

    public BasicGridIterator(SymmetricGridCellId cellId, BasicGrid grid) {
        this.grid = grid;
        this.cell = grid.getCell(cellId);
        this.cellLocation = cellId.getLocation();
        this.indices = grid.getCellIndices(cellId);
    }

    @Override
    public SymmetricGridCell getCell() {
        return this.cell;
    }

    @Override
    public SymmetricGridCell getBottomNeighbourCell() {
        return this.grid.getCell(this.indices.getX(), this.indices.getY() + this.grid.getGridStep());
    }

    @Override
    public SymmetricGridCell getLeftNeighbourCell() {
        return this.grid.getCell(this.indices.getX() - this.grid.getGridStep(), this.indices.getY());
    }

    @Override
    public SymmetricGridCell getRightNeighbourCell() {
        return this.grid.getCell(this.indices.getX() + this.grid.getGridStep(), this.indices.getY());
    }

    @Override
    public SymmetricGridCell getTopNeighbourCell() {
        return this.grid.getCell(this.indices.getX(), this.indices.getY() - this.grid.getGridStep());
    }

    @Override
    public SymmetricGridCell getBottomLeftNeighbourCell() {
        return this.grid.getCell(this.indices.getX() - this.grid.getGridStep(), this.indices.getY() + this.grid.getGridStep());
    }

    @Override
    public SymmetricGridCell getBottomRightNeighbourCell() {
        return this.grid.getCell(this.indices.getX() + this.grid.getGridStep(), this.indices.getY() + this.grid.getGridStep());
    }

    @Override
    public SymmetricGridCell getTopLeftNeighbourCell() {
        return this.grid.getCell(this.indices.getX() - this.grid.getGridStep(), this.indices.getY() - this.grid.getGridStep());
    }

    @Override
    public SymmetricGridCell getTopRightNeighbourCell() {
        return this.grid.getCell(this.indices.getX() + this.grid.getGridStep(), this.indices.getY() - this.grid.getGridStep());
    }

    @Override
    public List<SymmetricGridCell> getListOfNeighbouringCells() {
        LinkedList<SymmetricGridCell> cells = new LinkedList<SymmetricGridCell>();
        cells.add(this.getBottomNeighbourCell());
        cells.add(this.getLeftNeighbourCell());
        cells.add(this.getRightNeighbourCell());
        cells.add(this.getTopNeighbourCell());
        cells.add(this.getBottomLeftNeighbourCell());
        cells.add(this.getBottomRightNeighbourCell());
        cells.add(this.getTopLeftNeighbourCell());
        cells.add(this.getTopRightNeighbourCell());
        return cells;
    }

    @Override
    public SymmetricGridCell getNeighbourCellInDirection(Location direction) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        Location tested_direction = new Location(1.0, 0.0);
        double maximal_dot = direction.dot(tested_direction);
        Direction dir = Direction.RIGHT;
        tested_direction = tested_direction.setY(1.0);
        double current_dot = direction.dot(tested_direction);
        if (d6 > maximal_dot) {
            dir = Direction.BOTTOM_RIGHT;
            maximal_dot = current_dot;
        }
        tested_direction = tested_direction.setX(0.0);
        current_dot = direction.dot(tested_direction);
        if (d5 > maximal_dot) {
            dir = Direction.BOTTOM;
            maximal_dot = current_dot;
        }
        tested_direction = tested_direction.setX(-1.0);
        current_dot = direction.dot(tested_direction);
        if (d4 > maximal_dot) {
            dir = Direction.BOTTOM_LEFT;
            maximal_dot = current_dot;
        }
        tested_direction = tested_direction.setY(0.0);
        current_dot = direction.dot(tested_direction);
        if (d3 > maximal_dot) {
            dir = Direction.BOTTOM_RIGHT;
            maximal_dot = current_dot;
        }
        tested_direction = tested_direction.setY(-1.0);
        current_dot = direction.dot(tested_direction);
        if (d2 > maximal_dot) {
            dir = Direction.LEFT;
            maximal_dot = current_dot;
        }
        tested_direction = tested_direction.setX(0.0);
        current_dot = direction.dot(tested_direction);
        if (d > maximal_dot) {
            dir = Direction.TOP;
            maximal_dot = current_dot;
        }
        switch (dir) {
            case TOP: {
                return this.getTopNeighbourCell();
            }
            case TOP_RIGHT: {
                return this.getTopRightNeighbourCell();
            }
            case RIGHT: {
                return this.getRightNeighbourCell();
            }
            case BOTTOM_RIGHT: {
                return this.getBottomRightNeighbourCell();
            }
            case BOTTOM: {
                return this.getBottomNeighbourCell();
            }
            case BOTTOM_LEFT: {
                return this.getBottomLeftNeighbourCell();
            }
            case LEFT: {
                return this.getLeftNeighbourCell();
            }
            case TOP_LEFT: {
                return this.getTopLeftNeighbourCell();
            }
        }
        return null;
    }

    @Override
    public LinkedList<SymmetricGridCellId> getCellsInRadiusOf(float radius) {
        LinkedList<SymmetricGridCellId> list = new LinkedList<SymmetricGridCellId>();
        int normed_radius = (int)Math.floor(radius / this.grid.getGridStep());
        int y_base = (int)this.cellLocation.getY();
        double y = this.cellLocation.getY();
        for (double x = this.cellLocation.getX() - (double)normed_radius; x <= (double)((int)(this.cellLocation.getX() + (double)normed_radius)); x += 1.0) {
            y = y_base;
            while (true) {
                Location location = new Location(x, y);
                if (!(location.sub(this.cellLocation).getLength() < (double)radius)) break;
                y += 1.0;
            }
            int y_diff = (int)(y - (double)y_base - (double)this.grid.getGridStep());
            for (y = (double)(y_base - y_diff); y <= (double)(y_base + y_diff); y += 1.0) {
                list.add(new SymmetricGridCellId(new Location(x, y)));
            }
        }
        return list;
    }

    @Override
    public SymmetricGridCell moveToBottomLeftNeighbourCell() {
        this.cell = this.getBottomLeftNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToBottomNeighbourCell() {
        this.cell = this.getBottomNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToBottomRightNeighbourCell() {
        this.cell = this.getBottomRightNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToLeftNeighbourCell() {
        this.cell = this.getLeftNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToNeighbourCellInDirection(Location direction) {
        this.cell = this.moveToNeighbourCellInDirection(direction);
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToRightNeighbourCell() {
        this.cell = this.getRightNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToTopLeftNeighbourCell() {
        this.cell = this.getTopLeftNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToTopNeighbourCell() {
        this.cell = this.getTopNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    @Override
    public SymmetricGridCell moveToTopRightNeighbourCell() {
        this.cell = this.getTopRightNeighbourCell();
        this.cellLocation = this.cell.getCellId().getLocation();
        this.indices = this.grid.getCellIndices((SymmetricGridCellId)this.cell.getCellId());
        return this.cell;
    }

    private static enum Direction {
        TOP(0, -1),
        TOP_RIGHT(1, -1),
        RIGHT(1, 0),
        BOTTOM_RIGHT(1, 1),
        BOTTOM(0, 1),
        BOTTOM_LEFT(-1, 1),
        LEFT(-1, 0),
        TOP_LEFT(-1, -1);

        public final int x;
        public final int y;

        private Direction(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

