/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.agent;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractEmbodiedAgent;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.command.impl.IJNIAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.defcon.agent.DefConLogPublisher;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.communication.command.impl.DefConAct;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.GameRunningChanged;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.utils.NullCheck;
import java.util.Map;

public class DefConAgent<CONTROLLER extends IDefConAgentLogicController<DefConAgent<?>, ?>>
extends AbstractEmbodiedAgent<DefConWorldView, IJNIAct>
implements IDefConAgent {
    private CONTROLLER controller;
    private Map<String, String> arguments;
    private BusAwareCountDownLatch initedLatch;
    private boolean gameStarted = false;
    private boolean botStoppedCalled;
    protected DefConWorldView worldview;
    private IWorldEventListener<GameRunningChanged> startListener = new IWorldEventListener<GameRunningChanged>(){

        public void notify(GameRunningChanged event) {
            if (!event.getRunning().booleanValue()) {
                DefConAgent.this.gameStarted();
            }
        }
    };

    @Inject
    public DefConAgent(IAgentId agentId, IComponentBus eventBus, IAgentLogger logger, DefConWorldView worldView, DefConAct act, IDefConAgentLogicController logic) {
        super(agentId, eventBus, logger, (IWorldView)worldView, (IAct)act);
        this.controller = logic;
        NullCheck.check(this.controller, (String)"init");
        logger.addToAllCategories((ILogPublisher)new DefConLogPublisher());
        this.log.finer("Initializing bot controller...");
        this.controller.initializeController((DefConAgent)this);
        this.log.fine("Controller initialized.");
        worldView.addEventListener(GameRunningChanged.class, this.startListener);
        this.worldview = worldView;
    }

    @Override
    public Map<String, String> getArguments() {
        return this.arguments;
    }

    @Override
    public void setOptions(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    public DefConWorldView getWorldView() {
        return (DefConWorldView)super.getWorldView();
    }

    protected void startAgent() {
        this.botStoppedCalled = false;
        super.startAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAgent() {
        try {
            if (this.botStoppedCalled) {
                this.controller.botStopped();
                this.botStoppedCalled = true;
            }
        }
        finally {
            super.stopAgent();
        }
    }

    protected void killAgent() {
    }

    protected void gameStarted() {
        this.gameStarted = true;
    }

    protected boolean gameHasStarted() {
        return this.gameStarted;
    }

    @Override
    public void act(DefConCommand command) {
        ((IJNIAct)this.getAct()).act((CommandMessage)command);
    }
}

