package cz.cuni.amis.pogamut.defcon.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.Tuple2;

/**
 * Utilities for polygons. Experimental.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class PolygonUtils {
	
	/**
	 * Shrinks or enlarges a polygon.
	 * 
	 * @param poly
	 * @param offset
	 * @return
	 */
	public static LinkedList<Location> resizePoly(List<Location> poly,
			double offset) {
		
		if (poly.size() < 3)
			return null;
		
		LinkedList<Location> resized = new LinkedList<Location>();				
		
		Iterator<Location> iterator = poly.iterator(); 
		
		Location old = iterator.next();
		Location current;
		
		Location shifted_old1;
		Location shifted_current1;
		Location shifted_old2;
		Location shifted_current2;		
		Location tmp;
		double length = 0d;
		double param2;
		Location dir1, dir2, diff;
		
		current = iterator.next();
		
		length = old.getDistance2D(current);
		tmp = current.sub(old);
		tmp = new Location(tmp.getX() + tmp.getY(), tmp.getY() - tmp.getX()).scale(offset/length);
		
		shifted_old1 = new Location(old.getX() + tmp.getY(), old.getX() - tmp.getX());
		shifted_current1 = new Location(current.getX() + tmp.getY(), current.getX() - tmp.getX());	
		
		while (iterator.hasNext()) {
			current = iterator.next();
			
			length = old.getDistance2D(current);
			tmp = current.sub(old);
			dir2 = tmp.invert();
			tmp = new Location(tmp.getX() + tmp.getY(), tmp.getY() - tmp.getX()).scale(offset/length);
			
			shifted_old2 = new Location(old.getX() + tmp.getY(), old.getX() - tmp.getX());
			shifted_current2 = new Location(current.getX() + tmp.getY(), current.getX() - tmp.getX());
			
			// solve gauss
			
			diff = new Location(shifted_old1.getX() - shifted_current2.getX(),
					shifted_old1.getY() - shifted_current2.getY());
					
			dir1 = shifted_current1.sub(shifted_old1);
			
			//param2 = partiallySolve2DGauss(dir1, dir2, diff);
			Tuple2<Double, Location[]> result = partiallySolve2DGauss(dir1, dir2, diff);
			param2 = result.getFirst();
			dir1 = result.getSecond()[0];
			dir2 = result.getSecond()[1];
			diff = result.getSecond()[2];
			
			// param1 = diff1 - param2 * dir2.x;
			
			resized.add(dir2.scale(param2));
			
			shifted_old1 = shifted_old2;
			shifted_current1 = shifted_current2;
		}
		
		System.gc();
		return resized;
	}

	private static Tuple2<Double, Location[]> partiallySolve2DGauss(Location a1, Location a2, Location b) {		
//		a2.x /= a1.x;
		a2 = a2.setX(a2.x / a1.x);		

//		b.x /= a1.x;
		b = b.setX(b.x / a1.x);
		
//		a1.x = 1;
		a1 = a1.setX(1);
				
//		a2.y = a2.y / a1.y - a2.x;
		a2.setY(a2.y / a1.y - a2.x);
		
//		b.y = b.y / a1.y - b.x;
		b.setY(b.y / a1.y - b.x);

//		a1.y = 0;
		a1.setY(0);

		double result = b.x / a2.y;
		
//		return b.x / a2.y;
		return new Tuple2<Double, Location[]>(result, new Location[]{a1,a2,b});
	}
	
	private class PolygonWithBarycenter {
		LinkedList<Location> polygon = new LinkedList<Location>();
		Location barycenter;
	}
	
	private class Candidates {
		Location a, b, c;
	}
	
	public static LinkedList<Location> resizePoly2(LinkedList<Location> poly, double offset) {
		
		if (poly == null)
			return null;
		
		if (poly.size() == 0)
			return new LinkedList<Location>();
		
		if (poly.size() < 3) {
			LinkedList<Location> out = new LinkedList<Location>();
			
			for (Location loc : poly) {			
				out.add(new Location(loc));
			}
			
			return out;
		}
		
		
		LinkedList<PolygonWithBarycenter> polygons = new LinkedList<PolygonWithBarycenter>();
		LinkedList<LinkedList<Location>> convexity_breaking =
			new LinkedList<LinkedList<Location>>();
		
		Iterator<Location> iter = poly.iterator();
		Location last = iter.next();
		Location middle = iter.next();
		Location current = null;
		LinkedList<Location> breakers = null;
		ReturnValueOfCheckDirection ret = null;
		
		while (iter.hasNext()) {
			current = iter.next();
									
			ret =
				checkDirection(last, middle, current, breakers, convexity_breaking);
			
			breakers = ret.breakers;
			
			last = middle;
			middle = current;
		}
		
		iter = poly.iterator();
		current = iter.next();
		
		
		if (
				(ret = checkDirection(last, middle, current, breakers, convexity_breaking)).ret) {
			breakers = ret.breakers;
			while (iter.hasNext()) { // or break is hit
				current = iter.next();
				
				if (!(ret = checkDirection(last, middle, current, breakers, convexity_breaking)).ret) {
					breakers = ret.breakers;
					break;
				}					
				breakers = ret.breakers;
				last = middle;
				middle = current;				
			}
		}
		
		return null;
	}
	
	private static class ReturnValueOfCheckDirection { 
		LinkedList<Location> breakers;
		boolean ret;
		
		public ReturnValueOfCheckDirection(LinkedList<Location> breakers,
				boolean ret) {
			this.breakers = breakers;
			this.ret = ret;
		}
	}
	
	private static ReturnValueOfCheckDirection checkDirection(
			Location last, Location middle, Location current,
			LinkedList<Location> breakers,
			LinkedList<LinkedList<Location>> convexity_breaking) {
		
		Location diff_middle = middle.sub(last);
		Location diff_last = current.sub(last);
		
		Location ax = new Location(diff_middle.getY(), -diff_middle.getX());		
		
		if (diff_last.dot(ax) < 0) { // turning left
			if (breakers == null) {
				breakers = new LinkedList<Location>();
				breakers.add(last);
			}
			
			breakers.add(middle);
			return new ReturnValueOfCheckDirection(breakers, true);
		} else {
			if (breakers != null) {
				breakers.add(middle);
				
				convexity_breaking.add(breakers);
				breakers = null;
			}
			return new ReturnValueOfCheckDirection(breakers, false);
		}		
	}
	
	private class Triangle {
		Location a,b,c;

		public Triangle(Location a, Location b, Location c) {
			this.a = a;
			this.b = b;
			this.c = c;
		}
	}
	
	private static double EPSILON = 0.001d;
	
	public static LinkedList<Location> resizePoly3(LinkedList<Location> poly, double offset) {
		LinkedList<Location> out = new LinkedList<Location>();
		Location[] ret = resizePoly3((Location[])poly.toArray(), offset);
		for (int i = 0; i < ret.length; ++i) {
			out.add(ret[i]);
		}
		
		return out;
	}
	
	public static Location[] resizePoly3(Location[] poly, double offset) {
		
		int size = poly.length;
		
		if (size < 3) {
			return deepCopy(poly);
		}
		
		int[] indices = triangulate(poly);
		
		for (int i = 0; i < indices.length; ++i) {
			
		}
		
		Location[] out = new Location[size];
		
		for (int i = 0; i < size; ++i) {
			out[i] = poly[indices[i]];
		}
		return out;
	}
	
	private static int[] triangulate(Location[] vertices) {
		
		int size = vertices.length;
		
	    int[] V = new int[size];
	    int[] indices = new int[size];
	    int current_index = 0;
	    
	    if (0.0f < area(vertices))
	    {
	        for (int v = 0; v < size; v++)
	            V[v] = v;
	    }
	    else
	    {
	        for (int v = 0; v < size; v++)
	            V[v] = (size - 1) - v;
	    }
	    int nv = size;
	    int count = 2 * nv;
	    for (int m = 0, v = nv - 1; nv > 2;)
	    {
	        if (0 >= (count--))
	            return V;

	        int u = v;
	        if (nv <= u)
	            u = 0;
	        v = u + 1;
	        if (nv <= v)
	            v = 0;
	        int w = v + 1;
	        if (nv <= w)
	            w = 0;

	        if (snip(vertices, u, v, w, nv, V)) {
	        	int a, b, c, s, t;
	            a = V[u];
	            b = V[v];
	            c = V[w];
	            indices[current_index++] = a;
	            indices[current_index++] = b;
	            indices[current_index++] = c;
	            m++;
	            for (s = v, t = v + 1; t < nv; s++, t++)
	                V[s] = V[t];
	            nv--;
	            count = 2 * nv;	            
	        }
	    }
	    
	    return indices;
	}


	private static boolean checkDirection2(Location last, Location middle, Location current) {
		
		Location diff_middle = middle.sub(last);
		Location diff_last = current.sub(last);
		
		Location ax = new Location(diff_middle.getY(), -diff_middle.getX());		
		
		return (diff_last.dot(ax) < 0);
	}
	
	private static float area(Location[] poly) {
		
		if (poly.length < 3)
			return 0f;
		
	    float A = 0.0f;
	    	    
	    for (int i = poly.length - 1, j = 0; j < poly.length; i = j++)
	        A += poly[i].x * poly[j].y - poly[j].x * poly[i].y;	        	        

	    return (A * 0.5f);
	}
	
	private static Location[] deepCopy(Location[] toCopy) {
		Location[] out = new Location[toCopy.length];
		
		for (int i = 0; i < toCopy.length; ++i) {
			out[i] = new Location(toCopy[i]);
		}
		
		return out;		
	}
	
	private static boolean snip(Location[] vertices, int u, int v, int w, int n, int[] V)
	{
	    int p;
	    Location A = vertices[V[u]];
	    Location B = vertices[V[v]];
	    Location C = vertices[V[w]];
	    if (EPSILON > (((B.x - A.x) * (C.y - A.y)) - ((B.y - A.y) * (C.x - A.x))) )
	        return false;
	    for (p = 0; p < n; p++)
	    {
	        if ((p == u) || (p == v) || (p == w))
	            continue;
	        Location P = vertices[V[p]];
	        if (insideTriangle(A, B, C, P))
	            return false;
	    }
	    return true;
	}
	
	private static boolean insideTriangle(Location A, Location B, Location C,
		    Location P)
		{
		    double ax, ay, bx, by, cx, cy, apx, apy, bpx, bpy, cpx, cpy;
		    double cCROSSap, bCROSScp, aCROSSbp;

		    ax = C.x - B.x;  ay = C.y - B.y;
		    bx = A.x - C.x;  by = A.y - C.y;
		    cx = B.x - A.x;  cy = B.y - A.y;
		    apx = P.x - A.x;  apy = P.y - A.y;
		    bpx = P.x - B.x;  bpy = P.y - B.y;
		    cpx = P.x - C.x;  cpy = P.y - C.y;

		    aCROSSbp = ax * bpy - ay * bpx;
		    cCROSSap = cx * apy - cy * apx;
		    bCROSScp = bx * cpy - by * cpx;

		    return ((aCROSSbp >= 0.0f) && (bCROSScp >= 0.0f) && (cCROSSap >= 0.0f));
		}
	
	
	
}
