package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * List of all ingame territories.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum Territory {
	
	NORTH_AMERICA(JBot.TerritoryNorthAmerica),
	SOUTH_AMERICA(JBot.TerritorySouthAmerica),
	EUROPE(JBot.TerritoryEurope),
	RUSSIA(JBot.TerritoryRussia),
	SOUTH_ASIA(JBot.TerritorySouthAsia),
	AFRICA(JBot.TerritoryAfrica);
	
	public static final int NUMBER = JBot.NumTerritories;
	
	private static Map<Integer, Territory> enums = new HashMap<Integer, Territory>();
	
	public static Territory getEnum(int id) {
		return enums.get(id);
	}
	
	static {
		for (Territory item : Territory.values()) {
			enums.put(item.id, item);
		}
	}
	
	private int id;
	
	private Territory(int id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}
	
}
