package cz.cuni.amis.pogamut.defcon.communication.mailbox;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.defcon.ai.IUnitAI;

/**
 * Interface for a mailbox lower level AIs can use to communicate.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public interface IMailBox {

	/**
	 * Sends a message to all AIs of a given class.
	 * 
	 * @param targetAIClass
	 * @param message
	 */
	void mail(Class<? extends IUnitAI> targetAIClass, IMessage message);
	
	/**
	 * Sends a message to a specific AI controlling a unit or fleet with a given
	 * WorldObjectId.
	 * 
	 * @param targetId
	 * @param message
	 */
	void mail(WorldObjectId targetId, IMessage message);
	
	/**
	 * Sends a message to a specific AI.
	 * 
	 * @param ai
	 * @param message
	 */
	void mail(IUnitAI ai, IMessage message);
	
	/**
	 * Registers an AI for mail.
	 * 
	 * @param ai
	 */
	void registerAI(IUnitAI ai);

	/**
	 * Registers an AI for mail.
	 * 
	 * @param ai
	 */
	void unregisterAI(IUnitAI ai);

}
