package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * List of possible votes for {@link SendVote} command.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum Vote {
	
	UNKNOWN(JBot.VoteUnknown),
	YES(JBot.VoteYes),
	NO(JBot.VoteNo),
	ABSTAIN(JBot.VoteAbstain);
	
	private static Map<Integer, Vote> enums = new HashMap<Integer, Vote>();
	
	public static Vote getEnum(int id) {
		return enums.get(id);
	}
	
	static {
		for (Vote item : Vote.values()) {
			enums.put(item.id, item);
		}
	}
	
	public final int id;
	
	private Vote(int id) {
		this.id = id;
	}

}
