package cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;

/**
 * Interface for loading of saved borders.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public interface IPrecomputedBordersLoader {

	/**
	 * Loads borders from a given file name.
	 * 
	 * @param fileName
	 * @return
	 * @throws FileNotFoundException
	 * @throws NumberFormatException
	 * @throws IOException
	 */
	List<List<DefConLocation>> loadBordersForTerritory(String fileName)
			throws FileNotFoundException, NumberFormatException, IOException;
}
