package cz.cuni.amis.pogamut.defcon.ai;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.mailbox.IMessage;

/**
 * Topmost interface for unit AI.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public interface IUnitAI {
	/**
	 * Update method called before the main AI.
	 */
	void update();

	/**
	 * Receives a message from mailbox.
	 * 
	 * @param message
	 */
	void receiveMessage(IMessage message);

	/**
	 * Returns the {@link WorldObjectId} of the associated unit.
	 * 
	 * @return
	 */
	WorldObjectId getId();

	/**
	 * Unregisters ai from all places. ALWAYS CALL SUPER.DISPOSE!
	 */
	void dispose();

	/**
	 * Retrieves location of the controlled object.
	 * 
	 * @return location
	 */
	DefConLocation getLocation();

}
