/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.base3d.worldview.object;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

public class DefConLocation
extends Location {
    public DefConLocation() {
    }

    public DefConLocation(double x, double y) {
        super(x, y);
        if (y > 100.0 || y < -100.0) {
            throw new IllegalArgumentException("DefConLocation Y coord must be inside <-100, 100>");
        }
        this.correct();
    }

    public DefConLocation(float[] f) {
        this(f[0], f[1]);
    }

    public DefConLocation(double[] d) {
        this(d[0], d[1]);
    }

    public DefConLocation(Location location) {
        this(location.getX(), location.getY());
    }

    public double getDistance2D(Location location) {
        return this.getDistance(location);
    }

    public double getDistance(Location location) {
        Location tmp = new Location();
        double diff = this.x - location.x;
        tmp.x = diff > 180.0 ? this.x - 360.0 - location.x : (diff < -180.0 ? this.x + 360.0 - location.x : this.x - location.x);
        tmp.y = this.y - location.y;
        return tmp.getLength();
    }

    public static Location sub(DefConLocation l1, DefConLocation l2) {
        Location out = new Location();
        double diff = l1.x - l2.x;
        out.x = diff > 180.0 ? l1.x - 360.0 - l2.x : (diff < -180.0 ? l1.x + 360.0 - l2.x : l1.x - l2.x);
        out.y = l1.y - l2.y;
        return out;
    }

    protected void correct() {
        if (this.y > 100.0 || this.y < -100.0) {
            throw new IllegalArgumentException("DefConLocation Y coord must be inside <-100, 100>. " + this.y);
        }
        this.x = DefConLocation.mathModulus(this.x + 180.0, 360.0) - 180.0;
    }

    protected static final double mathModulus(double a, double b) {
        return (a % b + b) % b;
    }

    public DefConLocation scale(double d) {
        return new DefConLocation(super.scale(d));
    }

    public DefConLocation add(Location l) {
        DefConLocation out = new DefConLocation();
        double diff = this.x - l.x;
        out.x = diff > 180.0 ? this.x + 360.0 + l.x : (diff < -180.0 ? this.x - 360.0 + l.x : this.x + l.x);
        out.y = this.y + l.y;
        out.correct();
        return out;
    }

    public Location sub(DefConLocation l) {
        return DefConLocation.sub(this, l);
    }

    public DefConLocation getNormalized() {
        return new DefConLocation(super.getNormalized());
    }

    public DefConLocation invert() {
        return new DefConLocation(-this.x, -this.y);
    }

    public DefConLocation setTo(Location l) {
        this.x = l.x;
        this.y = l.y;
        this.correct();
        return this;
    }

    public DefConLocation setTo(double x, double y, double z) {
        return this.setTo(x, y);
    }

    public DefConLocation setTo(double x, double y) {
        this.x = x;
        this.y = y;
        this.correct();
        return this;
    }

    public double getDistanceSquare(Location l) {
        l = this.sub(l);
        double dx = l.x;
        double dy = l.y;
        double dz = l.z;
        return dx * dx + dy * dy + dz * dz;
    }
}

