package cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;

/**
 * Loads borders (contours) from a given path.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class FilePrecomputedBordersLoader implements IPrecomputedBordersLoader {

	private String pathString;
	private File path;
	private Pattern pattern = Pattern.compile("[-0-9\\.]+");
	private Logger log;

	public FilePrecomputedBordersLoader(String pathString) {
		this(pathString, null);
	}

	public FilePrecomputedBordersLoader(String pathString, Logger log) {
		this.pathString = pathString;
		this.path = new File(pathString);
		this.log = log;

		if (!this.path.isDirectory())
			throw new IllegalArgumentException(
					"FilePrecomputedBordersSaver: pathString has to point to a directory");
	}



	@Override
	public List<List<DefConLocation>> loadBordersForTerritory(String fileName)
			throws NumberFormatException, IOException {

		if (log != null) {
			log.info("path: " + path.getAbsolutePath()
				+ "\\" + fileName);
		}
		BufferedReader input = new BufferedReader(new FileReader(new File(
				path, fileName)));

		String line;
		ArrayList<List<DefConLocation>> territory = new ArrayList<List<DefConLocation>>();
		double[] singleLocation = new double[3];

		while ((line = input.readLine()) != null) {
			Matcher match = pattern.matcher(line);
			LinkedList<DefConLocation> border = new LinkedList<DefConLocation>();
			
			int i = 0;
			while (match.find()) {
								
				String member = match.group();

				singleLocation[i] = Double.parseDouble(member);
				i = (i + 1) % 3;

				if (i == 0) {
					border.add(new DefConLocation(singleLocation));
					singleLocation = new double[3];
				}
			}
			territory.add(border);
		}
		return territory;
	}

	public String getPathString() {
		return pathString;
	}

}
