package cz.cuni.amis.pogamut.defcon.ai.buildingai;

import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.ai.AbstractAI;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;

/**
 * Implements common features for buildings.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 * @param <T>
 */
public abstract class AbstractBuildingAI<T extends DefConUnitObject<?>> extends
		AbstractAI
		implements IBuildingAI {

	protected final T building;
	protected int nukes;

	public AbstractBuildingAI(T building, DefConAgentLogicController<?> logic) {
		super(logic, building.getId());
		this.building = building;
		nukes = logic.getGameInfo().getNukeSupply(unitId);
	}

	protected boolean hasSpareNukes() {
		return nukes > 0;
	}

	@Override
	public DefConLocation getLocation() {
		return building.getLocation();
	}
}
