/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.polygons;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.IFlagChecker;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders.FilePrecomputedBordersLoader;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders.IPrecomputedBordersSaver;
import cz.cuni.amis.pogamut.defcon.utils.Pair;
import cz.cuni.amis.utils.iterators.CircularListIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import javabot.PogamutJBotSupport;

public class GameMapInfoPolygons
extends SensorModule<DefConAgent> {
    protected final float STEP_SIZE = 1.0f;
    protected final float SIMPLIFICATION_FACTOR = 0.1f;
    protected ArrayList<Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> territories = new ArrayList();
    protected TreeMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> ownTerritories = new TreeMap();
    protected TreeMap<Integer, SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>> enemyTerritories = new TreeMap();
    protected List<List<DefConLocation>> land;
    protected List<List<DefConLocation>> sea;
    protected IFlagChecker flagChecker;
    protected BasicFlag currentFlag;
    protected int currentTerritoryId;
    protected int currentEnemyId;
    protected int lastAssignedTerritory;
    protected double minX;
    protected double minY;

    public GameMapInfoPolygons(DefConAgent<?> agent, IFlagChecker flagChecker) {
        this(agent, flagChecker, null, null);
    }

    public GameMapInfoPolygons(DefConAgent<?> agent, IFlagChecker flagChecker, String preprocessedPath) {
        this(agent, flagChecker, preprocessedPath, null);
    }

    public GameMapInfoPolygons(DefConAgent<?> agent, IFlagChecker flagChecker, String preprocessedPath, Logger log) {
        this(agent, flagChecker, preprocessedPath, log, null);
    }

    public GameMapInfoPolygons(DefConAgent<?> agent, IFlagChecker flagChecker, String preprocessedPath, Logger log, ComponentDependencies dependencies) {
        super(agent, log, dependencies);
        this.flagChecker = flagChecker;
        this.minX = agent.getWorldView().getMinX();
        this.minY = agent.getWorldView().getMaxX();
        for (int i = 0; i < agent.getWorldView().getGameInfo().getTerritoriesCount(); ++i) {
            this.territories.add(new Pair());
        }
        for (int teamId : agent.getWorldView().getGameInfo().getTeamIds()) {
            for (int territoryId : agent.getWorldView().getGameInfo().getTeamTerritories(teamId)) {
                Pair<List<List<DefConLocation>>, List<List<DefConLocation>>> territory = this.territories.get(territoryId);
                if (this.lastAssignedTerritory < territoryId) {
                    this.lastAssignedTerritory = territoryId;
                }
                if (agent.getWorldView().getGameInfo().getOwnTeamId() == teamId) {
                    this.ownTerritories.put(territoryId, territory);
                    continue;
                }
                TreeMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> setOfEnemiesTerritories = new TreeMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>();
                this.enemyTerritories.put(teamId, setOfEnemiesTerritories);
                setOfEnemiesTerritories.put(territoryId, territory);
            }
        }
        if (preprocessedPath == null) {
            this.processMap();
        } else {
            this.loadBorders(preprocessedPath);
        }
    }

    public void saveBorders(IPrecomputedBordersSaver saver) {
        this.log.info("Saving borders");
        for (BasicFlag flag : new FlagColl()) {
            this.log.info("Saving: " + (Object)((Object)flag) + " " + this.currentTerritoryId);
            String type = null;
            List territory = null;
            try {
                switch (flag) {
                    case ENEMY_PLACEABLE_LAND: 
                    case OWN_PLACEABLE_LAND: {
                        type = "LAND";
                        territory = (List)this.territories.get((int)this.currentTerritoryId).second;
                    }
                    case ENEMY_PLACEABLE_SEA: 
                    case OWN_PLACEABLE_SEA: {
                        if (type == null) {
                            type = "SEA";
                            territory = (List)this.territories.get((int)this.currentTerritoryId).first;
                        }
                        saver.saveBorderOfTerritory("TERRITORY_" + type + "_" + this.currentTerritoryId + "_border.def", territory);
                        break;
                    }
                    case SEA: {
                        territory = this.sea;
                    }
                    case LAND: {
                        if (territory == null) {
                            territory = this.land;
                        }
                        saver.saveBorderOfTerritory((Object)((Object)flag) + "_border.def", territory);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadBorders(String preprocessedPath) {
        this.log.info("Loading borders");
        FilePrecomputedBordersLoader loader = new FilePrecomputedBordersLoader(preprocessedPath);
        for (BasicFlag flag : new FlagColl()) {
            this.log.info("Loading: " + (Object)((Object)flag) + " " + this.currentTerritoryId);
            try {
                List<List<DefConLocation>> borders;
                String type = null;
                switch (flag) {
                    case ENEMY_PLACEABLE_LAND: 
                    case OWN_PLACEABLE_LAND: {
                        type = "LAND";
                    }
                    case ENEMY_PLACEABLE_SEA: 
                    case OWN_PLACEABLE_SEA: {
                        if (type == null) {
                            type = "SEA";
                        }
                        borders = loader.loadBordersForTerritory("TERRITORY_" + type + "_" + this.currentTerritoryId + "_border.def");
                        break;
                    }
                    default: {
                        borders = loader.loadBordersForTerritory((Object)((Object)flag) + "_border.def");
                    }
                }
                switch (flag) {
                    case ENEMY_PLACEABLE_SEA: 
                    case OWN_PLACEABLE_SEA: {
                        this.territories.get((int)this.currentTerritoryId).first = borders;
                        break;
                    }
                    case ENEMY_PLACEABLE_LAND: 
                    case OWN_PLACEABLE_LAND: {
                        this.territories.get((int)this.currentTerritoryId).second = borders;
                        break;
                    }
                    case SEA: {
                        this.sea = borders;
                        break;
                    }
                    case LAND: {
                        this.land = borders;
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public DefConWorldView getWorldView() {
        return (DefConWorldView)this.worldView;
    }

    private final int convertCoordsToVisitedIndex(Coords coords) {
        return coords.getX() * coords.getYSize() + coords.getY();
    }

    protected void processMap() {
        BitSet visited = new BitSet();
        for (BasicFlag flag : new FlagColl()) {
            visited.clear();
            ArrayList<List<DefConLocation>> borders = new ArrayList<List<DefConLocation>>();
            Coords coords = new Coords(0, 0);
            coords.setX(0);
            while (coords.getX() < coords.getXSize()) {
                coords.setY(0);
                while (coords.getY() < coords.getYSize()) {
                    LinkedList<DefConLocation> poly;
                    int visited_index = this.convertCoordsToVisitedIndex(coords);
                    if (!visited.get(visited_index) && this.isBorder(coords, flag) && (poly = this.getFloodFillBorder(coords, flag, visited)) != null && poly.size() > 0) {
                        borders.add(Collections.unmodifiableList(this.smoothPoly(poly)));
                    }
                    visited.set(visited_index);
                    coords.setY(coords.getY() + 1);
                }
                coords.setX(coords.getX() + 1);
            }
            this.log.info("Finished: " + (Object)((Object)flag));
            block0 : switch (flag) {
                case ENEMY_PLACEABLE_LAND: 
                case OWN_PLACEABLE_LAND: 
                case ENEMY_PLACEABLE_SEA: 
                case OWN_PLACEABLE_SEA: {
                    Pair<List<List<DefConLocation>>, List<List<DefConLocation>>> pair = this.territories.get(this.currentTerritoryId);
                    switch (flag) {
                        case ENEMY_PLACEABLE_SEA: 
                        case OWN_PLACEABLE_SEA: {
                            pair.first = borders;
                            break block0;
                        }
                        case ENEMY_PLACEABLE_LAND: 
                        case OWN_PLACEABLE_LAND: {
                            pair.second = borders;
                        }
                    }
                    break;
                }
                case LAND: {
                    this.land = borders;
                    break;
                }
                case SEA: {
                    this.sea = borders;
                }
            }
        }
        PogamutJBotSupport.writeToConsole("mapInfo done");
        System.gc();
    }

    private LinkedList<DefConLocation> smoothPoly(LinkedList<DefConLocation> poly) {
        if (poly.size() <= 3) {
            return poly;
        }
        ListIterator<DefConLocation> iter = poly.listIterator(1);
        DefConLocation first = iter.next();
        DefConLocation second = null;
        DefConLocation third = poly.peekFirst();
        boolean last = false;
        DefConLocation last_dir = null;
        while (iter.hasNext()) {
            second = first;
            first = iter.next();
            if (first.equals(third)) continue;
            if (this.areNeighbours(first, third) && (!last || last_dir.equals(third.sub(first).getNormalized(), 0.1f))) {
                iter.previous();
                iter.previous();
                iter.remove();
                if (!last) {
                    last_dir = new DefConLocation(third.sub(first).getNormalized());
                }
                first = iter.next();
                last = true;
                continue;
            }
            third = second;
            last = false;
        }
        return poly;
    }

    private boolean areNeighbours(DefConLocation first, DefConLocation second) {
        return (Math.abs(first.getX() - second.getX()) <= 1.0 || Math.abs(first.getX() - second.getX()) - this.getWorldView().getMinX() <= 1.0) && Math.abs(first.getY() - second.getY()) <= 1.0;
    }

    private boolean isPossibleBorderStartPoint(Coords coords, BasicFlag flag) {
        if (coords == null) {
            return false;
        }
        if (!this.flagCheck(coords.getLocation())) {
            return false;
        }
        DefConLocation neighbour_location = Direction.LEFT.getLocationInThisDirection(coords);
        if (neighbour_location != null && this.flagCheck(neighbour_location)) {
            return false;
        }
        neighbour_location = Direction.LOWER.getLocationInThisDirection(coords);
        return neighbour_location == null || !this.flagCheck(neighbour_location);
    }

    private boolean isBorder(Coords coords, BasicFlag flag) {
        if (coords == null) {
            return false;
        }
        if (!this.flagCheck(coords.getLocation())) {
            return false;
        }
        DefConLocation neighbour_location = Direction.RIGHT.getLocationInThisDirection(coords);
        if (neighbour_location == null || !this.flagCheck(neighbour_location)) {
            return true;
        }
        neighbour_location = Direction.LEFT.getLocationInThisDirection(coords);
        if (neighbour_location == null || !this.flagCheck(neighbour_location)) {
            return true;
        }
        neighbour_location = Direction.UPPER.getLocationInThisDirection(coords);
        if (neighbour_location == null || !this.flagCheck(neighbour_location)) {
            return true;
        }
        neighbour_location = Direction.LOWER.getLocationInThisDirection(coords);
        if (neighbour_location == null || !this.flagCheck(neighbour_location)) {
            return true;
        }
        neighbour_location = Direction.UPPER_RIGHT.getLocationInThisDirection(coords);
        if (neighbour_location == null || !this.flagCheck(neighbour_location)) {
            return true;
        }
        neighbour_location = Direction.UPPER_LEFT.getLocationInThisDirection(coords);
        if (neighbour_location == null || !this.flagCheck(neighbour_location)) {
            return true;
        }
        neighbour_location = Direction.LOWER_RIGHT.getLocationInThisDirection(coords);
        if (neighbour_location == null || !this.flagCheck(neighbour_location)) {
            return true;
        }
        neighbour_location = Direction.LOWER_LEFT.getLocationInThisDirection(coords);
        return neighbour_location == null || !this.flagCheck(neighbour_location);
    }

    private boolean isStandAloneCell(Coords coords, BasicFlag flag) {
        if (coords == null) {
            return false;
        }
        if (!this.isPossibleBorderStartPoint(coords, flag)) {
            return false;
        }
        DefConLocation neighbour_location = coords.getLocation();
        neighbour_location = Direction.RIGHT.getLocationInThisDirection(coords);
        if (neighbour_location != null && this.flagCheck(neighbour_location)) {
            return false;
        }
        neighbour_location = Direction.UPPER.getLocationInThisDirection(coords);
        return neighbour_location == null || !this.flagCheck(neighbour_location);
    }

    private LinkedList<DefConLocation> getFloodFillBorder(Coords coords, BasicFlag flag, BitSet visited) {
        LinkedList<DefConLocation> polygon;
        block5: {
            Coords first_coords;
            block6: {
                int visited_index = this.convertCoordsToVisitedIndex(coords);
                if (!this.isBorder(coords, flag) || visited.get(visited_index)) {
                    return null;
                }
                polygon = new LinkedList<DefConLocation>();
                first_coords = new Coords(coords);
                Coords old_coords = new Coords(coords);
                coords = new Coords(coords);
                Direction direction = Direction.RIGHT;
                Direction old_direction = Direction.LEFT;
                visited.set(visited_index);
                if (this.isStandAloneCell(first_coords, flag)) break block6;
                do {
                    direction = this.turnAsLeftAsPossible(direction, coords, flag);
                    coords = direction.getPointInThisDirection(old_coords);
                    visited_index = this.convertCoordsToVisitedIndex(coords);
                    visited.set(visited_index);
                    if (direction != old_direction) {
                        polygon.add(old_coords.getLocation());
                    }
                    old_coords.setCoords(coords);
                    old_direction = direction;
                    if (!coords.equals(first_coords)) continue;
                    visited_index = this.convertCoordsToVisitedIndex(coords = (direction = this.turnAsLeftAsPossible(direction, coords, flag)).getPointInThisDirection(old_coords));
                    if (visited.get(visited_index)) break block5;
                    visited.set(visited_index);
                    if (direction != old_direction) {
                        polygon.add(old_coords.getLocation());
                    }
                    old_coords.setCoords(coords);
                    old_direction = direction;
                } while (!coords.equals(first_coords));
                break block5;
                {
                }
            }
            polygon.add(first_coords.getLocation());
        }
        return polygon;
    }

    private Direction turnAsLeftAsPossible(Direction direction, Coords coords, BasicFlag flag) {
        direction = direction.turnLeft4Way();
        while (!this.isBorder(direction.getPointInThisDirection(coords), flag)) {
            direction = direction.turnRight4Way();
        }
        return direction;
    }

    private Coords getFilteredCoords(int x, int y) {
        try {
            return new Coords(x, y);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private LinkedList<DefConLocation> simplifyPoly(LinkedList<DefConLocation> poly) {
        double area = this.approximatePolyArea(poly);
        if (poly.size() <= 2) {
            return poly;
        }
        while ((double)(poly.size() * poly.size()) / area > (double)0.1f) {
            Edge lightest_edge = this.getLightestEdge(poly);
            area -= lightest_edge.weighEdge();
            lightest_edge.removeIntermediateVertices();
        }
        return null;
    }

    private final double approximatePolyArea(LinkedList<DefConLocation> poly) {
        if (poly.size() <= 1) {
            return 0.0;
        }
        double area = 0.0;
        Iterator iter = poly.iterator();
        DefConLocation look_back = (DefConLocation)((Object)iter.next());
        while (iter.hasNext()) {
            DefConLocation current = new DefConLocation((Location)iter.next());
            current.sub(new DefConLocation(this.minX, this.minY));
            area += look_back.getX() * current.getY();
            area -= look_back.getY() * current.getX();
        }
        area += look_back.getX() * poly.getFirst().getY();
        return 0.5 * (area -= look_back.getY() * poly.getFirst().getX());
    }

    private boolean flagCheck(DefConLocation location) {
        switch (this.currentFlag) {
            case ENEMY_TERRITORY: {
                return this.flagChecker.hasEnemyTerritoryFlag(location, this.currentEnemyId);
            }
            case ENEMY_PLACEABLE_LAND: {
                return this.flagChecker.hasEnemyTerritoryFlag(location, this.currentEnemyId, false);
            }
            case ENEMY_PLACEABLE_SEA: {
                return this.flagChecker.hasEnemyTerritoryFlag(location, this.currentEnemyId, true);
            }
        }
        return this.flagChecker.hasFlag(location, this.currentFlag);
    }

    private Edge getLightestEdge(LinkedList<DefConLocation> poly) {
        if (poly.size() <= 2) {
            return null;
        }
        CircularListIterator tmp = new CircularListIterator(poly);
        tmp.next();
        Edge lightest_edge = new Edge((CircularListIterator<DefConLocation>)new CircularListIterator(poly), (CircularListIterator<DefConLocation>)tmp, poly);
        double lightest_weight = Double.POSITIVE_INFINITY;
        CircularListIterator first_iter = new CircularListIterator(poly);
        while (!first_iter.hasPassedBeginning()) {
            DefConLocation first = (DefConLocation)((Object)first_iter.next());
            CircularListIterator second_iter = new CircularListIterator(first_iter);
            while (!second_iter.hasPassedEnd()) {
                double d;
                DefConLocation second = (DefConLocation)((Object)second_iter.next());
                if (second == first) continue;
                double weight = lightest_edge.weighEdge((CircularListIterator<DefConLocation>)first_iter.previousIter(), (CircularListIterator<DefConLocation>)second_iter.previousIter(), poly);
                if (lightest_weight > d) {
                    lightest_edge = new Edge((CircularListIterator<DefConLocation>)first_iter, (CircularListIterator<DefConLocation>)second_iter, poly);
                    lightest_weight = weight;
                }
                first_iter.next();
                second_iter.next();
            }
        }
        return lightest_edge;
    }

    private static final float mathModulus(float a, float b) {
        return (a % b + b) % b;
    }

    private static final List<DefConLocation> checkAndJoinBordersOnSeam(List<DefConLocation> borderA, List<DefConLocation> borderB) {
        return null;
    }

    public SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> getOwnTerritories() {
        return Collections.unmodifiableSortedMap(this.ownTerritories);
    }

    public SortedMap<Integer, SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>> getEnemiesTerritories() {
        return Collections.unmodifiableSortedMap(this.enemyTerritories);
    }

    public Pair<List<List<DefConLocation>>, List<List<DefConLocation>>> getTerritory(int territoryId) {
        return this.territories.get(territoryId);
    }

    public SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> getEnemyTerritories(int enemyId) {
        if (!this.enemyTerritories.containsKey(enemyId)) {
            throw new IllegalArgumentException("getEnemyTerritories does not contain " + enemyId + " only contains " + this.enemyTerritories.keySet().toString());
        }
        return Collections.unmodifiableSortedMap(this.enemyTerritories.get(enemyId));
    }

    public List<List<DefConLocation>> getLand() {
        return Collections.unmodifiableList(this.land);
    }

    public List<List<DefConLocation>> getSea() {
        return Collections.unmodifiableList(this.sea);
    }

    private class Edge {
        public CircularListIterator<DefConLocation> first;
        public CircularListIterator<DefConLocation> second;
        public LinkedList<DefConLocation> poly;

        public Edge(CircularListIterator<DefConLocation> first, CircularListIterator<DefConLocation> second, LinkedList<DefConLocation> poly) {
            if (first == null || second == null || poly == null) {
                throw new NullPointerException("None of the parameters of Edge construction should be null.");
            }
            this.first = new CircularListIterator(first);
            this.second = new CircularListIterator(second);
            this.poly = poly;
        }

        public void removeIntermediateVertices() {
            while (this.first.next() != this.second.next()) {
                this.first.remove();
                this.first.previous();
                this.second.previous();
            }
        }

        public final double weighEdge() {
            return this.weighEdge(this);
        }

        public final double weighEdge(CircularListIterator<DefConLocation> first, CircularListIterator<DefConLocation> second, LinkedList<DefConLocation> poly) {
            LinkedList<DefConLocation> subPoly = new LinkedList<DefConLocation>();
            CircularListIterator first_iter = new CircularListIterator(first);
            CircularListIterator second_iter = new CircularListIterator(second);
            DefConLocation current = (DefConLocation)((Object)first_iter.next());
            DefConLocation last = (DefConLocation)((Object)second_iter.next());
            while (current != last) {
                subPoly.add(current);
                current = (DefConLocation)((Object)first_iter.next());
            }
            return GameMapInfoPolygons.this.approximatePolyArea(subPoly);
        }

        public final double weighEdge(Edge edge) {
            LinkedList<DefConLocation> subPoly = new LinkedList<DefConLocation>();
            CircularListIterator<DefConLocation> first_iter = edge.getFirst();
            CircularListIterator<DefConLocation> second_iter = edge.getSecond();
            DefConLocation current = (DefConLocation)((Object)first_iter.next());
            DefConLocation last = (DefConLocation)((Object)second_iter.next());
            while (current != last) {
                subPoly.add(current);
                current = (DefConLocation)((Object)first_iter.next());
            }
            return GameMapInfoPolygons.this.approximatePolyArea(subPoly);
        }

        public CircularListIterator<DefConLocation> getFirst() {
            return new CircularListIterator(this.first);
        }

        public CircularListIterator<DefConLocation> getSecond() {
            return new CircularListIterator(this.second);
        }
    }

    private static enum Direction {
        RIGHT(1, 0),
        UPPER_RIGHT(1, -1),
        UPPER(0, -1),
        UPPER_LEFT(-1, -1),
        LEFT(-1, 0),
        LOWER_LEFT(-1, 1),
        LOWER(0, 1),
        LOWER_RIGHT(1, 1);

        public final int x;
        public final int y;

        private Direction(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Direction reverse() {
            switch (this) {
                case RIGHT: {
                    return LEFT;
                }
                case UPPER_RIGHT: {
                    return LOWER_LEFT;
                }
                case UPPER: {
                    return LOWER;
                }
                case UPPER_LEFT: {
                    return LOWER_RIGHT;
                }
                case LEFT: {
                    return RIGHT;
                }
                case LOWER_LEFT: {
                    return UPPER_RIGHT;
                }
                case LOWER: {
                    return UPPER;
                }
                case LOWER_RIGHT: {
                    return UPPER_LEFT;
                }
            }
            return null;
        }

        public Direction turnLeft() {
            switch (this) {
                case RIGHT: {
                    return UPPER_RIGHT;
                }
                case UPPER_RIGHT: {
                    return UPPER;
                }
                case UPPER: {
                    return UPPER_LEFT;
                }
                case UPPER_LEFT: {
                    return LEFT;
                }
                case LEFT: {
                    return LOWER_LEFT;
                }
                case LOWER_LEFT: {
                    return LOWER;
                }
                case LOWER: {
                    return LOWER_RIGHT;
                }
                case LOWER_RIGHT: {
                    return RIGHT;
                }
            }
            return null;
        }

        public Direction turnRight() {
            switch (this) {
                case RIGHT: {
                    return LOWER_RIGHT;
                }
                case LOWER_RIGHT: {
                    return LOWER;
                }
                case LOWER: {
                    return LOWER_LEFT;
                }
                case LOWER_LEFT: {
                    return LEFT;
                }
                case LEFT: {
                    return UPPER_LEFT;
                }
                case UPPER_LEFT: {
                    return UPPER;
                }
                case UPPER: {
                    return UPPER_RIGHT;
                }
                case UPPER_RIGHT: {
                    return RIGHT;
                }
            }
            return null;
        }

        public Direction turnRight4Way() {
            switch (this) {
                case UPPER_RIGHT: 
                case UPPER_LEFT: 
                case LOWER_LEFT: 
                case LOWER_RIGHT: {
                    return null;
                }
            }
            return this.turnRight().turnRight();
        }

        public Direction turnLeft4Way() {
            switch (this) {
                case UPPER_RIGHT: 
                case UPPER_LEFT: 
                case LOWER_LEFT: 
                case LOWER_RIGHT: {
                    return null;
                }
            }
            return this.turnLeft().turnLeft();
        }

        public DefConLocation getLocationInThisDirection(Coords coords) {
            try {
                switch (this) {
                    case RIGHT: {
                        return coords.getOwner().getFilteredCoords(coords.getX() + 1, coords.getY()).getLocation();
                    }
                    case UPPER: {
                        return coords.getOwner().getFilteredCoords(coords.getX(), coords.getY() + 1).getLocation();
                    }
                    case LEFT: {
                        return coords.getOwner().getFilteredCoords(coords.getX() - 1, coords.getY()).getLocation();
                    }
                    case LOWER: {
                        return coords.getOwner().getFilteredCoords(coords.getX(), coords.getY() - 1).getLocation();
                    }
                    case UPPER_RIGHT: {
                        return coords.getOwner().getFilteredCoords(coords.getX() + 1, coords.getY() + 1).getLocation();
                    }
                    case UPPER_LEFT: {
                        return coords.getOwner().getFilteredCoords(coords.getX() - 1, coords.getY() + 1).getLocation();
                    }
                    case LOWER_LEFT: {
                        return coords.getOwner().getFilteredCoords(coords.getX() - 1, coords.getY() - 1).getLocation();
                    }
                    case LOWER_RIGHT: {
                        return coords.getOwner().getFilteredCoords(coords.getX() + 1, coords.getY() - 1).getLocation();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
            return null;
        }

        public Coords getPointInThisDirection(Coords coords) {
            switch (this) {
                case RIGHT: {
                    return coords.getOwner().getFilteredCoords(coords.getX() + 1, coords.getY());
                }
                case UPPER: {
                    return coords.getOwner().getFilteredCoords(coords.getX(), coords.getY() + 1);
                }
                case LEFT: {
                    return coords.getOwner().getFilteredCoords(coords.getX() - 1, coords.getY());
                }
                case LOWER: {
                    return coords.getOwner().getFilteredCoords(coords.getX(), coords.getY() - 1);
                }
                case UPPER_RIGHT: {
                    return coords.getOwner().getFilteredCoords(coords.getX() + 1, coords.getY() + 1);
                }
                case UPPER_LEFT: {
                    return coords.getOwner().getFilteredCoords(coords.getX() - 1, coords.getY() + 1);
                }
                case LOWER_LEFT: {
                    return coords.getOwner().getFilteredCoords(coords.getX() - 1, coords.getY() - 1);
                }
                case LOWER_RIGHT: {
                    return coords.getOwner().getFilteredCoords(coords.getX() + 1, coords.getY() - 1);
                }
            }
            return null;
        }
    }

    private class Coords {
        private int x;
        private int y;

        public Coords(int x, int y) {
            this.x = x;
            this.y = y;
            this.filterRestrictedCoords();
        }

        public Coords(Coords source) {
            this.x = source.x;
            this.y = source.y;
            this.filterRestrictedCoords();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int setX(int x) {
            this.x = x;
            this.filterRestrictedCoords();
            return this.x;
        }

        public int setY(int y) {
            this.y = y;
            this.filterRestrictedCoords();
            return this.y;
        }

        public DefConLocation getLocation() {
            DefConLocation ret = new DefConLocation((double)((float)this.x * 1.0f) + GameMapInfoPolygons.this.getWorldView().getMinX(), -((double)((float)this.y * 1.0f) + GameMapInfoPolygons.this.getWorldView().getMinY()));
            return ret;
        }

        public final int getXSize() {
            return (int)Math.floor(GameMapInfoPolygons.this.getWorldView().getXSize() / 1.0);
        }

        public final int getYSize() {
            return (int)Math.floor(GameMapInfoPolygons.this.getWorldView().getYSize() / 1.0);
        }

        private final void filterRestrictedCoords() {
            if (this.y < 0 || this.y > this.getYSize()) {
                throw new IllegalArgumentException("Coords cant have y out of bounds");
            }
            if (this.x < 0 || this.x > this.getXSize()) {
                throw new IllegalArgumentException("Coords cant have x out of bounds");
            }
        }

        private final void filterCoords() {
            if (this.y < 0 || this.y > this.getYSize()) {
                throw new IllegalArgumentException("Coords cant have y out of bounds");
            }
            this.x %= this.getXSize();
        }

        public final GameMapInfoPolygons getOwner() {
            return GameMapInfoPolygons.this;
        }

        public boolean equals(Object o) {
            return ((Coords)o).x == this.x && ((Coords)o).y == this.y;
        }

        public void setCoords(Coords coords) {
            this.x = coords.x;
            this.y = coords.y;
            this.filterRestrictedCoords();
        }

        public String toString() {
            return "Coords: [ " + this.x + " ; " + this.y + " ] ";
        }
    }

    private class FlagColl
    implements Iterable<BasicFlag> {
        private FlagColl() {
        }

        @Override
        public Iterator<BasicFlag> iterator() {
            GameMapInfoPolygons.this.currentFlag = null;
            GameMapInfoPolygons.this.currentTerritoryId = -1;
            GameMapInfoPolygons.this.currentEnemyId = -1;
            return new FlagIterator();
        }

        private class FlagIterator
        implements Iterator<BasicFlag> {
            Iterator<Integer> territoryIterator = null;
            ArrayList<BasicFlag> acceptedFlags = new ArrayList();
            Iterator<BasicFlag> flagIterator;

            public FlagIterator() {
                GameMapInfoPolygons.this.currentFlag = null;
                GameMapInfoPolygons.this.currentEnemyId = -1;
                GameMapInfoPolygons.this.currentTerritoryId = -1;
                if (GameMapInfoPolygons.this.enemyTerritories.keySet().size() == 0) {
                    block6: for (BasicFlag flag : BasicFlag.values()) {
                        switch (flag) {
                            case ENEMY_PLACEABLE_LAND: 
                            case ENEMY_PLACEABLE_SEA: 
                            case ENEMY_TERRITORY: 
                            case OWN_TERRITORY: {
                                continue block6;
                            }
                            default: {
                                this.acceptedFlags.add(flag);
                            }
                        }
                    }
                } else {
                    block7: for (BasicFlag flag : BasicFlag.values()) {
                        switch (flag) {
                            case ENEMY_TERRITORY: 
                            case OWN_TERRITORY: {
                                continue block7;
                            }
                            default: {
                                this.acceptedFlags.add(flag);
                            }
                        }
                    }
                }
                this.flagIterator = this.acceptedFlags.iterator();
            }

            @Override
            public boolean hasNext() {
                if (!this.flagIterator.hasNext()) {
                    switch (GameMapInfoPolygons.this.currentFlag) {
                        case ENEMY_PLACEABLE_LAND: 
                        case OWN_PLACEABLE_LAND: 
                        case ENEMY_PLACEABLE_SEA: 
                        case OWN_PLACEABLE_SEA: {
                            return this.territoryIterator != null && this.territoryIterator.hasNext();
                        }
                    }
                    return false;
                }
                return true;
            }

            @Override
            public BasicFlag next() {
                if (GameMapInfoPolygons.this.currentFlag == null) {
                    return this.putFlagIntoEffect(this.flagIterator.next());
                }
                switch (GameMapInfoPolygons.this.currentFlag) {
                    case ENEMY_PLACEABLE_LAND: 
                    case OWN_PLACEABLE_LAND: 
                    case ENEMY_PLACEABLE_SEA: 
                    case OWN_PLACEABLE_SEA: {
                        if (this.territoryIterator == null || !this.territoryIterator.hasNext()) break;
                        GameMapInfoPolygons.this.currentTerritoryId = -1;
                        block6: while (this.territoryIterator.hasNext() && GameMapInfoPolygons.this.currentTerritoryId < GameMapInfoPolygons.this.lastAssignedTerritory) {
                            GameMapInfoPolygons.this.currentTerritoryId = this.territoryIterator.next();
                            GameMapInfoPolygons.this.currentEnemyId = ((DefConAgent)GameMapInfoPolygons.this.agent).getWorldView().getGameInfo().getTerritoryOwner(GameMapInfoPolygons.this.currentTerritoryId);
                            switch (GameMapInfoPolygons.this.currentFlag) {
                                case ENEMY_PLACEABLE_LAND: 
                                case ENEMY_PLACEABLE_SEA: {
                                    if (((DefConAgent)GameMapInfoPolygons.this.agent).getWorldView().getGameInfo().getOwnTeamId() == GameMapInfoPolygons.this.currentEnemyId) continue block6;
                                    break block6;
                                }
                            }
                        }
                        if (GameMapInfoPolygons.this.currentTerritoryId == -1) break;
                        return GameMapInfoPolygons.this.currentFlag;
                    }
                }
                this.territoryIterator = null;
                if (this.flagIterator.hasNext()) {
                    return this.putFlagIntoEffect(this.flagIterator.next());
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Flag iterator does not support remove operation.");
            }

            private BasicFlag putFlagIntoEffect(BasicFlag flag) {
                switch (flag) {
                    case OWN_PLACEABLE_LAND: 
                    case OWN_PLACEABLE_SEA: {
                        this.territoryIterator = GameMapInfoPolygons.this.ownTerritories.keySet().iterator();
                        GameMapInfoPolygons.this.currentFlag = flag;
                        return this.next();
                    }
                    case ENEMY_PLACEABLE_LAND: 
                    case ENEMY_PLACEABLE_SEA: {
                        this.territoryIterator = ((DefConAgent)GameMapInfoPolygons.this.agent).getWorldView().getGameInfo().getAllEnemyTerritories().iterator();
                        GameMapInfoPolygons.this.currentFlag = flag;
                        return this.next();
                    }
                }
                GameMapInfoPolygons.this.currentFlag = flag;
                return GameMapInfoPolygons.this.currentFlag;
            }
        }
    }
}

