package cz.cuni.amis.pogamut.defcon.utils.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

/**
 * A simple console formatter: LEVEL Message.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class BasicConsoleLogHandler extends ConsoleHandler {

	private static final Formatter formatter = new Formatter() {
		@Override
		public String format(LogRecord rec) {
			StringBuffer buf = new StringBuffer(1000);
			buf.append(rec.getLevel());
			buf.append(' ');
			buf.append(rec.getMessage());
			buf.append('\n');
			return buf.toString();
		}
	};

	public BasicConsoleLogHandler() {
		super();
		setFormatter(formatter);
	}

}
