/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.util.Iterator;
import java.util.List;

public class RectangularFillTester {
    public static boolean isSameRectangle(List<? extends Location> points, double x1, double y1, double x2, double y2) {
        if (points.size() < 4) {
            return false;
        }
        Iterator<? extends Location> iter = points.iterator();
        Location point = iter.next();
        Side side = RectangularFillTester.getSideToWhichPointBelongs(point.getX(), point.getY(), x1, y1, x2, y2);
        if (side == null) {
            return false;
        }
        int direction = 0;
        while (iter.hasNext()) {
            point = iter.next();
            Side old_side = side;
            side = RectangularFillTester.getSideToWhichPointBelongs(point.getX(), point.getY(), x1, y1, x2, y2);
            if (side == null) {
                return false;
            }
            if (old_side != side && direction == 0) {
                direction = (side.ordinal() - old_side.ordinal()) / 2;
                if (direction < -1) {
                    direction = 1;
                } else if (direction > 1) {
                    direction = -1;
                }
            }
            if (old_side == side || RectangularFillTester.edgeJumpInDirection(side, old_side, direction) || (old_side.ordinal() + direction) % Side.values().length == side.ordinal()) continue;
            return false;
        }
        return true;
    }

    private static boolean edgeJumpInDirection(Side side, Side old_side, int direction) {
        if (side.ordinal() % 2 == 0) {
            return false;
        }
        int tmp_val = (side.ordinal() - old_side.ordinal()) / 2;
        if (tmp_val < -1) {
            tmp_val = 1;
        }
        return tmp_val == direction;
    }

    private static Side getSideToWhichPointBelongs(double x, double y, double x1, double y1, double x2, double y2) {
        if (x == x2 && y == y1) {
            return Side.UPPER_RIGHT;
        }
        if (x == x2 && y == y2) {
            return Side.BOTTOM_RIGHT;
        }
        if (x == x1 && y == y2) {
            return Side.BOTTOM_LEFT;
        }
        if (x == x1 && y == y1) {
            return Side.UPPER_LEFT;
        }
        if (RectangularFillTester.checkIfBelongsToLine(x, y, x1, y1, x2, y1)) {
            return Side.UPPER;
        }
        if (RectangularFillTester.checkIfBelongsToLine(x, y, x2, y1, x2, y2)) {
            return Side.RIGHT;
        }
        if (RectangularFillTester.checkIfBelongsToLine(x, y, x2, y2, x1, y2)) {
            return Side.BOTTOM;
        }
        if (RectangularFillTester.checkIfBelongsToLine(x, y, x1, y2, x1, y1)) {
            return Side.LEFT;
        }
        return null;
    }

    private static boolean checkIfBelongsToLine(double whatX, double whatY, double whereX1, double whereY1, double whereX2, double whereY2) {
        if (whereX1 == whereX2) {
            return whatX == whereX1 && (whatY >= whereY1 && whatY <= whereY2 || whatY <= whereY1 && whatY >= whereY2);
        }
        if (whereY1 == whereY2) {
            return whatY == whereY1 && (whatX >= whereX1 && whatX <= whereX2 || whatX <= whereX1 && whatX >= whereX2);
        }
        return false;
    }

    static enum Side {
        UPPER,
        UPPER_RIGHT,
        RIGHT,
        BOTTOM_RIGHT,
        BOTTOM,
        BOTTOM_LEFT,
        LEFT,
        UPPER_LEFT;

    }
}

