package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * List of all possible type of polls.
 * Used in {@link SendVote}.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum VoteType {
	
	INVALID(JBot.VoteTypeInvalid),
	JOIN_ALLIANCE(JBot.VoteTypeJoinAlliance),
	KICK_PLAYER(JBot.VoteTypeKickPlayer),
	LEAVE_ALLIANCE(JBot.VoteTypeLeaveAlliance);
	
	private static Map<Integer, VoteType> enums = new HashMap<Integer, VoteType>();
	
	public static VoteType getEnum(int id) {
		return enums.get(id);
	}
	
	static {
		for (VoteType item : VoteType.values()) {
			enums.put(item.id, item);
		}
	}
	
	public final int id;
	
	private VoteType(int id) {
		this.id = id;
	}	

}