package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import java.util.Iterator;
import java.util.List;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

public class RectangularFillTester {

	enum Side {
		UPPER,
		UPPER_RIGHT,
		RIGHT,
		BOTTOM_RIGHT,
		BOTTOM,
		BOTTOM_LEFT,
		LEFT,
		UPPER_LEFT
	}

	/**
	 * Checks whether a given list of points, read clockwise, form a rectangle
	 * with the given vertices.
	 * 
	 * @param points
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @return
	 */
	public static boolean isSameRectangle(List<? extends Location> points,
			double x1, double y1, double x2, double y2) {

		if (points.size() < 4)
			return false;		

		Iterator<? extends Location> iter = points.iterator();
		Location point = iter.next();

		Side side =
				getSideToWhichPointBelongs(
						point.getX(), point.getY(), x1, y1, x2, y2);
		
		if (side == null)
			return false;
		
		Side old_side;
		int direction = 0;
		
		while (iter.hasNext()) {
			point = iter.next();
			old_side = side;

			side =
					getSideToWhichPointBelongs(
							point.getX(), point.getY(), x1, y1, x2, y2);
			
			if (side == null)
				return false;
			
			if (old_side != side && direction == 0) {

				direction = (side.ordinal() - old_side.ordinal()) / 2;

				if (direction < -1)
					direction = 1;
				else if (direction > 1)
					direction = -1;
			}
			
			if (old_side != side) {
				if (edgeJumpInDirection(side, old_side, direction))
					continue;
				
				if ((old_side.ordinal() + direction) % Side.values().length != side
							.ordinal())
					return false;
			}
		}

		return true;
	}

	private static boolean edgeJumpInDirection(Side side, Side old_side,
			int direction) {

		if (side.ordinal() % 2 == 0)
			return false;

		int tmp_val = (side.ordinal() - old_side.ordinal()) / 2;
		if (tmp_val < -1)
			tmp_val = 1;

		return tmp_val == direction;
	}

	private static Side getSideToWhichPointBelongs(double x, double y,
			double x1, double y1, double x2, double y2) {
		if (x == x2 && y == y1)
			return Side.UPPER_RIGHT;
		else if (x == x2 && y == y2)
			return Side.BOTTOM_RIGHT;
		else if (x == x1 && y == y2)
			return Side.BOTTOM_LEFT;
		else if (x == x1 && y == y1)
			return Side.UPPER_LEFT;
		else if (checkIfBelongsToLine(x, y, x1, y1, x2, y1))
			return Side.UPPER;
		else if (checkIfBelongsToLine(x, y, x2, y1, x2, y2))
			return Side.RIGHT;
		else if (checkIfBelongsToLine(x, y, x2, y2, x1, y2))
			return Side.BOTTOM;
		else if (checkIfBelongsToLine(x, y, x1, y2, x1, y1))
			return Side.LEFT;
		
		return null;
	}

	private static boolean checkIfBelongsToLine(double whatX, double whatY,
			double whereX1, double whereY1, double whereX2, double whereY2) {

		if (whereX1 == whereX2) {
			if (whatX == whereX1) {
				if (whatY >= whereY1 && whatY <= whereY2 ||
						whatY <= whereY1 && whatY >= whereY2)
					return true;
			}
			return false;
		}

		if (whereY1 == whereY2) {
			if (whatY == whereY1) {
				if (whatX >= whereX1 && whatX <= whereX2 ||
						whatX <= whereX1 && whatX >= whereX2)
					return true;
			}
			return false;
		}

		return false;
	}
}
