package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/**
 * Allows user to iterate over
 * {@link cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree}s.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class QuadTreePostorderIterator implements Iterator<QuadTreeNode> {

	private QuadTree tree;
	private QuadTreeNode node = null;
	private boolean finished = false;
	private QuadTreeNode root = null;
	private final LinkedList<Integer> branching = new LinkedList<Integer>();

	public QuadTreePostorderIterator(QuadTree tree) {
		if (tree == null)
			throw new IllegalArgumentException("Tree cannot be null");

		this.tree = tree;
		this.setRoot(tree.getRoot());

	}

	@Override
	public boolean hasNext() {

		if (isFinished())
			return false;

		if (getNode() == null) {
			if (getRoot() == null) {
				return false;
			} else {
				return true;
			}
		}

		return true;
	}

	@Override
	public QuadTreeNode next() {

		if (getNode() == null) {
			if (isFinished() || getRoot() == null) {
				throw new NoSuchElementException(
						"No more elements in iterated QuadTree");
			} else {
				setNode(getRoot());

				while (getNode().getNodes() != null) {
					setNode(getNode().getFirst());
					getBranching().add(0);
				}

				if (getNode() == getRoot()) {
					setFinished(true);
				}

				return getNode();
			}
		} // else node != null

		if (getNode() == getRoot()) {
			setFinished(true);
			return getRoot();
		} else {
			setNode(getNode().getParent());

			int next = getBranching().pollLast();

			if (next == 3) {

				if (getNode() == getRoot())
					setFinished(true);

				return getNode();
			} else {

				getBranching().add(++next);
				setNode(getNode().getNodes()[next]);

				while (getNode().getNodes() != null) {
					setNode(getNode().getFirst());
					getBranching().add(0);
				}

				return getNode();
			}
		}
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException(
				"QuadTreeIterator does not support remove() method.");
	}

	protected LinkedList<Integer> getBranching() {
		return branching;
	}

	protected void setNode(QuadTreeNode node) {
		this.node = node;
	}

	protected QuadTreeNode getNode() {
		return node;
	}

	protected void setRoot(QuadTreeNode root) {
		this.root = root;
	}

	protected QuadTreeNode getRoot() {
		return root;
	}

	protected void setFinished(boolean finished) {
		this.finished = finished;
	}

	protected boolean isFinished() {
		return finished;
	}

}
