package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * One of the game options. Might be accessed through {@link GameInfo#GetOptionValue()},
 * {@link GameOption} and {@link GameInfo#getGameSpeed()}.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum GameSpeed {
	
	PAUSED(0),
	REALTIME(1),
	SLOW(5),
	MEDIUM(10),
	FAST(20);
	
	private static Map<Integer, GameSpeed> enums = new HashMap<Integer, GameSpeed>();
	
	public static GameSpeed getEnum(int factor) {
		return enums.get(factor);
	}
	
	static {
		for (GameSpeed item : GameSpeed.values()) {
			enums.put(item.factor, item);
		}
	}
	
	public final int factor;
	
	private GameSpeed(int factor) {
		this.factor = factor;
	}

}
