package cz.cuni.amis.pogamut.defcon.agent.impl;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentController;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.communication.command.impl.DefConAct;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;

/**
 * Basic implementation of controller, does some basic stuff like assigning of logger
 * @author Radek 'Black_Hand' Pibil
 *
 * @param <AGENT> Controlled agent
 */
@AgentScoped
public class DefConAgentController<AGENT extends DefConAgent>
	implements IDefConAgentController<AGENT> {

    private static final String USER_LOG_ID = "User";

	protected AGENT agent;
	
    /**
     * User log.
     */
    private LogCategory user = null;
    
    @Inject
    public DefConAgentController() {
    
    }

    @Override
	public void initializeController(AGENT agent) {
		this.agent = agent;
        user = agent.getLogger().getCategory(USER_LOG_ID);
	}

	@Override
	public void botStopped() {
	}
	
	/**
	 * Casts worldview into a friendlier type.
	 * @return WorldView
	 */
	public DefConWorldView getWorldView() {
		return (DefConWorldView) agent.getWorldView();
	}
	
	/**
	 * Returns the game info object used to query the game.
	 * 
	 * @return
	 */
	public GameInfo getGameInfo() {
		return (GameInfo) getWorldView().getGameInfo();
	}
	
	public DefConAct getAct() {
		return (DefConAct) agent.getAct();
	}
	
	/**
	 * Simplifies access to IAct. No need to use getAct().act().
	 */
	public void act(DefConCommand command) {
		agent.act(command);
	}	

    /**
     * Returns user logger. This call is equivalent to <code>bot.getLogger().getCategory(USER_LOG_ID)</code>.
     * @return
     */
    public LogCategory getLog() {
        return user;
    }
	
}
